/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.contract;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.contract.facade.GetContractResultReq;
import io.nuls.base.data.NulsHash;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.ErrorCodeConstants;
import io.nuls.cmd.client.processor.contract.ContractBaseProcessor;
import io.nuls.cmd.client.utils.Na;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;
import java.util.Map;

@Component
public class GetContractResultProcessor
extends ContractBaseProcessor {
    @Override
    public String getCommand() {
        return "getcontractresult";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<hash>  transaction hash -required");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getcontractresult <hash> --get the contract execute result of the transaction by txhash";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkArgs(NulsHash.validHash((String)args[1]), "hash format error");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String hash = args[1];
        if (StringUtils.isBlank((String)hash)) {
            return CommandResult.getFailed(ErrorCodeConstants.PARAM_ERR.getMsg());
        }
        Result result = this.contractProvider.getContractResult(new GetContractResultReq(hash));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        Map map = (Map)result.getData();
        Map dataMap = (Map)map.get("data");
        if (dataMap != null) {
            dataMap.put("totalFee", Na.naToNuls(dataMap.get("totalFee"), this.config.getDecimals()));
            dataMap.put("txSizeFee", Na.naToNuls(dataMap.get("txSizeFee"), this.config.getDecimals()));
            dataMap.put("actualContractFee", Na.naToNuls(dataMap.get("actualContractFee"), this.config.getDecimals()));
            dataMap.put("refundFee", Na.naToNuls(dataMap.get("refundFee"), this.config.getDecimals()));
            dataMap.put("value", Na.naToNuls(dataMap.get("value"), this.config.getDecimals()));
            dataMap.put("price", Na.naToNuls(dataMap.get("price"), this.config.getDecimals()));
        }
        result.setData((Object)dataMap);
        return CommandResult.getResult(result);
    }
}

