/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.contract;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.contract.facade.ViewContractReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.contract.ContractBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class ViewContractProcessor
extends ContractBaseProcessor {
    private ThreadLocal<ViewContractReq> paramsData = new ThreadLocal();

    @Override
    public String getCommand() {
        return "viewcontract";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<contractAddress>   contract address    -required").newLine("\t<methodName>        the method to call    -required").newLine("\t[-d methodDesc]        the method description    -not required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "viewcontract <contractAddress> <methodName> [-d methodDesc] --view contract";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 2, 3);
        this.checkAddress(this.config.getChainId(), args[1]);
        ViewContractReq form = this.getContractViewCall(args);
        if (null == form) {
            return false;
        }
        this.paramsData.set(form);
        return true;
    }

    private ViewContractReq getContractViewCall(String[] args) {
        try {
            ViewContractReq call = new ViewContractReq();
            call.setContractAddress(args[1].trim());
            call.setMethodName(args[2].trim());
            if (args.length == 5) {
                String argType = args[3].trim();
                if ("-d".equals(argType)) {
                    call.setMethodDesc(args[4].trim());
                } else {
                    return null;
                }
            }
            return call;
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return null;
        }
    }

    @Override
    public CommandResult execute(String[] args) {
        ViewContractReq form = this.paramsData.get();
        if (null == form) {
            form = this.getContractViewCall(args);
        }
        if (null == form) {
            return CommandResult.getFailed("parameter error.");
        }
        form.setArgs(this.getContractCallArgsJson());
        Result result = this.contractProvider.viewContract(form);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getResult(result);
    }
}

