/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.crosschain;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.crosschain.facade.CreateCrossTxReq;
import io.nuls.base.basic.AddressTool;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.crosschain.CrossChainBaseProcessor;
import io.nuls.cmd.client.utils.AssetsUtil;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Component;
import java.math.BigDecimal;
import java.math.BigInteger;

@Component
public class CreateCrossTxProcessor
extends CrossChainBaseProcessor {
    @Override
    public String getCommand() {
        return "createcrosstx";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<formAddress>  source address - require").newLine("\t<toAddress>  target address - require").newLine("\t<assetChainId> transaction asset chainId - require").newLine("\t<assetId> transaction assetId - require").newLine("\t<amount> \t\tamount - required").newLine("\t[remark] \t\tremark ").newLine("\t[password] \t\tpassword");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "createcrosstx <formAddress> <toAddress> <assetChainId> <assetId> <amount> [remark] [password]--create cross chain tx";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 5, 6, 7);
        this.checkAddress(this.config.getChainId(), args[1]);
        this.checkArgs(AddressTool.getChainIdByAddress((String)args[2]) != this.config.getChainId(), ErrorCode.init((String)"cc_0001").getMsg());
        this.checkIsNumeric(args[3], "assetChainId");
        this.checkIsNumeric(args[4], "assetId");
        this.checkIsAmount(args[5], "amount");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result;
        Integer chainId = this.config.getChainId();
        String formAddress = args[1];
        String toAddress = args[2];
        Integer assetChainId = Integer.parseInt(args[3]);
        Integer assetId = Integer.parseInt(args[4]);
        Integer decimalInt = AssetsUtil.getCrossAssetDecimal(assetChainId, assetId);
        if (null == decimalInt) {
            return CommandResult.getFailed("cross asset info not exist.");
        }
        BigDecimal decimal = BigDecimal.TEN.pow(decimalInt);
        BigInteger amount = new BigDecimal(args[5]).multiply(decimal).toBigInteger();
        String remark = null;
        String password = null;
        if (args.length == 7) {
            remark = args[6];
        }
        if ((result = this.crossChainProvider.createCrossTx(new CreateCrossTxReq.CreateCrossTxReqBuilder(chainId).addForm(assetChainId, assetId, formAddress, password = args.length == 8 ? args[7] : this.getPwd(), amount).addTo(assetChainId, assetId, toAddress, amount).setRemark(remark).build())).isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess((String)result.getData());
    }
}

