/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.crosschain;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.crosschain.facade.AddCrossAssetReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.crosschain.CrossChainBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class CrossAssetAddProcessor
extends CrossChainBaseProcessor {
    @Override
    public String getCommand() {
        return "addcrossasset";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<regAddress>  register cross asset address - require").newLine("\t<assetChainId>  add asset chainId - require").newLine("\t<assetId> add assetId - require").newLine("\t<assetName> asset name - require").newLine("\t<symbol> asset symbol - require").newLine("\t<initNumber> asset init Number - require").newLine("\t<decimalPlaces> asset init Number - require");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "addcrossasset <regAddress> <assetChainId> <assetId> <assetName> <symbol> <initNumber> <decimalPlaces>--add cross chain asset";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 7);
        this.checkAddress(this.config.getMainChainId(), args[1]);
        this.checkIsNumeric(args[2], "assetChainId");
        this.checkIsNumeric(args[3], "assetId");
        this.checkIsAmount(args[6], "initNumber");
        this.checkIsAmount(args[7], "decimalPlaces");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        int decimalPlaces;
        long initNumber;
        String assetName;
        String symbol;
        Integer assetId;
        String address = args[1];
        Integer assetChainId = Integer.parseInt(args[2]);
        AddCrossAssetReq req = new AddCrossAssetReq(address, assetChainId, assetId = Integer.valueOf(Integer.parseInt(args[3])), symbol = args[5], assetName = args[4], initNumber = Long.valueOf(args[6]).longValue(), decimalPlaces = Integer.parseInt(args[7]), this.getPwd());
        Result result = this.chainManageProvider.addCrossAsset(req);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess((String)result.getData());
    }
}

