/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.ledger;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.ledger.LedgerProvider;
import io.nuls.base.api.provider.ledger.facade.ContractAsset;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;

@Component
public class GetContractCrossAssetProcessor
implements CommandProcessor {
    LedgerProvider ledgerProvider = (LedgerProvider)ServiceManager.get(LedgerProvider.class);
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "getContractAsset";
    }

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.Ledger;
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address> the contract address - require");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getContractAsset <address>--get the assetId by contract address";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkAddress(this.config.getChainId(), args[1]);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        Result result = this.ledgerProvider.getContractAsset(new ContractAsset(address));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

