/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.cmd;

import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.rpc.model.ConfigItem;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;

public abstract class BaseCmd {
    protected void setConfigItem(String key, Object value, boolean readOnly) {
        ConfigItem configItem = new ConfigItem(key, value, readOnly);
        ConnectManager.CONFIG_ITEM_MAP.put(key, configItem);
    }

    protected Response success() {
        return this.success(null);
    }

    protected Response success(Object responseData) {
        Response response = MessageUtil.newSuccessResponse("", "success");
        response.setResponseData(responseData);
        return response;
    }

    protected Response failed(ErrorCode errorCode) {
        return MessageUtil.newFailResponse("", errorCode);
    }

    protected Response failed(String errMsg) {
        return this.failed(CommonCodeConstanst.FAILED, errMsg);
    }

    protected Response failed(ErrorCode errorCode, String errMsg) {
        Response response = MessageUtil.newFailResponse("", errMsg);
        response.setResponseErrorCode(errorCode.getCode());
        return response;
    }
}

