/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.info;

import io.nuls.core.log.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Random;

public class HostInfo {
    public static String getLocalIP() {
        try {
            if (HostInfo.isWindowsOS()) {
                return InetAddress.getLocalHost().getHostAddress();
            }
            return HostInfo.getLinuxLocalIp();
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return "";
        }
    }

    private static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        String windows = "windows";
        if (osName.toLowerCase().contains(windows)) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    private static String getLinuxLocalIp() throws SocketException {
        String ip = "";
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface networkInterface = en.nextElement();
            String name = networkInterface.getName();
            if (name.contains("docker") || name.contains("lo")) continue;
            Enumeration<InetAddress> enumIpAddress = networkInterface.getInetAddresses();
            while (enumIpAddress.hasMoreElements()) {
                String ipAddress;
                InetAddress inetAddress = enumIpAddress.nextElement();
                if (inetAddress.isLoopbackAddress() || (ipAddress = inetAddress.getHostAddress()).contains("::") || ipAddress.contains("0:0:") || ipAddress.contains("fe80") || "127.0.0.1".equals(ip) || ipAddress.length() > 16) continue;
                ip = ipAddress;
            }
        }
        return ip;
    }

    public static int randomPort() {
        int min = 10000;
        Random random = new Random();
        int max = 20000;
        int port = random.nextInt(max) % (max - min + 1) + min;
        if (HostInfo.isLocalPortUsing(port)) {
            return HostInfo.randomPort();
        }
        return port;
    }

    private static boolean isLocalPortUsing(int port) {
        try {
            InetAddress address = InetAddress.getByName("127.0.0.1");
            Socket socket = new Socket(address, port);
            socket.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

