/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.model;

import java.util.Arrays;

public enum ModuleE {
    CMD("cmd", "cmd-client", "Nuls"),
    KE("ke", "kernel", "Nuls"),
    CM("cm", "chain-manager", "Nuls"),
    AC("ac", "account", "Nuls"),
    NW("nw", "network", "Nuls"),
    CS("cs", "consensus", "Nuls"),
    BL("bl", "block", "Nuls"),
    LG("lg", "ledger", "Nuls"),
    TX("tx", "transaction", "Nuls"),
    EB("eb", "eventbus", "Nuls"),
    PU("pu", "protocol-update", "Nuls"),
    CC("cc", "cross-chain", "Nuls"),
    SC("sc", "smart-contract", "Nuls"),
    AP("ap", "public-service", "Nuls"),
    NC("nc", "nuls-cores", "Nuls");

    public static final String DOMAIN = "Nuls";
    public final String abbr;
    public final String name;
    public final String domain;
    public final String prefix;

    private ModuleE(String prefix, String name, String domain) {
        this.abbr = name;
        this.name = name.toLowerCase();
        this.domain = domain;
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public static ModuleE valueOfAbbr(String abbr) {
        return Arrays.stream(ModuleE.values()).filter(m -> m.abbr.equals(abbr)).findFirst().orElseThrow(() -> new IllegalArgumentException("can not found abbr of " + abbr));
    }

    public static boolean hasOfAbbr(String abbr) {
        return Arrays.stream(ModuleE.values()).anyMatch(m -> m.abbr.equals(abbr));
    }

    public String toString() {
        return this.domain + "/" + this.name + "/" + this.abbr;
    }

    public static class Constant {
        public static final String KERNEL = "kernel";
        public static final String CHAIN_MANAGER = "chain-manager";
        public static final String ACCOUNT = "account";
        public static final String NETWORK = "network";
        public static final String CONSENSUS = "consensus";
        public static final String BLOCK = "block";
        public static final String LEDGER = "ledger";
        public static final String TRANSACTION = "transaction";
        public static final String EVENT_BUS = "eventbus";
        public static final String PROTOCOL_UPDATE = "protocol-update";
        public static final String CROSS_CHAIN = "cross-chain";
        public static final String SMART_CONTRACT = "smart-contract";
        public static final String PUBLIC_SERVICE = "public-service";
        public static final String CMD = "cmd-client";
        public static final String NULS_CORES = "nuls-cores";
    }
}

