/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.modulebootstrap;

import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.modulebootstrap.RpcModule;
import io.nuls.core.thread.ThreadUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class NulsRpcModuleBootstrap {
    private static final String DEFAULT_SCAN_PACKAGE = "io.nuls";
    private static boolean printLogoed = false;

    public static void main(String[] args) {
        NulsRpcModuleBootstrap.run(args);
    }

    public static void run(String[] args) {
        NulsRpcModuleBootstrap.run(DEFAULT_SCAN_PACKAGE, args);
    }

    public static void run(String scanPackage, String[] args) {
        RpcModule module;
        NulsRpcModuleBootstrap.printLogo("/logo");
        Log.info((String)"RUN MODULE:{}", (Object[])new Object[]{System.getProperty("app.name")});
        SpringLiteContext.init((String[])new String[]{scanPackage, "io.nuls.core.rpc.modulebootstrap", "io.nuls.core.rpc.cmd", "io.nuls.base.protocol"});
        try {
            module = (RpcModule)SpringLiteContext.getBean(RpcModule.class);
        }
        catch (NulsRuntimeException e) {
            Log.error((String)"loadingRpcModuleImplementation class failure for");
            return;
        }
        String debug = "0";
        if (args.length > 1) {
            debug = args[1];
        }
        if ("1".equals(debug)) {
            ThreadUtils.createAndRunThread((String)(module.moduleInfo().getName() + "-thread"), () -> {
                BufferedReader is_reader = new BufferedReader(new InputStreamReader(System.in));
                block12: while (true) {
                    try {
                        String cmd;
                        while ((cmd = is_reader.readLine()) != null) {
                            switch (cmd) {
                                case "f": {
                                    System.out.println("Followers of modules\uff1a");
                                    module.getFollowerList().entrySet().forEach(System.out::println);
                                    continue block12;
                                }
                                case "d": {
                                    System.out.println("List of dependent modules");
                                    module.getDependencies().forEach(d -> System.out.println(d.name + " is ready : " + module.isDependencieReady((Module)d)));
                                    continue block12;
                                }
                                case "s": {
                                    System.out.println("current state\uff1a" + module.getState());
                                    continue block12;
                                }
                            }
                            System.out.println("Wrong input,Please enterf,d,s");
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            });
        }
        module.run(scanPackage, args[0], args);
    }

    public static void printLogo(String logoFile) {
        if (printLogoed) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Class.forName(NulsRpcModuleBootstrap.class.getName()).getResourceAsStream(logoFile)));){
            String line = reader.readLine();
            while (line != null) {
                System.out.println(line);
                line = reader.readLine();
            }
            System.out.println("Module:" + System.getProperty("app.name"));
            System.out.println();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
        }
        printLogoed = true;
    }
}

