/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.netty.bootstrap;

import io.nuls.core.rpc.info.HostInfo;
import io.nuls.core.rpc.model.CmdDetail;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.rpc.netty.thread.StartServerProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class NettyServer {
    public static NettyServer getInstance(ModuleE moduleE) {
        return NettyServer.getInstance(moduleE.abbr, moduleE.name, moduleE.domain);
    }

    public static NettyServer getInstance(String abbr, String name, String domain) {
        int port = HostInfo.randomPort();
        NettyServer.startServer(port);
        ConnectManager.LOCAL.setAbbreviation(abbr);
        ConnectManager.LOCAL.setModuleName(name);
        ConnectManager.LOCAL.setModuleDomain(domain);
        HashMap<String, String> connectionInformation = new HashMap<String, String>(2);
        connectionInformation.put("IP", HostInfo.getLocalIP());
        connectionInformation.put("Port", String.valueOf(port));
        ConnectManager.LOCAL.setConnectionInformation(connectionInformation);
        ConnectManager.LOCAL.setMethods(new ArrayList<CmdDetail>());
        ConnectManager.LOCAL.setDependencies(new HashMap<String, String>(8));
        ConnectManager.LOCAL.setModuleRoles(new HashMap<String, String[]>(1));
        return new NettyServer();
    }

    public static void startServer(int port, String host, String path) {
        Thread serverThread = new Thread(new StartServerProcessor(port, host, path));
        serverThread.start();
    }

    public static void startServer(int port) {
        Thread serverThread = new Thread(new StartServerProcessor(port));
        serverThread.start();
    }

    public NettyServer dependencies(String key, String value) {
        ConnectManager.LOCAL.getDependencies().put(key, value);
        return this;
    }

    public NettyServer moduleRoles(String[] value) {
        ConnectManager.LOCAL.getModuleRoles().put(ConnectManager.LOCAL.getAbbreviation(), value);
        return this;
    }

    public NettyServer moduleRoles(String key, String[] value) {
        ConnectManager.LOCAL.getModuleRoles().put(key, value);
        return this;
    }

    public NettyServer moduleVersion(String moduleVersion) {
        ConnectManager.LOCAL.setModuleVersion(moduleVersion);
        return this;
    }

    public NettyServer scanPackage(Set<String> scanPackage) throws Exception {
        ConnectManager.scanPackage(scanPackage);
        return this;
    }

    public NettyServer addCmdDetail(Class<?> cmdClass) {
        ConnectManager.addCmdDetail(cmdClass);
        return this;
    }
}

