/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.CharsetUtil;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.info.Constants;
import io.nuls.core.rpc.model.CmdPriority;
import io.nuls.core.rpc.model.RequestOnly;
import io.nuls.core.rpc.model.message.Message;
import io.nuls.core.rpc.model.message.MessageType;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.netty.channel.ConnectData;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.rpc.netty.handler.message.TextMessageHandler;
import io.nuls.core.thread.commom.NulsThreadFactory;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ClientHandler
extends SimpleChannelInboundHandler<Object> {
    private WebSocketClientHandshaker handShaker;
    private ChannelPromise handshakeFuture;
    private ThreadPoolExecutor requestExecutorService = new ThreadPoolExecutor(Constants.THREAD_POOL_SIZE, Constants.THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), (ThreadFactory)new NulsThreadFactory("server-handler-request"));
    private ThreadPoolExecutor responseExecutorService = new ThreadPoolExecutor(Constants.THREAD_POOL_SIZE, Constants.THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), (ThreadFactory)new NulsThreadFactory("server-handler-request"));

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public WebSocketClientHandshaker getHandshaker() {
        return this.handShaker;
    }

    public void setHandshaker(WebSocketClientHandshaker handShaker) {
        this.handShaker = handShaker;
    }

    public ChannelPromise getHandshakeFuture() {
        return this.handshakeFuture;
    }

    public void setHandshakeFuture(ChannelPromise handshakeFuture) {
        this.handshakeFuture = handshakeFuture;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public ClientHandler(WebSocketClientHandshaker handShaker) {
        this.handShaker = handShaker;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handShaker.handshake(ctx.channel());
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (!this.handShaker.isHandshakeComplete()) {
            try {
                FullHttpResponse response = (FullHttpResponse)msg;
                this.handShaker.finishHandshake(ch, response);
                this.handshakeFuture.setSuccess();
                Log.debug((String)("WebSocket Client connected! response headers[sec-webSocket-extensions]:{}" + response.headers()));
            }
            catch (WebSocketHandshakeException var7) {
                FullHttpResponse res = (FullHttpResponse)msg;
                String errorMsg = String.format("WebSocket Client failed to connect,status:%s,reason:%s", res.status(), res.content().toString(CharsetUtil.UTF_8));
                this.handshakeFuture.setFailure((Throwable)new Exception(errorMsg));
            }
        } else {
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ")");
            }
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof CloseWebSocketFrame) {
                ch.close();
            } else if (msg instanceof TextWebSocketFrame) {
                TextWebSocketFrame txMsg = (TextWebSocketFrame)msg;
                ByteBuf content = txMsg.content();
                byte[] bytes = new byte[content.readableBytes()];
                content.readBytes(bytes);
                Message message = (Message)JSONUtils.byteArray2pojo((byte[])bytes, Message.class);
                MessageType messageType = MessageType.valueOf(message.getMessageType());
                int priority = CmdPriority.DEFAULT.getPriority();
                TextMessageHandler messageHandler = new TextMessageHandler((SocketChannel)ctx.channel(), message, priority);
                if (messageType.equals((Object)MessageType.Response) || messageType.equals((Object)MessageType.NegotiateConnectionResponse) || messageType.equals((Object)MessageType.Ack)) {
                    this.responseExecutorService.execute(messageHandler);
                } else if (messageType.equals((Object)MessageType.Request)) {
                    Request request = (Request)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), Request.class);
                    if (request.getRequestMethods().size() == 1) {
                        for (String cmd : request.getRequestMethods().keySet()) {
                            if (!ConnectManager.CMD_PRIORITY_MAP.containsKey(cmd)) continue;
                            messageHandler.setPriority(ConnectManager.CMD_PRIORITY_MAP.get(cmd));
                        }
                    }
                    messageHandler.setRequest(request);
                    this.requestExecutorService.execute(messageHandler);
                } else if (messageType.equals((Object)MessageType.RequestOnly)) {
                    Request request = (Request)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), Request.class);
                    ConnectData connectData = ConnectManager.CHANNEL_DATA_MAP.get(ctx.channel());
                    int messageSize = bytes.length;
                    if (!connectData.requestOnlyQueueReachLimit()) {
                        connectData.getRequestOnlyQueue().offer(new RequestOnly(request, messageSize));
                        connectData.addRequestOnlyQueueMemSize(messageSize);
                    } else {
                        Log.debug((String)"RequestOnlyThe queue cache is full, discarding newly received messages,messageId:{},Memory occupied by queue\uff1a{}", (Object[])new Object[]{message.getMessageID(), connectData.getRequestOnlyQueueMemSize()});
                    }
                } else {
                    this.requestExecutorService.execute(messageHandler);
                }
            } else {
                Log.warn((String)"Unsupported message format");
            }
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ConnectManager.disConnect((SocketChannel)ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }
}

