/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.netty.handler.message;

import io.netty.channel.Channel;
import io.netty.channel.socket.SocketChannel;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.message.Message;
import io.nuls.core.rpc.model.message.MessageType;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.channel.ConnectData;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.rpc.netty.processor.RequestMessageProcessor;
import io.nuls.core.rpc.netty.processor.container.RequestContainer;
import io.nuls.core.rpc.netty.processor.container.ResponseContainer;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TextMessageHandler
implements Runnable,
Comparable<TextMessageHandler> {
    private SocketChannel channel;
    private Message message;
    private int priority;
    private Request request;
    private int messageSize;

    public TextMessageHandler(SocketChannel channel, Message message, int priority) {
        this.channel = channel;
        this.message = message;
        this.priority = priority;
    }

    @Override
    public int compareTo(TextMessageHandler o) {
        return Integer.compare(o.priority, this.priority);
    }

    @Override
    public void run() {
        this.handler();
    }

    private void handler() {
        try {
            ConnectData connectData = ConnectManager.CHANNEL_DATA_MAP.get(this.channel);
            switch (MessageType.valueOf(this.message.getMessageType())) {
                case NegotiateConnection: {
                    RequestMessageProcessor.negotiateConnectionResponse((Channel)this.channel, this.message);
                    break;
                }
                case Unsubscribe: {
                    RequestMessageProcessor.unsubscribe(connectData, this.message);
                    break;
                }
                case Request: {
                    String messageId = this.message.getMessageID();
                    if (!ConnectManager.isPureDigital(this.request.getSubscriptionEventCounter()) && !ConnectManager.isPureDigital(this.request.getSubscriptionPeriod())) {
                        if (null == this.request.getTimeOut() || this.request.getTimeOut().isEmpty()) {
                            RequestMessageProcessor.callCommandsWithPeriod((Channel)this.channel, this.request.getRequestMethods(), messageId, false);
                        } else {
                            long requestTime = Long.parseLong(this.message.getTimestamp());
                            long timeOut = Long.parseLong(this.request.getTimeOut());
                            long currentTime = System.currentTimeMillis();
                            if (timeOut == 0L || currentTime < requestTime + timeOut) {
                                RequestMessageProcessor.callCommandsWithPeriod((Channel)this.channel, this.request.getRequestMethods(), messageId, false);
                            } else {
                                Log.debug((String)"Request timeout discarding request, current time\uff1a{}Request time:{},Timeout time:{},Request Method\uff1a{}", (Object[])new Object[]{currentTime, requestTime, timeOut, this.request.getRequestMethods()});
                            }
                        }
                    } else {
                        for (int tryCount = 0; connectData == null && tryCount < 3; ++tryCount) {
                            TimeUnit.SECONDS.sleep(2L);
                            connectData = ConnectManager.CHANNEL_DATA_MAP.get(this.channel);
                        }
                        if (connectData == null) {
                            RequestMessageProcessor.serviceNotStarted((Channel)this.channel, messageId);
                            break;
                        }
                        if (ConnectManager.isPureDigital(this.request.getSubscriptionPeriod())) {
                            connectData.getRequestPeriodLoopQueue().offer(new Object[]{this.message, this.request});
                            connectData.getIdToPeriodMessageMap().put(messageId, this.message);
                        }
                        if (ConnectManager.isPureDigital(this.request.getSubscriptionEventCounter())) {
                            connectData.subscribeByEvent(this.message, this.request);
                            RequestMessageProcessor.callCommandsWithPeriod((Channel)this.channel, this.request.getRequestMethods(), messageId, true);
                        }
                    }
                    if (!"1".equals(this.request.getRequestAck())) break;
                    RequestMessageProcessor.ack((Channel)this.channel, messageId);
                    break;
                }
                case NegotiateConnectionResponse: 
                case Ack: {
                    ResponseContainer resContainer = RequestContainer.getResponseContainer((String)((Map)this.message.getMessageData()).get("RequestID"));
                    if (resContainer == null || resContainer.getFuture() == null) break;
                    resContainer.getFuture().complete(new Response());
                    break;
                }
                case Response: {
                    Response response = (Response)JSONUtils.map2pojo((Map)((Map)this.message.getMessageData()), Response.class);
                    if (ConnectManager.INVOKE_MAP.containsKey(response.getRequestID())) {
                        connectData.getResponseAutoQueue().offer(response);
                        break;
                    }
                    ResponseContainer responseContainer = RequestContainer.getResponseContainer(response.getRequestID());
                    if (responseContainer != null && responseContainer.getFuture() != null) {
                        responseContainer.getFuture().complete(response);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }
}

