/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.service;

import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.v2.error.AccountErrorCode;
import io.nuls.v2.model.dto.CreateAgentForm;
import io.nuls.v2.model.dto.DepositForm;
import io.nuls.v2.model.dto.RestFulResult;
import io.nuls.v2.model.dto.StopAgentForm;
import io.nuls.v2.model.dto.WithdrawForm;
import io.nuls.v2.util.CommonValidator;
import io.nuls.v2.util.RestFulUtil;
import io.nuls.v2.util.ValidateUtil;
import java.util.HashMap;
import java.util.List;

public class ConsensusService {
    private static ConsensusService instance = new ConsensusService();

    private ConsensusService() {
    }

    public static ConsensusService getInstance() {
        return instance;
    }

    public Result createAgent(CreateAgentForm form) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            CommonValidator.validateCreateAgentForm(form);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("agentAddress", form.getAgentAddress());
            map.put("packingAddress", form.getPackingAddress());
            map.put("rewardAddress", form.getRewardAddress());
            map.put("commissionRate", form.getCommissionRate());
            map.put("deposit", form.getDeposit());
            map.put("password", form.getPassword());
            RestFulResult restFulResult = RestFulUtil.post("api/consensus/agent", map);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result stopAgent(StopAgentForm form) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            CommonValidator.validateStopAgentForm(form);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("address", form.getAgentAddress());
            map.put("password", form.getPassword());
            RestFulResult restFulResult = RestFulUtil.post("api/consensus/agent/stop", map);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result depositToAgent(DepositForm form) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            CommonValidator.validateDepositForm(form);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("address", form.getAddress());
            map.put("agentHash", form.getAgentHash());
            map.put("deposit", form.getDeposit());
            map.put("password", form.getPassword());
            RestFulResult restFulResult = RestFulUtil.post("api/consensus/deposit", map);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result withdraw(WithdrawForm form) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            CommonValidator.validateWithDrawForm(form);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("address", form.getAddress());
            map.put("txHash", form.getTxHash());
            map.put("password", form.getPassword());
            RestFulResult restFulResult = RestFulUtil.post("api/consensus/withdraw", map);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result getDepositList(String agentHash) {
        Result result;
        if (!ValidateUtil.validHash(agentHash)) {
            return Result.getFailed((ErrorCode)AccountErrorCode.PARAMETER_ERROR);
        }
        RestFulResult<List<Object>> restFulResult = RestFulUtil.getList("api/consensus/list/deposit/" + agentHash, null);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }
}

