/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.service;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.MultiSignTxSignature;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import io.nuls.v2.SDKContext;
import io.nuls.v2.constant.AccountConstant;
import io.nuls.v2.error.AccountErrorCode;
import io.nuls.v2.model.dto.AliasDto;
import io.nuls.v2.model.dto.CoinFromDto;
import io.nuls.v2.model.dto.CoinToDto;
import io.nuls.v2.model.dto.ConsensusDto;
import io.nuls.v2.model.dto.CrossTransferForm;
import io.nuls.v2.model.dto.CrossTransferTxFeeDto;
import io.nuls.v2.model.dto.DepositDto;
import io.nuls.v2.model.dto.MultiSignAliasDto;
import io.nuls.v2.model.dto.MultiSignConsensusDto;
import io.nuls.v2.model.dto.MultiSignDepositDto;
import io.nuls.v2.model.dto.MultiSignStopConsensusDto;
import io.nuls.v2.model.dto.MultiSignTransferDto;
import io.nuls.v2.model.dto.MultiSignTransferTxFeeDto;
import io.nuls.v2.model.dto.MultiSignWithDrawDto;
import io.nuls.v2.model.dto.RestFulResult;
import io.nuls.v2.model.dto.RpcResult;
import io.nuls.v2.model.dto.RpcResultError;
import io.nuls.v2.model.dto.SignDto;
import io.nuls.v2.model.dto.StopConsensusDto;
import io.nuls.v2.model.dto.StopDepositDto;
import io.nuls.v2.model.dto.TransactionDto;
import io.nuls.v2.model.dto.TransferDto;
import io.nuls.v2.model.dto.TransferForm;
import io.nuls.v2.model.dto.TransferTxFeeDto;
import io.nuls.v2.model.dto.WithDrawDto;
import io.nuls.v2.txdata.Agent;
import io.nuls.v2.txdata.Alias;
import io.nuls.v2.txdata.CancelDeposit;
import io.nuls.v2.txdata.Deposit;
import io.nuls.v2.txdata.StopAgent;
import io.nuls.v2.util.AccountTool;
import io.nuls.v2.util.CommonValidator;
import io.nuls.v2.util.JsonRpcUtil;
import io.nuls.v2.util.ListUtil;
import io.nuls.v2.util.NulsSDKTool;
import io.nuls.v2.util.RestFulUtil;
import io.nuls.v2.util.TxUtils;
import io.nuls.v2.util.ValidateUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TransactionService {
    private static TransactionService instance = new TransactionService();

    private TransactionService() {
    }

    public static TransactionService getInstance() {
        return instance;
    }

    public Result getTx(String txHash) {
        Result result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/tx/" + txHash);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            TransactionDto tx = TransactionDto.mapToPojo(map);
            result.setData((Object)tx);
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result getTransaction(String txHash) {
        Result result;
        ValidateUtil.validateChainId();
        RestFulResult<Map<String, Object>> restFulResult = RestFulUtil.get("api/tx/" + txHash);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(null);
            Map<String, Object> map = restFulResult.getData();
            TransactionDto tx = TransactionDto.mapToPojo(map);
            restFulResult = RestFulUtil.get("api/block/header/height/" + tx.getBlockHeight());
            if (restFulResult.isSuccess()) {
                map = restFulResult.getData();
                tx.setBlockHash((String)map.get("hash"));
            }
            result.setData((Object)tx);
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result transfer(TransferForm transferForm) {
        Result result;
        ValidateUtil.validateChainId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("address", transferForm.getAddress());
        params.put("toAddress", transferForm.getToAddress());
        params.put("password", transferForm.getPassword());
        params.put("amount", transferForm.getAmount());
        params.put("remark", transferForm.getRemark());
        RestFulResult restFulResult = RestFulUtil.post("api/accountledger/transfer", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public Result crossTransfer(CrossTransferForm form) {
        Result result;
        ValidateUtil.validateChainId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("address", form.getAddress());
        params.put("toAddress", form.getToAddress());
        params.put("password", form.getPassword());
        params.put("assetChainId", form.getAssetChainId());
        params.put("assetId", form.getAssetId());
        params.put("amount", form.getAmount());
        params.put("remark", form.getRemark());
        RestFulResult restFulResult = RestFulUtil.post("api/accountledger/crossTransfer", params);
        if (restFulResult.isSuccess()) {
            result = Result.getSuccess(restFulResult.getData());
        } else {
            ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
            result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
        }
        return result;
    }

    public BigInteger calcTransferTxFee(TransferTxFeeDto dto) {
        if (dto.getPrice() == null) {
            dto.setPrice(SDKContext.NULS_DEFAULT_NORMAL_TX_FEE_PRICE);
        }
        return TxUtils.calcTransferTxFee(dto.getAddressCount(), dto.getFromLength(), dto.getToLength(), dto.getRemark(), dto.getPrice());
    }

    @Deprecated
    public Map<String, BigInteger> calcCrossTransferTxFee(CrossTransferTxFeeDto dto) {
        boolean isMainNet = false;
        if (SDKContext.main_chain_id == 1 || SDKContext.main_chain_id == 2) {
            isMainNet = true;
        }
        return TxUtils.calcCrossTxFee(dto.getAddressCount(), dto.getFromLength(), dto.getToLength(), dto.getRemark(), isMainNet);
    }

    public BigInteger calcCrossTransferNulsTxFee(CrossTransferTxFeeDto dto) {
        return TxUtils.calcCrossTxFee(dto.getAddressCount(), dto.getFromLength(), dto.getToLength(), dto.getRemark());
    }

    public Result createTxSimpleTransferOfNonNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount) {
        return this.createTxSimpleTransferOfNonNuls(fromAddress, toAddress, assetChainId, assetId, amount, 0L, null);
    }

    public Result createTxSimpleTransferOfNonNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount, long time, String remark) {
        Result accountBalanceR = NulsSDKTool.getAccountBalance(fromAddress, assetChainId, assetId);
        if (!accountBalanceR.isSuccess()) {
            return Result.getFailed((ErrorCode)accountBalanceR.getErrorCode()).setMsg(accountBalanceR.getMsg());
        }
        Map balance = (Map)accountBalanceR.getData();
        BigInteger senderBalance = new BigInteger(balance.get("available").toString());
        if (senderBalance.compareTo(amount) < 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.INSUFFICIENT_BALANCE);
        }
        String nonce = balance.get("nonce").toString();
        TransferDto transferDto = new TransferDto();
        ArrayList<CoinFromDto> inputs = new ArrayList<CoinFromDto>();
        CoinFromDto from = new CoinFromDto();
        from.setAddress(fromAddress);
        from.setAmount(amount);
        from.setAssetChainId(assetChainId);
        from.setAssetId(assetId);
        from.setNonce(nonce);
        inputs.add(from);
        Result accountBalanceFeeR = NulsSDKTool.getAccountBalance(fromAddress, SDKContext.main_chain_id, SDKContext.main_asset_id);
        if (!accountBalanceFeeR.isSuccess()) {
            return Result.getFailed((ErrorCode)accountBalanceFeeR.getErrorCode()).setMsg(accountBalanceFeeR.getMsg());
        }
        Map balanceFee = (Map)accountBalanceFeeR.getData();
        BigInteger senderBalanceFee = new BigInteger(balanceFee.get("available").toString());
        TransferTxFeeDto feeDto = new TransferTxFeeDto();
        feeDto.setAddressCount(1);
        feeDto.setFromLength(2);
        feeDto.setToLength(1);
        feeDto.setRemark(remark);
        BigInteger feeNeed = NulsSDKTool.calcTransferTxFee(feeDto);
        if (senderBalanceFee.compareTo(feeNeed) < 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.INSUFFICIENT_FEE);
        }
        String nonceFee = balanceFee.get("nonce").toString();
        CoinFromDto fromFee = new CoinFromDto();
        fromFee.setAddress(fromAddress);
        fromFee.setAmount(feeNeed);
        fromFee.setAssetChainId(SDKContext.main_chain_id);
        fromFee.setAssetId(SDKContext.main_asset_id);
        fromFee.setNonce(nonceFee);
        inputs.add(fromFee);
        ArrayList<CoinToDto> outputs = new ArrayList<CoinToDto>();
        CoinToDto to = new CoinToDto();
        to.setAddress(toAddress);
        to.setAmount(amount);
        to.setAssetChainId(assetChainId);
        to.setAssetId(assetId);
        outputs.add(to);
        transferDto.setInputs(inputs);
        transferDto.setOutputs(outputs);
        transferDto.setTime(time);
        transferDto.setRemark(remark);
        return this.createTransferTx(transferDto);
    }

    public Result createTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount) {
        return this.createTxSimpleTransferOfNuls(fromAddress, toAddress, amount, 0L, null);
    }

    public Result createTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount, long time, String remark) {
        Result accountBalanceR = NulsSDKTool.getAccountBalance(fromAddress, SDKContext.main_chain_id, SDKContext.main_asset_id);
        if (!accountBalanceR.isSuccess()) {
            return Result.getFailed((ErrorCode)accountBalanceR.getErrorCode()).setMsg(accountBalanceR.getMsg());
        }
        Map balance = (Map)accountBalanceR.getData();
        BigInteger senderBalance = new BigInteger(balance.get("available").toString());
        TransferTxFeeDto feeDto = new TransferTxFeeDto();
        feeDto.setAddressCount(1);
        feeDto.setFromLength(2);
        feeDto.setToLength(1);
        feeDto.setRemark(remark);
        BigInteger feeNeed = NulsSDKTool.calcTransferTxFee(feeDto);
        BigInteger amountTotal = amount.add(feeNeed);
        if (senderBalance.compareTo(amountTotal) < 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.INSUFFICIENT_BALANCE);
        }
        String nonce = balance.get("nonce").toString();
        TransferDto transferDto = new TransferDto();
        ArrayList<CoinFromDto> inputs = new ArrayList<CoinFromDto>();
        CoinFromDto from = new CoinFromDto();
        from.setAddress(fromAddress);
        from.setAmount(amountTotal);
        from.setAssetChainId(SDKContext.main_chain_id);
        from.setAssetId(SDKContext.main_asset_id);
        from.setNonce(nonce);
        inputs.add(from);
        ArrayList<CoinToDto> outputs = new ArrayList<CoinToDto>();
        CoinToDto to = new CoinToDto();
        to.setAddress(toAddress);
        to.setAmount(amount);
        to.setAssetChainId(SDKContext.main_chain_id);
        to.setAssetId(SDKContext.main_asset_id);
        outputs.add(to);
        transferDto.setInputs(inputs);
        transferDto.setOutputs(outputs);
        transferDto.setTime(time);
        transferDto.setRemark(remark);
        return this.createTransferTx(transferDto);
    }

    public Result createTransferTx(TransferDto transferDto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.checkTransferDto(transferDto);
            for (CoinFromDto fromDto : transferDto.getInputs()) {
                if (fromDto.getAssetChainId() == 0) {
                    fromDto.setAssetChainId(SDKContext.main_chain_id);
                }
                if (fromDto.getAssetId() != 0) continue;
                fromDto.setAssetId(SDKContext.main_asset_id);
            }
            for (CoinToDto toDto : transferDto.getOutputs()) {
                if (toDto.getAssetChainId() == 0) {
                    toDto.setAssetChainId(SDKContext.main_chain_id);
                }
                if (toDto.getAssetId() != 0) continue;
                toDto.setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(2);
            if (transferDto.getTime() != 0L) {
                tx.setTime(transferDto.getTime());
            } else {
                tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            }
            tx.setRemark(StringUtils.bytes((String)transferDto.getRemark()));
            CoinData coinData = this.assemblyCoinData(transferDto.getInputs(), transferDto.getOutputs(), tx.getSize());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(List<CoinFromDto> inputs, List<CoinToDto> outputs, int txSize) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        for (CoinFromDto coinFromDto : inputs) {
            byte[] address = AddressTool.getAddress((String)coinFromDto.getAddress());
            byte[] nonce = HexUtil.decode((String)coinFromDto.getNonce());
            CoinFrom coinFrom = new CoinFrom(address, coinFromDto.getAssetChainId(), coinFromDto.getAssetId(), coinFromDto.getAmount(), nonce, 0);
            coinFroms.add(coinFrom);
        }
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        for (CoinToDto to : outputs) {
            byte[] addressByte = AddressTool.getAddress((String)to.getAddress());
            CoinTo coinTo = new CoinTo(addressByte, to.getAssetChainId(), to.getAssetId(), to.getAmount(), to.getLockTime());
            coinTos.add(coinTo);
        }
        TxUtils.calcTxFee(coinFroms, coinTos, txSize += this.getSignatureSize(coinFroms));
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createCrossTxSimpleTransferOfNonNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount) {
        return this.createCrossTxSimpleTransferOfNonNuls(fromAddress, toAddress, assetChainId, assetId, amount, 0L, null);
    }

    public Result createCrossTxSimpleTransferOfNonNuls(String fromAddress, String toAddress, int assetChainId, int assetId, BigInteger amount, long time, String remark) {
        Result accountBalanceR = NulsSDKTool.getAccountBalance(fromAddress, assetChainId, assetId);
        if (!accountBalanceR.isSuccess()) {
            return Result.getFailed((ErrorCode)accountBalanceR.getErrorCode()).setMsg(accountBalanceR.getMsg());
        }
        Map balance = (Map)accountBalanceR.getData();
        BigInteger senderBalance = new BigInteger(balance.get("available").toString());
        if (senderBalance.compareTo(amount) < 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.INSUFFICIENT_BALANCE);
        }
        String nonce = balance.get("nonce").toString();
        TransferDto transferDto = new TransferDto();
        ArrayList<CoinFromDto> inputs = new ArrayList<CoinFromDto>();
        CoinFromDto from = new CoinFromDto();
        from.setAddress(fromAddress);
        from.setAmount(amount);
        from.setAssetChainId(assetChainId);
        from.setAssetId(assetId);
        from.setNonce(nonce);
        inputs.add(from);
        Result accountBalanceFeeR = NulsSDKTool.getAccountBalance(fromAddress, SDKContext.main_chain_id, SDKContext.main_asset_id);
        if (!accountBalanceFeeR.isSuccess()) {
            return Result.getFailed((ErrorCode)accountBalanceFeeR.getErrorCode()).setMsg(accountBalanceFeeR.getMsg());
        }
        Map balanceFee = (Map)accountBalanceFeeR.getData();
        BigInteger senderBalanceFee = new BigInteger(balanceFee.get("available").toString());
        CrossTransferTxFeeDto crossFeeDto = new CrossTransferTxFeeDto();
        crossFeeDto.setAddressCount(1);
        crossFeeDto.setFromLength(2);
        crossFeeDto.setToLength(1);
        crossFeeDto.setRemark(remark);
        BigInteger feeNeed = this.calcCrossTransferNulsTxFee(crossFeeDto);
        if (senderBalanceFee.compareTo(feeNeed) < 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.INSUFFICIENT_FEE);
        }
        String nonceFee = balanceFee.get("nonce").toString();
        CoinFromDto fromFee = new CoinFromDto();
        fromFee.setAddress(fromAddress);
        fromFee.setAmount(feeNeed);
        fromFee.setAssetChainId(SDKContext.main_chain_id);
        fromFee.setAssetId(SDKContext.main_asset_id);
        fromFee.setNonce(nonceFee);
        inputs.add(fromFee);
        ArrayList<CoinToDto> outputs = new ArrayList<CoinToDto>();
        CoinToDto to = new CoinToDto();
        to.setAddress(toAddress);
        to.setAmount(amount);
        to.setAssetChainId(assetChainId);
        to.setAssetId(assetId);
        outputs.add(to);
        transferDto.setInputs(inputs);
        transferDto.setOutputs(outputs);
        transferDto.setTime(time);
        transferDto.setRemark(remark);
        return this.createCrossTransferTx(transferDto);
    }

    public Result createCrossTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount) {
        return this.createCrossTxSimpleTransferOfNuls(fromAddress, toAddress, amount, 0L, null);
    }

    public Result createCrossTxSimpleTransferOfNuls(String fromAddress, String toAddress, BigInteger amount, long time, String remark) {
        Result accountBalanceR = NulsSDKTool.getAccountBalance(fromAddress, SDKContext.main_chain_id, SDKContext.main_asset_id);
        if (!accountBalanceR.isSuccess()) {
            return Result.getFailed((ErrorCode)accountBalanceR.getErrorCode()).setMsg(accountBalanceR.getMsg());
        }
        Map balance = (Map)accountBalanceR.getData();
        BigInteger senderBalance = new BigInteger(balance.get("available").toString());
        CrossTransferTxFeeDto crossFeeDto = new CrossTransferTxFeeDto();
        crossFeeDto.setAddressCount(1);
        crossFeeDto.setFromLength(2);
        crossFeeDto.setToLength(1);
        crossFeeDto.setRemark(remark);
        BigInteger feeNeed = NulsSDKTool.calcCrossTransferNulsTxFee(crossFeeDto);
        BigInteger amountTotal = amount.add(feeNeed);
        if (senderBalance.compareTo(amountTotal) < 0) {
            return Result.getFailed((ErrorCode)AccountErrorCode.INSUFFICIENT_BALANCE);
        }
        String nonce = balance.get("nonce").toString();
        TransferDto transferDto = new TransferDto();
        ArrayList<CoinFromDto> inputs = new ArrayList<CoinFromDto>();
        CoinFromDto from = new CoinFromDto();
        from.setAddress(fromAddress);
        from.setAmount(amountTotal);
        from.setAssetChainId(SDKContext.main_chain_id);
        from.setAssetId(SDKContext.main_asset_id);
        from.setNonce(nonce);
        inputs.add(from);
        ArrayList<CoinToDto> outputs = new ArrayList<CoinToDto>();
        CoinToDto to = new CoinToDto();
        to.setAddress(toAddress);
        to.setAmount(amount);
        to.setAssetChainId(SDKContext.main_chain_id);
        to.setAssetId(SDKContext.main_asset_id);
        outputs.add(to);
        transferDto.setInputs(inputs);
        transferDto.setOutputs(outputs);
        transferDto.setTime(time);
        transferDto.setRemark(remark);
        return this.createCrossTransferTx(transferDto);
    }

    public Result createCrossTransferTx(TransferDto transferDto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.checkCrossTransferDto(transferDto);
            Transaction tx = new Transaction(10);
            if (transferDto.getTime() != 0L) {
                tx.setTime(transferDto.getTime());
            } else {
                tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            }
            tx.setRemark(StringUtils.bytes((String)transferDto.getRemark()));
            CoinData coinData = this.createCrossTxCoinData(transferDto.getInputs(), transferDto.getOutputs());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public CoinData createCrossTxCoinData(List<CoinFromDto> inputs, List<CoinToDto> outputs) {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        for (CoinFromDto coinFromDto : inputs) {
            byte[] address = AddressTool.getAddress((String)coinFromDto.getAddress());
            byte[] nonce = HexUtil.decode((String)coinFromDto.getNonce());
            CoinFrom coinFrom = new CoinFrom(address, coinFromDto.getAssetChainId(), coinFromDto.getAssetId(), coinFromDto.getAmount(), nonce, 0);
            coinFroms.add(coinFrom);
        }
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        for (CoinToDto to : outputs) {
            byte[] addressByte = AddressTool.getAddress((String)to.getAddress());
            CoinTo coinTo = new CoinTo(addressByte, to.getAssetChainId(), to.getAssetId(), to.getAmount(), to.getLockTime());
            coinTos.add(coinTo);
        }
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createMultiSignTransferTx(MultiSignTransferDto transferDto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.checkMultiSignTransferDto(transferDto);
            for (CoinFromDto fromDto : transferDto.getInputs()) {
                if (fromDto.getAssetChainId() == 0) {
                    fromDto.setAssetChainId(SDKContext.main_chain_id);
                }
                if (fromDto.getAssetId() != 0) continue;
                fromDto.setAssetId(SDKContext.main_asset_id);
            }
            for (CoinToDto toDto : transferDto.getOutputs()) {
                if (toDto.getAssetChainId() == 0) {
                    toDto.setAssetChainId(SDKContext.main_chain_id);
                }
                if (toDto.getAssetId() != 0) continue;
                toDto.setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(2);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            tx.setRemark(StringUtils.bytes((String)transferDto.getRemark()));
            CoinData coinData = this.assemblyCoinData(transferDto, tx.getSize());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)transferDto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : transferDto.getPubKeys()) {
                list.add(HexUtil.decode((String)pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(MultiSignTransferDto transferDto, int txSize) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        for (CoinFromDto coinFromDto : transferDto.getInputs()) {
            byte[] address = AddressTool.getAddress((String)coinFromDto.getAddress());
            byte[] nonce = HexUtil.decode((String)coinFromDto.getNonce());
            CoinFrom coinFrom = new CoinFrom(address, coinFromDto.getAssetChainId(), coinFromDto.getAssetId(), coinFromDto.getAmount(), nonce, 0);
            coinFroms.add(coinFrom);
        }
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        for (CoinToDto to : transferDto.getOutputs()) {
            byte[] addressByte = AddressTool.getAddress((String)to.getAddress());
            CoinTo coinTo = new CoinTo(addressByte, to.getAssetChainId(), to.getAssetId(), to.getAmount(), to.getLockTime());
            coinTos.add(coinTo);
        }
        TxUtils.calcTxFee(coinFroms, coinTos, txSize += this.getMultiSignSignatureSize(transferDto.getPubKeys().size()));
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public BigInteger calcMultiSignTransferTxFee(MultiSignTransferTxFeeDto dto) {
        if (dto.getPrice() == null) {
            dto.setPrice(SDKContext.NULS_DEFAULT_NORMAL_TX_FEE_PRICE);
        }
        return TxUtils.calcTransferTxFee(dto.getPubKeyCount(), dto.getFromLength(), dto.getToLength(), dto.getRemark(), dto.getPrice());
    }

    private int getSignatureSize(List<CoinFrom> coinFroms) {
        int size = 0;
        HashSet<String> commonAddress = new HashSet<String>();
        for (CoinFrom coinFrom : coinFroms) {
            String address = AddressTool.getStringAddressByBytes((byte[])coinFrom.getAddress());
            commonAddress.add(address);
        }
        return size += commonAddress.size() * 110;
    }

    private int getMultiSignSignatureSize(int signNumber) {
        int size = signNumber * 110;
        return size;
    }

    public Result createAliasTx(AliasDto aliasDto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.checkAliasDto(aliasDto);
            Transaction tx = new Transaction(3);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            tx.setRemark(StringUtils.bytes((String)aliasDto.getRemark()));
            Alias alias = new Alias(AddressTool.getAddress((String)aliasDto.getAddress()), aliasDto.getAlias());
            tx.setTxData(alias.serialize());
            CoinData coinData = this.assemblyCoinData(aliasDto);
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(AliasDto dto) {
        byte[] address = AddressTool.getAddress((String)dto.getAddress());
        byte[] nonce = HexUtil.decode((String)dto.getNonce());
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        CoinFrom coinFrom = new CoinFrom();
        coinFrom.setAddress(address);
        coinFrom.setNonce(nonce);
        coinFrom.setAmount(AccountConstant.ALIAS_FEE.add(SDKContext.NULS_DEFAULT_OTHER_TX_FEE_PRICE));
        coinFrom.setAssetsChainId(SDKContext.main_chain_id);
        coinFrom.setAssetsId(SDKContext.main_asset_id);
        coinFroms.add(coinFrom);
        String prefix = AccountTool.getPrefix(dto.getAddress());
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        CoinTo coinTo = new CoinTo();
        coinTo.setAddress(AddressTool.getAddress((byte[])AccountConstant.DESTORY_PUBKEY, (int)SDKContext.main_chain_id, (String)prefix));
        coinTo.setAmount(AccountConstant.ALIAS_FEE);
        coinTo.setAssetsChainId(SDKContext.main_chain_id);
        coinTo.setAssetsId(SDKContext.main_asset_id);
        coinTos.add(coinTo);
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createConsensusTx(ConsensusDto consensusDto) {
        ValidateUtil.validateChainId();
        try {
            if (StringUtils.isBlank((String)consensusDto.getRewardAddress())) {
                consensusDto.setRewardAddress(consensusDto.getAgentAddress());
            }
            CommonValidator.validateConsensusDto(consensusDto);
            if (consensusDto.getInput().getAssetChainId() == 0) {
                consensusDto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (consensusDto.getInput().getAssetId() == 0) {
                consensusDto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(4);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Agent agent = new Agent();
            agent.setAgentAddress(AddressTool.getAddress((String)consensusDto.getAgentAddress()));
            agent.setPackingAddress(AddressTool.getAddress((String)consensusDto.getPackingAddress()));
            agent.setRewardAddress(AddressTool.getAddress((String)consensusDto.getRewardAddress()));
            agent.setDeposit(consensusDto.getDeposit());
            agent.setCommissionRate((byte)consensusDto.getCommissionRate());
            tx.setTxData(agent.serialize());
            CoinData coinData = this.assemblyCoinData(consensusDto.getInput(), agent.getDeposit(), tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public Result createDepositTx(DepositDto dto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.validateDepositDto(dto);
            if (dto.getInput().getAssetChainId() == 0) {
                dto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (dto.getInput().getAssetId() == 0) {
                dto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(5);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Deposit deposit = new Deposit();
            deposit.setAddress(AddressTool.getAddress((String)dto.getAddress()));
            deposit.setAgentHash(NulsHash.fromHex((String)dto.getAgentHash()));
            deposit.setDeposit(dto.getDeposit());
            tx.setTxData(deposit.serialize());
            CoinData coinData = this.assemblyCoinData(dto.getInput(), dto.getDeposit(), tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(CoinFromDto from, BigInteger amount, int txSize) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        byte[] address = AddressTool.getAddress((String)from.getAddress());
        byte[] nonce = HexUtil.decode((String)from.getNonce());
        CoinFrom coinFrom = new CoinFrom(address, from.getAssetChainId(), from.getAssetId(), from.getAmount(), nonce, 0);
        coinFroms.add(coinFrom);
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        CoinTo coinTo = new CoinTo(address, from.getAssetChainId(), from.getAssetId(), amount, -1L);
        coinTos.add(coinTo);
        TxUtils.calcTxFee(coinFroms, coinTos, txSize += this.getSignatureSize(coinFroms));
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createWithdrawDepositTx(WithDrawDto dto) {
        ValidateUtil.validateChainId();
        try {
            if (dto.getPrice() == null) {
                dto.setPrice(SDKContext.NULS_DEFAULT_OTHER_TX_FEE_PRICE);
            }
            CommonValidator.validateWithDrawDto(dto);
            if (dto.getInput().getAssetChainId() == 0) {
                dto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (dto.getInput().getAssetId() == 0) {
                dto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(6);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            CancelDeposit cancelDeposit = new CancelDeposit();
            cancelDeposit.setAddress(AddressTool.getAddress((String)dto.getAddress()));
            cancelDeposit.setJoinTxHash(NulsHash.fromHex((String)dto.getDepositHash()));
            tx.setTxData(cancelDeposit.serialize());
            CoinData coinData = this.assemblyCoinData(dto, tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(WithDrawDto dto, int txSize) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        CoinFromDto from = dto.getInput();
        byte[] address = AddressTool.getAddress((String)from.getAddress());
        CoinFrom coinFrom = new CoinFrom(address, from.getAssetChainId(), from.getAssetId(), from.getAmount(), -1);
        NulsHash nulsHash = NulsHash.fromHex((String)dto.getDepositHash());
        coinFrom.setNonce(TxUtils.getNonce(nulsHash.getBytes()));
        coinFroms.add(coinFrom);
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        CoinTo coinTo = new CoinTo(address, from.getAssetChainId(), from.getAssetId(), from.getAmount().subtract(dto.getPrice()), 0L);
        coinTos.add(coinTo);
        TxUtils.calcTxFee(coinFroms, coinTos, txSize += this.getSignatureSize(coinFroms));
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createStopConsensusTx(StopConsensusDto dto) {
        ValidateUtil.validateChainId();
        try {
            if (dto.getPrice() == null) {
                dto.setPrice(SDKContext.NULS_DEFAULT_OTHER_TX_FEE_PRICE);
            }
            CommonValidator.validateStopConsensusDto(dto);
            for (StopDepositDto depositDto : dto.getDepositList()) {
                if (depositDto.getInput().getAssetChainId() == 0) {
                    depositDto.getInput().setAssetChainId(SDKContext.main_chain_id);
                }
                if (depositDto.getInput().getAssetId() != 0) continue;
                depositDto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(9);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            StopAgent stopAgent = new StopAgent();
            NulsHash nulsHash = NulsHash.fromHex((String)dto.getAgentHash());
            stopAgent.setCreateTxHash(nulsHash);
            tx.setTxData(stopAgent.serialize());
            CoinData coinData = this.assemblyCoinData(dto, tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(StopConsensusDto dto, int txSize) throws NulsException {
        byte[] address;
        int chainId = SDKContext.main_chain_id;
        int assetId = SDKContext.main_asset_id;
        ArrayList<CoinFrom> coinFromList = new ArrayList<CoinFrom>();
        byte[] addressBytes = AddressTool.getAddress((String)dto.getAgentAddress());
        CoinFrom coinFrom = new CoinFrom(addressBytes, chainId, assetId, dto.getDeposit(), -1);
        NulsHash nulsHash = NulsHash.fromHex((String)dto.getAgentHash());
        coinFrom.setNonce(TxUtils.getNonce(nulsHash.getBytes()));
        coinFromList.add(coinFrom);
        HashMap<String, CoinFromDto> dtoMap = new HashMap<String, CoinFromDto>();
        for (StopDepositDto stopDepositDto : dto.getDepositList()) {
            CoinFromDto input = stopDepositDto.getInput();
            address = AddressTool.getAddress((String)input.getAddress());
            CoinFrom coinFrom1 = new CoinFrom(address, input.getAssetChainId(), input.getAssetId(), input.getAmount(), -1);
            NulsHash nulsHash1 = NulsHash.fromHex((String)stopDepositDto.getDepositHash());
            coinFrom1.setNonce(TxUtils.getNonce(nulsHash1.getBytes()));
            coinFromList.add(coinFrom1);
            String key = input.getAddress() + input.getAssetChainId() + input.getAssetId();
            CoinFromDto fromDto = (CoinFromDto)dtoMap.get(key);
            if (fromDto == null) {
                dtoMap.put(key, input);
                continue;
            }
            fromDto.setAmount(fromDto.getAmount().add(input.getAmount()));
        }
        ArrayList<CoinTo> coinToList = new ArrayList<CoinTo>();
        for (CoinFromDto input : dtoMap.values()) {
            address = AddressTool.getAddress((String)input.getAddress());
            CoinTo coinTo = new CoinTo(address, input.getAssetChainId(), input.getAssetId(), input.getAmount(), 0L);
            coinToList.add(coinTo);
        }
        BigInteger bigInteger = TxUtils.calcStopConsensusTxFee(coinFromList.size(), coinToList.size() + 1, dto.getPrice());
        CoinTo coinTo = new CoinTo(addressBytes, coinFrom.getAssetsChainId(), coinFrom.getAssetsId(), coinFrom.getAmount().subtract(bigInteger), NulsDateUtils.getCurrentTimeSeconds() + (long)SDKContext.STOP_AGENT_LOCK_TIME);
        coinToList.add(0, coinTo);
        TxUtils.calcTxFee(coinFromList, coinToList, txSize += 110);
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFromList);
        coinData.setTo(coinToList);
        return coinData;
    }

    public Result signTx(String txHex, String address, String encryptedPrivateKey, String password) {
        ArrayList<SignDto> signDtoList = new ArrayList<SignDto>();
        SignDto signDto = new SignDto();
        signDto.setAddress(address);
        signDto.setEncryptedPrivateKey(encryptedPrivateKey);
        signDto.setPassword(password);
        signDtoList.add(signDto);
        return NulsSDKTool.sign(signDtoList, txHex);
    }

    public Result signTx(String txHex, String address, String privateKey) {
        ArrayList<SignDto> signDtoList = new ArrayList<SignDto>();
        SignDto signDto = new SignDto();
        signDto.setAddress(address);
        signDto.setPriKey(privateKey);
        signDtoList.add(signDto);
        return NulsSDKTool.sign(signDtoList, txHex);
    }

    public Result broadcastTx(String txHex) {
        RpcResult balanceResult = JsonRpcUtil.request("broadcastTx", ListUtil.of(SDKContext.main_chain_id, txHex));
        RpcResultError rpcResultError = balanceResult.getError();
        if (rpcResultError != null) {
            return Result.getFailed((ErrorCode)ErrorCode.init((String)rpcResultError.getCode())).setMsg(rpcResultError.getMessage());
        }
        Map result = (Map)balanceResult.getResult();
        return Result.getSuccess((Object)result);
    }

    public Result validateTx(String txHex) {
        ValidateUtil.validateChainId();
        try {
            Result result;
            if (StringUtils.isBlank((String)txHex)) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR, "form is empty");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("txHex", txHex);
            RestFulResult restFulResult = RestFulUtil.post("api/accountledger/transaction/validate", map);
            if (restFulResult.isSuccess()) {
                result = Result.getSuccess(restFulResult.getData());
            } else {
                ErrorCode errorCode = ErrorCode.init((String)restFulResult.getError().getCode());
                result = Result.getFailed((ErrorCode)errorCode).setMsg(restFulResult.getError().getMessage());
            }
            return result;
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
    }

    public Result createMultiSignConsensusTx(MultiSignConsensusDto consensusDto) {
        ValidateUtil.validateChainId();
        try {
            if (StringUtils.isBlank((String)consensusDto.getRewardAddress())) {
                consensusDto.setRewardAddress(consensusDto.getAgentAddress());
            }
            CommonValidator.validateMultiSignConsensusDto(consensusDto);
            if (consensusDto.getInput().getAssetChainId() == 0) {
                consensusDto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (consensusDto.getInput().getAssetId() == 0) {
                consensusDto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(4);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Agent agent = new Agent();
            agent.setAgentAddress(AddressTool.getAddress((String)consensusDto.getAgentAddress()));
            agent.setPackingAddress(AddressTool.getAddress((String)consensusDto.getPackingAddress()));
            agent.setRewardAddress(AddressTool.getAddress((String)consensusDto.getRewardAddress()));
            agent.setDeposit(consensusDto.getDeposit());
            agent.setCommissionRate((byte)consensusDto.getCommissionRate());
            tx.setTxData(agent.serialize());
            CoinData coinData = this.assemblyCoinData(consensusDto.getInput(), agent.getDeposit(), consensusDto.getPubKeys().size(), tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)consensusDto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : consensusDto.getPubKeys()) {
                list.add(HexUtil.decode((String)pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    private CoinData assemblyCoinData(CoinFromDto from, BigInteger amount, int pubKeyCount, int txSize) throws NulsException {
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        byte[] address = AddressTool.getAddress((String)from.getAddress());
        byte[] nonce = HexUtil.decode((String)from.getNonce());
        CoinFrom coinFrom = new CoinFrom(address, from.getAssetChainId(), from.getAssetId(), from.getAmount(), nonce, 0);
        coinFroms.add(coinFrom);
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        CoinTo coinTo = new CoinTo(address, from.getAssetChainId(), from.getAssetId(), amount, -1L);
        coinTos.add(coinTo);
        TxUtils.calcTxFee(coinFroms, coinTos, txSize += this.getMultiSignSignatureSize(pubKeyCount));
        CoinData coinData = new CoinData();
        coinData.setFrom(coinFroms);
        coinData.setTo(coinTos);
        return coinData;
    }

    public Result createMultiSignDepositTx(MultiSignDepositDto dto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.validateMultiSignDepositDto(dto);
            if (dto.getInput().getAssetChainId() == 0) {
                dto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (dto.getInput().getAssetId() == 0) {
                dto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(5);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            Deposit deposit = new Deposit();
            deposit.setAddress(AddressTool.getAddress((String)dto.getAddress()));
            deposit.setAgentHash(NulsHash.fromHex((String)dto.getAgentHash()));
            deposit.setDeposit(dto.getDeposit());
            tx.setTxData(deposit.serialize());
            CoinData coinData = this.assemblyCoinData(dto.getInput(), dto.getDeposit(), dto.getPubKeys().size(), tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)dto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : dto.getPubKeys()) {
                list.add(HexUtil.decode((String)pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public Result createMultiSignWithdrawDepositTx(MultiSignWithDrawDto dto) {
        ValidateUtil.validateChainId();
        try {
            if (dto.getPrice() == null) {
                dto.setPrice(SDKContext.NULS_DEFAULT_OTHER_TX_FEE_PRICE);
            }
            CommonValidator.validateMultiSignWithDrawDto(dto);
            if (dto.getInput().getAssetChainId() == 0) {
                dto.getInput().setAssetChainId(SDKContext.main_chain_id);
            }
            if (dto.getInput().getAssetId() == 0) {
                dto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(6);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            CancelDeposit cancelDeposit = new CancelDeposit();
            cancelDeposit.setAddress(AddressTool.getAddress((String)dto.getAddress()));
            cancelDeposit.setJoinTxHash(NulsHash.fromHex((String)dto.getDepositHash()));
            tx.setTxData(cancelDeposit.serialize());
            CoinData coinData = this.assemblyCoinData(dto, tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)dto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : dto.getPubKeys()) {
                list.add(HexUtil.decode((String)pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public Result createMultiSignStopConsensusTx(MultiSignStopConsensusDto dto) {
        ValidateUtil.validateChainId();
        try {
            if (dto.getPrice() == null) {
                dto.setPrice(SDKContext.NULS_DEFAULT_OTHER_TX_FEE_PRICE);
            }
            CommonValidator.validateMultiSignStopConsensusDto(dto);
            for (StopDepositDto depositDto : dto.getDepositList()) {
                if (depositDto.getInput().getAssetChainId() == 0) {
                    depositDto.getInput().setAssetChainId(SDKContext.main_chain_id);
                }
                if (depositDto.getInput().getAssetId() != 0) continue;
                depositDto.getInput().setAssetId(SDKContext.main_asset_id);
            }
            Transaction tx = new Transaction(9);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            StopAgent stopAgent = new StopAgent();
            NulsHash nulsHash = NulsHash.fromHex((String)dto.getAgentHash());
            stopAgent.setCreateTxHash(nulsHash);
            tx.setTxData(stopAgent.serialize());
            CoinData coinData = this.assemblyCoinData(dto, tx.size());
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)dto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : dto.getPubKeys()) {
                list.add(HexUtil.decode((String)pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }

    public Result createMultiSignAliasTx(MultiSignAliasDto aliasDto) {
        ValidateUtil.validateChainId();
        try {
            CommonValidator.validateMultiSignAliasDto(aliasDto);
            Transaction tx = new Transaction(3);
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            tx.setRemark(StringUtils.bytes((String)aliasDto.getRemark()));
            Alias alias = new Alias(AddressTool.getAddress((String)aliasDto.getAddress()), aliasDto.getAlias());
            tx.setTxData(alias.serialize());
            CoinData coinData = this.assemblyCoinData(aliasDto);
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
            MultiSignTxSignature signature = new MultiSignTxSignature();
            signature.setM((byte)aliasDto.getMinSigns());
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String pubKey : aliasDto.getPubKeys()) {
                list.add(HexUtil.decode((String)pubKey));
            }
            signature.setPubKeyList(list);
            tx.setTransactionSignature(signature.serialize());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hash", tx.getHash().toHex());
            map.put("txHex", HexUtil.encode((byte[])tx.serialize()));
            return Result.getSuccess(map);
        }
        catch (NulsException e) {
            return Result.getFailed((ErrorCode)e.getErrorCode()).setMsg(e.format());
        }
        catch (IOException e) {
            return Result.getFailed((ErrorCode)AccountErrorCode.DATA_PARSE_ERROR).setMsg(AccountErrorCode.DATA_PARSE_ERROR.getMsg());
        }
    }
}

