/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.tx;

import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.Transaction;
import io.nuls.core.exception.NulsException;
import java.io.IOException;

public abstract class ContractBaseTransaction<T extends BaseNulsData>
extends Transaction {
    private CoinData coinDataObj;
    private T txDataObj;

    protected ContractBaseTransaction() {
    }

    protected ContractBaseTransaction(int txType) {
        super(txType);
    }

    public CoinData getCoinDataObj() throws NulsException {
        if (this.coinDataObj == null) {
            CoinData coinData = new CoinData();
            coinData.parse(this.getCoinData(), 0);
            this.coinDataObj = coinData;
        }
        return this.coinDataObj;
    }

    public T getTxDataObj() throws NulsException {
        if (this.txDataObj == null) {
            this.txDataObj = this.newInstance();
            if (this.txDataObj != null) {
                this.txDataObj.parse(this.getTxData(), 0);
            }
        }
        return this.txDataObj;
    }

    protected abstract T newInstance();

    public void serializeData() throws IOException {
        if (this.getCoinData() == null && this.coinDataObj != null) {
            this.setCoinData(this.coinDataObj.serialize());
        }
        if (this.getTxData() == null && this.txDataObj != null) {
            this.setTxData(this.txDataObj.serialize());
        }
    }

    public void copyTx(Transaction tx) {
        this.setType(tx.getType());
        this.setCoinData(tx.getCoinData());
        this.setTxData(tx.getTxData());
        this.setTime(tx.getTime());
        this.setTransactionSignature(tx.getTransactionSignature());
        this.setRemark(tx.getRemark());
    }

    public void setCoinDataObj(CoinData coinDataObj) {
        this.coinDataObj = coinDataObj;
    }

    public void setTxDataObj(T txDataObj) {
        this.txDataObj = txDataObj;
    }
}

