/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.v2.txdata.ContractData;
import java.io.IOException;
import java.math.BigInteger;

public class CreateContractData
extends BaseNulsData
implements ContractData {
    private byte[] sender;
    private byte[] contractAddress;
    private byte[] code;
    private String alias;
    private long gasLimit;
    private long price;
    private short argsCount;
    private String[][] args;

    public int size() {
        int size = 0;
        size += 23;
        size += 23;
        size += SerializeUtils.sizeOfBytes((byte[])this.code);
        size += SerializeUtils.sizeOfString((String)this.alias);
        size += SerializeUtils.sizeOfInt64();
        size += SerializeUtils.sizeOfInt64();
        ++size;
        if (this.args != null) {
            for (String[] arg : this.args) {
                if (arg == null) {
                    ++size;
                    continue;
                }
                ++size;
                for (String str : arg) {
                    size += SerializeUtils.sizeOfString((String)str);
                }
            }
        }
        return size;
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.sender);
        stream.write(this.contractAddress);
        stream.writeBytesWithLength(this.code);
        stream.writeString(this.alias);
        stream.writeInt64(this.gasLimit);
        stream.writeInt64(this.price);
        stream.writeUint8(this.argsCount);
        if (this.args != null) {
            for (String[] arg : this.args) {
                if (arg == null) {
                    stream.writeUint8((short)0);
                    continue;
                }
                stream.writeUint8((short)arg.length);
                for (String str : arg) {
                    stream.writeString(str);
                }
            }
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.sender = byteBuffer.readBytes(23);
        this.contractAddress = byteBuffer.readBytes(23);
        this.code = byteBuffer.readByLengthByte();
        this.alias = byteBuffer.readString();
        this.gasLimit = byteBuffer.readInt64();
        this.price = byteBuffer.readInt64();
        short length = this.argsCount = byteBuffer.readUint8();
        this.args = new String[length][];
        for (short i = 0; i < length; i = (short)(i + 1)) {
            short argCount = byteBuffer.readUint8();
            if (argCount == 0) {
                this.args[i] = new String[0];
                continue;
            }
            String[] arg = new String[argCount];
            for (short k = 0; k < argCount; k = (short)(k + 1)) {
                arg[k] = byteBuffer.readString();
            }
            this.args[i] = arg;
        }
    }

    @Override
    public BigInteger getValue() {
        return BigInteger.ZERO;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public String getMethodDesc() {
        return null;
    }

    @Override
    public byte[] getSender() {
        return this.sender;
    }

    public void setSender(byte[] sender) {
        this.sender = sender;
    }

    @Override
    public byte[] getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(byte[] contractAddress) {
        this.contractAddress = contractAddress;
    }

    @Override
    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] code) {
        this.code = code;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public long getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(long gasLimit) {
        this.gasLimit = gasLimit;
    }

    @Override
    public long getPrice() {
        return this.price;
    }

    public void setPrice(long price) {
        this.price = price;
    }

    public short getArgsCount() {
        return this.argsCount;
    }

    public void setArgsCount(short argsCount) {
        this.argsCount = argsCount;
    }

    @Override
    public String[][] getArgs() {
        return this.args;
    }

    public void setArgs(String[][] args) {
        this.args = args;
    }
}

