/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.util;

import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.v2.SDKContext;
import io.nuls.v2.model.dto.RpcResult;
import io.nuls.v2.model.dto.RpcResultError;
import io.nuls.v2.util.HttpClientUtil;
import java.util.HashMap;
import java.util.List;

public class JsonRpcUtil {
    private static final String ID = "id";
    private static final String JSONRPC = "jsonrpc";
    private static final String METHOD = "method";
    private static final String PARAMS = "params";
    private static final String DEFAULT_ID = "1";
    private static final String JSONRPC_VERSION = "2.0";

    public static RpcResult request(String method, List<Object> params) {
        RpcResult rpcResult;
        Object httpClient = null;
        Object response = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put(ID, DEFAULT_ID);
            map.put(JSONRPC, JSONRPC_VERSION);
            map.put(METHOD, method);
            map.put(PARAMS, params);
            String resultStr = HttpClientUtil.post(SDKContext.wallet_url + JSONRPC, map);
            rpcResult = (RpcResult)JSONUtils.json2pojo((String)resultStr, RpcResult.class);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            rpcResult = RpcResult.failed(new RpcResultError(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage(), null));
        }
        return rpcResult;
    }

    public static RpcResult request(String requestURL, String method, List<Object> params) {
        RpcResult rpcResult;
        Object httpClient = null;
        Object response = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put(ID, DEFAULT_ID);
            map.put(JSONRPC, JSONRPC_VERSION);
            map.put(METHOD, method);
            map.put(PARAMS, params);
            String resultStr = HttpClientUtil.post(requestURL, map);
            rpcResult = (RpcResult)JSONUtils.json2pojo((String)resultStr, RpcResult.class);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            rpcResult = RpcResult.failed(new RpcResultError(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage(), null));
        }
        return rpcResult;
    }
}

