/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.v2.util;

import io.nuls.core.crypto.HexUtil;
import io.nuls.core.model.StringUtils;
import io.nuls.v2.SDKContext;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidateUtil {
    public static void validateChainId() {
        if (SDKContext.main_chain_id < 1 || SDKContext.main_chain_id > 65535) {
            throw new RuntimeException("config main_chain_id is invalid");
        }
    }

    public static boolean validateChainId(int chainId) {
        return chainId >= 1 && chainId <= 65535;
    }

    public static boolean validateCoinAmount(BigInteger amount) {
        if (amount == null) {
            return false;
        }
        return amount.compareTo(BigInteger.ZERO) >= 0;
    }

    public static boolean validateLockTime(long lockTime) {
        return lockTime >= -1L;
    }

    public static boolean validTxRemark(String remark) {
        return true;
    }

    public static boolean validateNonce(String nonce) {
        if (StringUtils.isBlank((String)nonce)) {
            return false;
        }
        return ValidateUtil.regexMatch(nonce, "^[A-Za-z0-9]{10,20}$");
    }

    public static boolean validateCommissionRate(int commissionRate) {
        return commissionRate >= 0 && commissionRate <= 100;
    }

    public static boolean validHash(String hex) {
        try {
            HexUtil.decode((String)hex);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validateBigInteger(String value) {
        try {
            new BigInteger(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean regexMatch(String str, String regex) {
        if (str == null) {
            return false;
        }
        boolean flag = false;
        try {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(str);
            flag = matcher.matches();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }
}

