/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.model.bo;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.base.data.Address;
import io.nuls.core.crypto.AESEncrypt;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.EncryptedData;
import io.nuls.core.crypto.Sha256Hash;
import io.nuls.core.exception.CryptoException;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.ObjectUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.crypto.params.KeyParameter;

public class Account
implements Serializable {
    private int chainId;
    private transient Address address;
    private String alias;
    private int status;
    private byte[] pubKey;
    private byte[] extend;
    private Long createTime;
    private byte[] encryptedPriKey;
    private byte[] priKey;
    private transient ECKey ecKey;
    private String remark;

    public boolean isEncrypted() {
        return this.getEncryptedPriKey() != null && this.getEncryptedPriKey().length > 0;
    }

    public void lock() {
        if (!this.isEncrypted()) {
            return;
        }
        if (this.getEcKey().getEncryptedPrivateKey() != null) {
            ECKey result = ECKey.fromEncrypted((EncryptedData)this.getEcKey().getEncryptedPrivateKey(), (byte[])this.getPubKey());
            this.setPriKey(new byte[0]);
            this.setEcKey(result);
        }
    }

    public byte[] getHash160() {
        return this.getAddress().getHash160();
    }

    public boolean unlock(String password) throws NulsException {
        this.decrypt(password);
        return !this.isLocked();
    }

    public boolean isLocked() {
        return this.getPriKey() == null || this.getPriKey().length == 0;
    }

    public boolean validatePassword(String password) {
        byte[] unencryptedPrivateKey;
        boolean result = FormatValidUtils.validPassword((String)password);
        if (!result) {
            return false;
        }
        try {
            unencryptedPrivateKey = AESEncrypt.decrypt((byte[])this.getEncryptedPriKey(), (String)password);
        }
        catch (CryptoException e) {
            return false;
        }
        BigInteger newPriv = new BigInteger(1, unencryptedPrivateKey);
        ECKey key = ECKey.fromPrivate((BigInteger)newPriv);
        return Arrays.equals(key.getPubKey(), this.getPubKey());
    }

    public void encrypt(String password) throws NulsException {
        this.encrypt(password, false);
    }

    public void encrypt(String password, boolean isForce) throws NulsException {
        if (this.isEncrypted()) {
            if (isForce) {
                if (this.isLocked()) {
                    throw new NulsException(AccountErrorCode.ACCOUNT_IS_ALREADY_ENCRYPTED_AND_LOCKED);
                }
            } else {
                throw new NulsException(AccountErrorCode.ACCOUNT_IS_ALREADY_ENCRYPTED);
            }
        }
        ECKey eckey = this.getEcKey();
        byte[] privKeyBytes = eckey.getPrivKeyBytes();
        EncryptedData encryptedPrivateKey = AESEncrypt.encrypt((byte[])privKeyBytes, (byte[])EncryptedData.DEFAULT_IV, (KeyParameter)new KeyParameter(Sha256Hash.hash((byte[])password.getBytes())));
        eckey.setEncryptedPrivateKey(encryptedPrivateKey);
        ECKey result = ECKey.fromEncrypted((EncryptedData)encryptedPrivateKey, (byte[])this.getPubKey());
        this.setPriKey(new byte[0]);
        this.setEcKey(result);
        this.setEncryptedPriKey(encryptedPrivateKey.getEncryptedBytes());
    }

    private boolean decrypt(String password) throws NulsException {
        try {
            byte[] unencryptedPrivateKey = AESEncrypt.decrypt((byte[])this.getEncryptedPriKey(), (String)password);
            BigInteger newPriv = new BigInteger(1, unencryptedPrivateKey);
            ECKey key = ECKey.fromPrivate((BigInteger)newPriv);
            if (!Arrays.equals(key.getPubKey(), this.getPubKey())) {
                return false;
            }
            key.setEncryptedPrivateKey(new EncryptedData(this.getEncryptedPriKey()));
            this.setPriKey(key.getPrivKeyBytes());
            this.setEcKey(key);
        }
        catch (Exception e) {
            throw new NulsException(AccountErrorCode.PASSWORD_IS_WRONG);
        }
        return true;
    }

    public Object copy() {
        Account account = new Account();
        account.setChainId(this.chainId);
        account.setAlias(this.alias);
        account.setAddress(this.address);
        account.setStatus(this.status);
        account.setPubKey(this.pubKey);
        account.setExtend(this.extend);
        account.setCreateTime(this.createTime);
        account.setEncryptedPriKey(this.encryptedPriKey);
        account.setPriKey(this.priKey);
        account.setEcKey(this.ecKey);
        account.setRemark(this.remark);
        return account;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public byte[] getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(byte[] pubKey) {
        this.pubKey = pubKey;
    }

    public byte[] getExtend() {
        return this.extend;
    }

    public void setExtend(byte[] extend) {
        this.extend = extend;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public byte[] getEncryptedPriKey() {
        return this.encryptedPriKey;
    }

    public void setEncryptedPriKey(byte[] encryptedPriKey) {
        this.encryptedPriKey = encryptedPriKey;
    }

    public byte[] getPriKey() {
        return this.priKey;
    }

    public byte[] getPriKey(String password) throws NulsException {
        byte[] unencryptedPrivateKey;
        if (!FormatValidUtils.validPassword((String)password)) {
            throw new NulsException(AccountErrorCode.PASSWORD_IS_WRONG);
        }
        try {
            unencryptedPrivateKey = AESEncrypt.decrypt((byte[])this.getEncryptedPriKey(), (String)password);
        }
        catch (CryptoException e) {
            throw new NulsException(AccountErrorCode.PASSWORD_IS_WRONG);
        }
        BigInteger newPriv = new BigInteger(1, unencryptedPrivateKey);
        ECKey key = ECKey.fromPrivate((BigInteger)newPriv);
        if (!Arrays.equals(key.getPubKey(), this.getPubKey())) {
            throw new NulsException(AccountErrorCode.PASSWORD_IS_WRONG);
        }
        return unencryptedPrivateKey;
    }

    public void setPriKey(byte[] priKey) {
        this.priKey = priKey;
    }

    public ECKey getEcKey() {
        return this.ecKey;
    }

    public void setEcKey(ECKey ecKey) {
        this.ecKey = ecKey;
    }

    public ECKey getEcKey(String password) throws NulsException {
        ECKey eckey = null;
        if (this.isEncrypted()) {
            ObjectUtils.canNotEmpty((Object)password, (String)"the password can not be empty");
            boolean result = FormatValidUtils.validPassword((String)password);
            if (result) {
                try {
                    byte[] unencryptedPrivateKey = AESEncrypt.decrypt((byte[])this.getEncryptedPriKey(), (String)password);
                    BigInteger newPriv = new BigInteger(1, unencryptedPrivateKey);
                    eckey = ECKey.fromPrivate((BigInteger)newPriv);
                    result = Arrays.equals(eckey.getPubKey(), this.getPubKey());
                }
                catch (CryptoException e) {
                    result = false;
                }
            }
            if (!result) {
                throw new NulsException(AccountErrorCode.PASSWORD_IS_WRONG);
            }
        } else {
            BigInteger newPriv = new BigInteger(1, this.getPriKey());
            eckey = ECKey.fromPrivate((BigInteger)newPriv);
        }
        return eckey;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account other = (Account)obj;
        return Arrays.equals(this.pubKey, other.getPubKey());
    }

    public int hashCode() {
        return Arrays.hashCode(this.pubKey);
    }
}

