/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.model.bo.tx;

import io.nuls.account.model.bo.tx.AccountBlockInfo;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class AccountBlockExtend
extends BaseNulsData {
    private AccountBlockInfo[] infos;
    private byte[] extend;

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        for (AccountBlockInfo info : this.infos) {
            size += SerializeUtils.sizeOfNulsData((NulsData)info);
        }
        return size += SerializeUtils.sizeOfBytes((byte[])this.extend);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.infos.length);
        for (AccountBlockInfo info : this.infos) {
            stream.writeNulsData((BaseNulsData)info);
        }
        stream.writeBytesWithLength(this.extend);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        int length = byteBuffer.readUint16();
        AccountBlockInfo[] _infos = new AccountBlockInfo[length];
        for (int i = 0; i < length; ++i) {
            _infos[i] = (AccountBlockInfo)byteBuffer.readNulsData((BaseNulsData)new AccountBlockInfo());
        }
        this.infos = _infos;
        this.extend = byteBuffer.readByLengthByte();
    }

    public AccountBlockInfo[] getInfos() {
        return this.infos;
    }

    public void setInfos(AccountBlockInfo[] infos) {
        this.infos = infos;
    }

    public byte[] getExtend() {
        return this.extend;
    }

    public void setExtend(byte[] extend) {
        this.extend = extend;
    }
}

