/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.model.bo.tx;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class AccountBlockInfo
extends BaseNulsData {
    private int operationType;
    private int[] types;
    private String[] contracts;
    private byte[] extend;

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint16();
        if (this.types != null) {
            size += SerializeUtils.sizeOfUint16() * this.types.length;
        }
        size += SerializeUtils.sizeOfUint16();
        if (this.contracts != null) {
            for (String contract : this.contracts) {
                size += SerializeUtils.sizeOfString((String)contract);
            }
        }
        return size += SerializeUtils.sizeOfBytes((byte[])this.extend);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.operationType);
        if (this.types == null) {
            stream.writeUint16(0);
        } else {
            stream.writeUint16(this.types.length);
            for (int type : this.types) {
                stream.writeUint16(type);
            }
        }
        if (this.contracts == null) {
            stream.writeUint16(0);
        } else {
            stream.writeUint16(this.contracts.length);
            for (String address : this.contracts) {
                stream.writeString(address);
            }
        }
        stream.writeBytesWithLength(this.extend);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.operationType = byteBuffer.readUint16();
        int length0 = byteBuffer.readUint16();
        int[] _types = new int[length0];
        for (int i = 0; i < length0; ++i) {
            _types[i] = byteBuffer.readUint16();
        }
        int length = byteBuffer.readUint16();
        String[] _addresses = new String[length];
        for (int i = 0; i < length; ++i) {
            _addresses[i] = byteBuffer.readString();
        }
        this.types = _types;
        this.contracts = _addresses;
        this.extend = byteBuffer.readByLengthByte();
    }

    public int getOperationType() {
        return this.operationType;
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public int[] getTypes() {
        return this.types;
    }

    public void setTypes(int[] types) {
        this.types = types;
    }

    public String[] getContracts() {
        return this.contracts;
    }

    public void setContracts(String[] contracts) {
        this.contracts = contracts;
    }

    public byte[] getExtend() {
        return this.extend;
    }

    public void setExtend(byte[] extend) {
        this.extend = extend;
    }
}

