/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.nuls.account.model.bo.AccountKeyStore;
import io.nuls.core.crypto.HexUtil;
import java.util.Map;

public class AccountKeyStoreDTO {
    private String address;
    private String encryptedPrivateKey;
    private String pubKey;
    private String prikey;
    @JsonIgnore
    private String alias;

    public AccountKeyStoreDTO() {
    }

    public AccountKeyStoreDTO(AccountKeyStore accountKeyStore) {
        this.address = accountKeyStore.getAddress();
        this.encryptedPrivateKey = null == accountKeyStore.getEncryptedPrivateKey() ? null : accountKeyStore.getEncryptedPrivateKey();
        this.pubKey = HexUtil.encode((byte[])accountKeyStore.getPubKey());
        this.prikey = null == accountKeyStore.getPrikey() ? null : HexUtil.encode((byte[])accountKeyStore.getPrikey());
    }

    public AccountKeyStore toAccountKeyStore() {
        AccountKeyStore accountKeyStore = new AccountKeyStore();
        accountKeyStore.setAddress(this.address);
        accountKeyStore.setEncryptedPrivateKey(this.encryptedPrivateKey);
        if (null == this.prikey || "null".toUpperCase().equals(this.prikey.trim().toUpperCase()) || "".equals(this.prikey.trim())) {
            accountKeyStore.setPrikey(null);
        } else {
            try {
                accountKeyStore.setPrikey(HexUtil.decode((String)this.prikey.trim()));
            }
            catch (Exception e) {
                accountKeyStore.setPrikey(null);
            }
        }
        accountKeyStore.setPubKey(HexUtil.decode((String)this.pubKey));
        return accountKeyStore;
    }

    public AccountKeyStoreDTO(Map<String, Object> map) {
        this.address = (String)map.get("address");
        this.encryptedPrivateKey = null == map.get("encryptedPrivateKey") ? null : (String)map.get("encryptedPrivateKey");
        this.pubKey = null == map.get("pubKey") ? null : (String)map.get("pubKey");
        this.prikey = null == map.get("prikey") ? null : (String)map.get("prikey");
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    public void setEncryptedPrivateKey(String encryptedPrivateKey) {
        this.encryptedPrivateKey = encryptedPrivateKey;
    }

    public String getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(String pubKey) {
        this.pubKey = pubKey;
    }

    public String getPrikey() {
        return this.prikey;
    }

    public void setPrikey(String prikey) {
        this.prikey = prikey;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

