/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.Address;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiSigAccountPO
extends BaseNulsData {
    private int chainId;
    private transient Address address;
    private List<byte[]> pubKeyList;
    private byte m;
    private String alias;

    public MultiSigAccountPO() {
    }

    public MultiSigAccountPO(MultiSigAccount multiSigAccount) {
        this.chainId = multiSigAccount.getChainId();
        this.address = multiSigAccount.getAddress();
        this.pubKeyList = multiSigAccount.getPubKeyList();
        this.m = multiSigAccount.getM();
        this.alias = multiSigAccount.getAlias();
    }

    public MultiSigAccount toAccount() {
        MultiSigAccount account = new MultiSigAccount();
        account.setChainId(this.chainId);
        account.setAddress(this.address);
        account.setPubKeyList(this.pubKeyList);
        account.setM(this.m);
        account.setAlias(this.alias);
        return account;
    }

    public int size() {
        int size = 4;
        size += 23;
        size += 4;
        for (byte[] bytes : this.pubKeyList) {
            size += SerializeUtils.sizeOfBytes((byte[])bytes);
        }
        ++size;
        return size += SerializeUtils.sizeOfString((String)this.alias);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint32((long)this.chainId);
        stream.write(this.address.getAddressBytes());
        stream.writeUint32((long)this.pubKeyList.size());
        for (int i = 0; i < this.pubKeyList.size(); ++i) {
            stream.writeBytesWithLength(this.pubKeyList.get(i));
        }
        stream.write((int)this.m);
        stream.writeString(this.alias);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readInt32();
        byte[] bytes = byteBuffer.readBytes(23);
        this.address = Address.fromHashs((byte[])bytes);
        this.pubKeyList = new ArrayList<byte[]>();
        long count = byteBuffer.readUint32();
        int i = 0;
        while ((long)i < count) {
            this.pubKeyList.add(byteBuffer.readByLengthByte());
            ++i;
        }
        this.m = byteBuffer.readByte();
        this.alias = byteBuffer.readString();
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public List<byte[]> getPubKeyList() {
        return this.pubKeyList;
    }

    public void setPubKeyList(List<byte[]> pubKeyList) {
        this.pubKeyList = pubKeyList;
    }

    public byte getM() {
        return this.m;
    }

    public void setM(byte m) {
        this.m = m;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

