/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.rpc.call;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Chain;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.HashMap;

public class LedgerCall {
    public static HashMap getBalanceNonce(Chain chain, int assetChainId, int assetId, String address) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("assetChainId", assetChainId);
            params.put("assetId", assetId);
            params.put("address", address);
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"getBalanceNonce", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Calling remote interface failed. module:{} - interface:{} - ResponseComment:{}", new Object[]{ModuleE.LG.abbr, "getBalanceNonce", cmdResp.getResponseComment()});
                throw new NulsException(AccountErrorCode.FAILED);
            }
            HashMap result = (HashMap)((HashMap)cmdResp.getResponseData()).get("getBalanceNonce");
            return result;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Calling remote interface failed. module:{0} - interface:{1}", ModuleE.LG.abbr, "getBalanceNonce");
            chain.getLogger().error(msg, e);
            return null;
        }
    }

    public static BigInteger getBalance(Chain chain, int assetChainId, int assetId, String address) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("version", "1.0");
            params.put("chainId", chain.getChainId());
            params.put("address", address);
            params.put("assetChainId", assetChainId);
            params.put("assetId", assetId);
            Response cmdResp = ResponseMessageProcessor.requestAndResponse((String)ModuleE.LG.abbr, (String)"getBalance", params);
            if (!cmdResp.isSuccess()) {
                chain.getLogger().error("Calling remote interface failed. module:{} - interface:{} - ResponseComment:{}", new Object[]{ModuleE.LG.abbr, "getBalance", cmdResp.getResponseComment()});
                throw new NulsException(AccountErrorCode.FAILED);
            }
            HashMap result = (HashMap)((HashMap)cmdResp.getResponseData()).get("getBalance");
            if (null == result) {
                chain.getLogger().error("call getBalance response data is null, error:{}", new Object[]{AccountErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return new BigInteger("0");
            }
            Object available = result.get("available");
            if (null == available) {
                chain.getLogger().error("call getBalance response available is null, error:{}", new Object[]{AccountErrorCode.REMOTE_RESPONSE_DATA_NOT_FOUND.getCode()});
                return new BigInteger("0");
            }
            return BigIntegerUtils.stringToBigInteger((String)String.valueOf(available));
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Calling remote interface failed. module:{0} - interface:{1}", ModuleE.LG.abbr, "getBalance");
            chain.getLogger().error(msg, e);
            return new BigInteger("0");
        }
    }
}

