/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.service.impl;

import io.nuls.account.config.NulsConfig;
import io.nuls.account.constant.AccountConstant;
import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.NonceBalance;
import io.nuls.account.model.bo.Account;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.bo.tx.AliasTransaction;
import io.nuls.account.model.bo.tx.txdata.Alias;
import io.nuls.account.model.dto.CoinDTO;
import io.nuls.account.model.dto.MultiSignTransactionResultDTO;
import io.nuls.account.model.dto.MultiSignTransferDTO;
import io.nuls.account.model.dto.TransferDTO;
import io.nuls.account.model.po.AliasPO;
import io.nuls.account.rpc.call.TransactionCall;
import io.nuls.account.service.AccountService;
import io.nuls.account.service.AliasService;
import io.nuls.account.service.MultiSignAccountService;
import io.nuls.account.service.TransactionService;
import io.nuls.account.storage.AliasStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.Preconditions;
import io.nuls.account.util.TxUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.account.util.validator.TxValidator;
import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.TransactionFeeCalculator;
import io.nuls.base.data.Address;
import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.MultiSignTxSignature;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
public class TransactionServiceImpl
implements TransactionService {
    @Autowired
    private AccountService accountService;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AliasService aliasService;
    @Autowired
    private TxValidator txValidator;
    @Autowired
    private MultiSignAccountService multiSignAccountService;
    @Autowired
    private AliasStorageService aliasStorageService;

    @Override
    public Result transferTxValidate(Chain chain, Transaction tx) throws NulsException {
        return this.txValidator.validate(chain, tx);
    }

    @Override
    public Transaction transfer(Chain chain, TransferDTO transferDTO) throws NulsException {
        int chainId = chain.getChainId();
        List<CoinDTO> fromList = transferDTO.getInputs();
        List<CoinDTO> toList = transferDTO.getOutputs();
        this.aliasTransferProcess(chainId, fromList, toList);
        for (CoinDTO from : fromList) {
            if (!AddressTool.isMultiSignAddress((String)from.getAddress())) continue;
            throw new NulsException(AccountErrorCode.IS_MULTI_SIGNATURE_ADDRESS);
        }
        String remark = transferDTO.getRemark();
        Transaction tx = this.createNormalTransferTx(chain, fromList, toList, remark);
        TransactionCall.newTx(chain, tx);
        return tx;
    }

    @Override
    public MultiSignTransactionResultDTO multiSignTransfer(Chain chain, MultiSignTransferDTO multiSignTransferDTO) throws NulsException {
        int chainId = chain.getChainId();
        List<CoinDTO> fromList = multiSignTransferDTO.inputsConvert();
        List<CoinDTO> toList = multiSignTransferDTO.outputsConvert();
        this.aliasTransferProcess(chainId, fromList, toList);
        String address = null;
        for (CoinDTO from : fromList) {
            String addr = from.getAddress();
            if (!AddressTool.isMultiSignAddress((String)addr)) {
                throw new NulsException(AccountErrorCode.IS_NOT_MULTI_SIGNATURE_ADDRESS);
            }
            if (address == null) {
                address = addr;
                continue;
            }
            if (address.equals(addr)) continue;
            throw new NulsException(AccountErrorCode.ONLY_ONE_MULTI_SIGN_ADDRESS);
        }
        String remark = multiSignTransferDTO.getRemark();
        MultiSigAccount multiSigAccount = this.multiSignAccountService.getMultiSigAccountByAddress(address);
        Preconditions.checkNotNull(multiSigAccount, AccountErrorCode.MULTISIGN_ACCOUNT_NOT_EXIST);
        Transaction tx = this.assemblyUnsignedTransaction(chain, fromList, toList, remark);
        MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
        transactionSignature.setM(multiSigAccount.getM());
        transactionSignature.setPubKeyList(multiSigAccount.getPubKeyList());
        try {
            tx.setTransactionSignature(transactionSignature.serialize());
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        boolean isBroadcasted = false;
        if (null != multiSignTransferDTO.getSignAddress() && null != multiSignTransferDTO.getSignPassword()) {
            Account account = this.accountService.getAccount(chainId, multiSignTransferDTO.getSignAddress());
            Preconditions.checkNotNull(account, AccountErrorCode.ACCOUNT_NOT_EXIST);
            if (!AddressTool.validSignAddress((List)multiSigAccount.getPubKeyList(), (byte[])account.getPubKey())) {
                throw new NulsRuntimeException(AccountErrorCode.SIGN_ADDRESS_NOT_MATCH);
            }
            TransactionSignature txSignature = this.buildMultiSignTransactionSignature(tx, multiSigAccount, account, multiSignTransferDTO.getSignPassword());
            isBroadcasted = this.txMutilProcessing(chain, multiSigAccount.getM(), tx, txSignature);
        }
        MultiSignTransactionResultDTO multiSignTransactionResultDto = new MultiSignTransactionResultDTO();
        multiSignTransactionResultDto.setBroadcasted(isBroadcasted);
        multiSignTransactionResultDto.setTransaction(tx);
        return multiSignTransactionResultDto;
    }

    private void aliasTransferProcess(int chainId, List<CoinDTO> fromList, List<CoinDTO> toList) {
        if (fromList == null || toList == null) {
            throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
        }
        Function<CoinDTO, CoinDTO> checkAddress = cd -> {
            if (!AddressTool.validAddress((int)chainId, (String)cd.getAddress())) {
                AliasPO aliasPo = this.aliasStorageService.getAlias(chainId, cd.getAddress());
                Preconditions.checkNotNull((Object)aliasPo, AccountErrorCode.ALIAS_NOT_EXIST);
                cd.setAddress(AddressTool.getStringAddressByBytes((byte[])aliasPo.getAddress()));
            }
            return cd;
        };
        fromList = fromList.stream().map(checkAddress).collect(Collectors.toList());
        toList = toList.stream().map(checkAddress).collect(Collectors.toList());
    }

    @Override
    public MultiSignTransactionResultDTO signMultiSignTransaction(Chain chain, Account account, String password, String txStr) throws NulsException {
        MultiSignTxSignature transactionSignature;
        Transaction transaction = new Transaction();
        transaction.parse(new NulsByteBuffer(RPCUtil.decode((String)txStr)));
        CoinData coinData = new CoinData();
        coinData.parse(new NulsByteBuffer(transaction.getCoinData()));
        List list = coinData.getFrom();
        if (list == null) {
            throw new NulsRuntimeException(AccountErrorCode.TX_NOT_EFFECTIVE);
        }
        byte[] address = ((CoinFrom)list.get(0)).getAddress();
        MultiSigAccount multiSigAccount = null;
        byte[] txSignatureByte = transaction.getTransactionSignature();
        List accountPubKeyList = null;
        byte accountM = 0;
        if (null == txSignatureByte || txSignatureByte.length == 0) {
            multiSigAccount = this.multiSignAccountService.getMultiSigAccountByAddress(AddressTool.getStringAddressByBytes((byte[])address));
            if (multiSigAccount == null) {
                throw new NulsRuntimeException(AccountErrorCode.MULTISIGN_ACCOUNT_NOT_EXIST);
            }
            accountM = multiSigAccount.getM();
            accountPubKeyList = multiSigAccount.getPubKeyList();
        } else {
            transactionSignature = new MultiSignTxSignature();
            transactionSignature.parse(new NulsByteBuffer(transaction.getTransactionSignature()));
            ArrayList<String> pubKeys = new ArrayList<String>();
            for (byte[] pubkey : transactionSignature.getPubKeyList()) {
                pubKeys.add(HexUtil.encode((byte[])pubkey));
            }
            try {
                byte[] hash160 = SerializeUtils.sha256hash160((byte[])AddressTool.createMultiSigAccountOriginBytes((int)chain.getChainId(), (int)transactionSignature.getM(), pubKeys));
                Address multiSignAddress = new Address(chain.getChainId(), BaseConstant.P2SH_ADDRESS_TYPE, hash160);
                if (!Arrays.equals(address, multiSignAddress.getAddressBytes())) {
                    chain.getLogger().error("Multiple signature addresses generated from existing signature data are different fromFromMiddle address mismatch, The multi-signature address generated by the existing signature data does not match the multi-signature address in the From");
                    throw new NulsException(AccountErrorCode.SIGN_ADDRESS_NOT_MATCH);
                }
            }
            catch (Exception e) {
                chain.getLogger().error(e);
                throw new NulsException(AccountErrorCode.SIGNATURE_ERROR);
            }
            accountM = transactionSignature.getM();
            accountPubKeyList = transactionSignature.getPubKeyList();
        }
        if (!AddressTool.validSignAddress((List)accountPubKeyList, (byte[])account.getPubKey())) {
            throw new NulsRuntimeException(AccountErrorCode.SIGN_ADDRESS_NOT_MATCH);
        }
        transactionSignature = this.buildMultiSignTransactionSignature(transaction, multiSigAccount, account, password);
        boolean isBroadcasted = this.txMutilProcessing(chain, accountM, transaction, (TransactionSignature)transactionSignature);
        MultiSignTransactionResultDTO multiSignTransactionResultDto = new MultiSignTransactionResultDTO();
        multiSignTransactionResultDto.setBroadcasted(isBroadcasted);
        multiSignTransactionResultDto.setTransaction(transaction);
        return multiSignTransactionResultDto;
    }

    private TransactionSignature buildMultiSignTransactionSignature(Transaction transaction, MultiSigAccount multiSigAccount, Account account, String password) throws NulsException {
        P2PHKSignature p2PHKSignature2;
        List<P2PHKSignature> p2PHKSignatures;
        MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
        if (transaction.getTransactionSignature() != null) {
            transactionSignature.parse(new NulsByteBuffer(transaction.getTransactionSignature()));
            p2PHKSignatures = transactionSignature.getP2PHKSignatures();
            for (P2PHKSignature p2PHKSignature2 : p2PHKSignatures) {
                if (!Arrays.equals(p2PHKSignature2.getPublicKey(), account.getPubKey())) continue;
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ALREADY_SIGNED);
            }
        } else {
            p2PHKSignatures = new ArrayList();
            if (multiSigAccount == null) {
                throw new NulsRuntimeException(AccountErrorCode.MULTISIGN_ACCOUNT_NOT_EXIST);
            }
            transactionSignature.setM(multiSigAccount.getM());
            transactionSignature.setPubKeyList(multiSigAccount.getPubKeyList());
        }
        ECKey eckey = account.getEcKey(password);
        p2PHKSignature2 = SignatureUtil.createSignatureByEckey((Transaction)transaction, (ECKey)eckey);
        p2PHKSignatures.add(p2PHKSignature2);
        transactionSignature.setP2PHKSignatures(p2PHKSignatures);
        try {
            transaction.setTransactionSignature(transactionSignature.serialize());
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        return transactionSignature;
    }

    @Override
    public MultiSignTransactionResultDTO setMultiSignAccountAlias(Chain chain, String address, String aliasName, String signAddr, String password) throws NulsException {
        MultiSigAccount multiSigAccount = this.multiSignAccountService.getMultiSigAccountByAddress(address);
        Preconditions.checkNotNull(multiSigAccount, AccountErrorCode.MULTISIGN_ACCOUNT_NOT_EXIST);
        Transaction tx = this.createSetAliasTxWithoutSign(chain, multiSigAccount.getAddress(), aliasName, multiSigAccount.getM());
        MultiSignTxSignature transactionSignature = new MultiSignTxSignature();
        transactionSignature.setM(multiSigAccount.getM());
        transactionSignature.setPubKeyList(multiSigAccount.getPubKeyList());
        try {
            tx.setTransactionSignature(transactionSignature.serialize());
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        boolean isBroadcasted = false;
        if (null != signAddr && password != null) {
            Account account = this.accountService.getAccount(chain.getChainId(), signAddr);
            if (null == account) {
                throw new NulsRuntimeException(AccountErrorCode.ACCOUNT_NOT_EXIST);
            }
            if (account.isEncrypted() && account.isLocked() && !account.validatePassword(password)) {
                throw new NulsRuntimeException(AccountErrorCode.PASSWORD_IS_WRONG);
            }
            TransactionSignature txSignature = this.buildMultiSignTransactionSignature(tx, multiSigAccount, account, password);
            isBroadcasted = this.txMutilProcessing(chain, multiSigAccount.getM(), tx, txSignature);
        }
        MultiSignTransactionResultDTO multiSignTxResultDto = new MultiSignTransactionResultDTO();
        multiSignTxResultDto.setBroadcasted(isBroadcasted);
        multiSignTxResultDto.setTransaction(tx);
        return multiSignTxResultDto;
    }

    @Override
    public Transaction createSetAliasTxWithoutSign(Chain chain, Address address, String aliasName) throws NulsException {
        return this.createSetAliasTxWithoutSign(chain, address, aliasName, 1);
    }

    @Override
    public Transaction createSetAliasTxWithoutSign(Chain chain, Address address, String aliasName, int msign) throws NulsException {
        byte[] addressByte = address.getAddressBytes();
        AliasTransaction tx = new AliasTransaction();
        tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
        Alias alias = new Alias(addressByte, aliasName);
        try {
            tx.setTxData(alias.serialize());
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        int assetChainId = chain.getChainId();
        int assetId = chain.getConfig().getAssetId();
        NonceBalance nonceBalance = TxUtil.getBalanceNonce(chain, assetChainId, assetId, addressByte);
        byte[] nonce = nonceBalance.getNonce();
        CoinFrom coinFrom = new CoinFrom(addressByte, assetChainId, assetId, AccountConstant.ALIAS_FEE, nonce, 0);
        byte[] blackHoleAddress = AddressTool.getAddress((byte[])NulsConfig.BLACK_HOLE_PUB_KEY, (int)assetChainId);
        CoinTo coinTo = new CoinTo(blackHoleAddress, assetChainId, assetId, AccountConstant.ALIAS_FEE);
        int txSize = tx.size() + coinFrom.size() + coinTo.size() + msign * 110;
        BigInteger fee = TransactionFeeCalculator.getNormalTxFee((int)txSize, (long)100000L);
        BigInteger totalAmount = AccountConstant.ALIAS_FEE.add(fee);
        coinFrom.setAmount(totalAmount);
        BigInteger mainAsset = nonceBalance.getAvailable();
        if (BigIntegerUtils.isLessThan((BigInteger)mainAsset, (BigInteger)totalAmount)) {
            throw new NulsRuntimeException(AccountErrorCode.INSUFFICIENT_FEE);
        }
        CoinData coinData = new CoinData();
        coinData.setFrom(Arrays.asList(coinFrom));
        coinData.setTo(Arrays.asList(coinTo));
        try {
            tx.setCoinData(coinData.serialize());
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        return tx;
    }

    private Transaction createNormalTransferTx(Chain chain, List<CoinDTO> fromList, List<CoinDTO> toList, String remark) throws NulsException {
        Transaction tx = this.assemblyUnsignedTransaction(chain, fromList, toList, remark);
        ArrayList<ECKey> signEcKeys = new ArrayList<ECKey>();
        HashSet<String> addrs = new HashSet<String>();
        for (CoinDTO from : fromList) {
            if (!addrs.add(from.getAddress())) break;
            Account account = this.accountService.getAccount(chain.getChainId(), from.getAddress());
            if (null == account) {
                throw new NulsRuntimeException(AccountErrorCode.ACCOUNT_NOT_EXIST);
            }
            ECKey ecKey = account.getEcKey(from.getPassword());
            signEcKeys.add(ecKey);
        }
        try {
            SignatureUtil.createTransactionSignture((Transaction)tx, signEcKeys);
        }
        catch (IOException e) {
            LoggerUtil.LOG.error("assemblyTransaction io exception.", (Exception)e);
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        return tx;
    }

    private Transaction assemblyUnsignedTransaction(Chain chain, List<CoinDTO> fromList, List<CoinDTO> toList, String remark) throws NulsException {
        Transaction tx = new Transaction(2);
        tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
        tx.setRemark(StringUtils.bytes((String)remark));
        this.assemblyCoinData(tx, chain, fromList, toList);
        try {
            tx.setHash(NulsHash.calcHash((byte[])tx.serializeForHash()));
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        return tx;
    }

    private Transaction assemblyCoinData(Transaction tx, Chain chain, List<CoinDTO> fromList, List<CoinDTO> toList) throws NulsException {
        List<CoinFrom> coinFromList = this.assemblyCoinFrom(chain, fromList);
        List<CoinTo> coinToList = this.assemblyCoinTo(chain, toList);
        if (coinFromList.size() == 0 || coinToList.size() == 0) {
            LoggerUtil.LOG.warn("assemblyCoinData coinData params error");
            throw new NulsRuntimeException(AccountErrorCode.COINDATA_IS_INCOMPLETE);
        }
        int txSize = tx.size() + this.getSignatureSize(coinFromList);
        CoinData coinData = this.getCoinData(chain, coinFromList, coinToList, txSize);
        try {
            tx.setCoinData(coinData.serialize());
        }
        catch (IOException e) {
            throw new NulsException(AccountErrorCode.SERIALIZE_ERROR);
        }
        return tx;
    }

    private List<CoinFrom> assemblyCoinFrom(Chain chain, List<CoinDTO> listFrom) throws NulsException {
        int chainId = chain.getChainId();
        ArrayList<CoinFrom> coinFroms = new ArrayList<CoinFrom>();
        for (CoinDTO coinDto : listFrom) {
            String address = coinDto.getAddress();
            byte[] addressByte = AddressTool.getAddress((String)address);
            if (!AddressTool.validAddress((int)chainId, (String)address)) {
                chain.getLogger().error("assemblyCoinFrom address error");
                throw new NulsException(AccountErrorCode.IS_NOT_CURRENT_CHAIN_ADDRESS);
            }
            if (TxUtil.isLegalContractAddress(addressByte, chain)) {
                chain.getLogger().error("Tx from cannot have contract address ");
                throw new NulsException(AccountErrorCode.COINDATA_CANNOT_HAS_CONTRACT_ADDRESS);
            }
            int assetChainId = coinDto.getAssetsChainId();
            int assetId = coinDto.getAssetsId();
            BigInteger amount = coinDto.getAmount();
            if (BigIntegerUtils.isLessThan((BigInteger)amount, (BigInteger)BigInteger.ZERO)) {
                chain.getLogger().error("assemblyCoinFrom amount too small");
                throw new NulsException(AccountErrorCode.AMOUNT_TOO_SMALL);
            }
            NonceBalance nonceBalance = TxUtil.getBalanceNonce(chain, assetChainId, assetId, addressByte);
            BigInteger balance = nonceBalance.getAvailable();
            if (BigIntegerUtils.isLessThan((BigInteger)balance, (BigInteger)amount)) {
                chain.getLogger().error("assemblyCoinFrom insufficient amount");
                throw new NulsException(AccountErrorCode.INSUFFICIENT_BALANCE);
            }
            byte[] nonce = nonceBalance.getNonce();
            CoinFrom coinFrom = new CoinFrom(addressByte, assetChainId, assetId, amount, nonce, 0);
            coinFroms.add(coinFrom);
        }
        return coinFroms;
    }

    private List<CoinTo> assemblyCoinTo(Chain chain, List<CoinDTO> listTo) throws NulsException {
        int chainId = chain.getChainId();
        ArrayList<CoinTo> coinTos = new ArrayList<CoinTo>();
        for (CoinDTO coinDto : listTo) {
            String address = coinDto.getAddress();
            byte[] addressByte = AddressTool.getAddress((String)address);
            if (!AddressTool.validAddress((int)chainId, (String)address)) {
                chain.getLogger().error("assemblyCoinFrom address error");
                throw new NulsException(AccountErrorCode.IS_NOT_CURRENT_CHAIN_ADDRESS);
            }
            if (TxUtil.isLegalContractAddress(addressByte, chain)) {
                chain.getLogger().error("Tx to cannot have contract address ");
                throw new NulsException(AccountErrorCode.COINDATA_CANNOT_HAS_CONTRACT_ADDRESS);
            }
            int assetsChainId = coinDto.getAssetsChainId();
            int assetId = coinDto.getAssetsId();
            BigInteger amount = coinDto.getAmount();
            if (BigIntegerUtils.isLessThan((BigInteger)amount, (BigInteger)BigInteger.ZERO)) {
                chain.getLogger().error("assemblyCoinTo amount too small");
                throw new NulsException(AccountErrorCode.AMOUNT_TOO_SMALL);
            }
            CoinTo coinTo = new CoinTo();
            coinTo.setAddress(addressByte);
            coinTo.setAssetsChainId(assetsChainId);
            coinTo.setAssetsId(assetId);
            coinTo.setAmount(coinDto.getAmount());
            coinTo.setLockTime(coinDto.getLockTime());
            coinTos.add(coinTo);
        }
        return coinTos;
    }

    private CoinData getCoinData(Chain chain, List<CoinFrom> listFrom, List<CoinTo> listTo, int txSize) throws NulsException {
        BigInteger feeTotalFrom = BigInteger.ZERO;
        for (CoinFrom coinFrom : listFrom) {
            txSize += coinFrom.size();
            if (!TxUtil.isMainAsset(chain, coinFrom.getAssetsChainId(), coinFrom.getAssetsId())) continue;
            feeTotalFrom = feeTotalFrom.add(coinFrom.getAmount());
        }
        BigInteger feeTotalTo = BigInteger.ZERO;
        for (CoinTo coinTo : listTo) {
            txSize += coinTo.size();
            if (!TxUtil.isMainAsset(chain, coinTo.getAssetsChainId(), coinTo.getAssetsId())) continue;
            feeTotalTo = feeTotalTo.add(coinTo.getAmount());
        }
        BigInteger bigInteger = TransactionFeeCalculator.getNormalTxFee((int)txSize, (long)100000L);
        BigInteger actualFee = feeTotalFrom.subtract(feeTotalTo);
        if (BigIntegerUtils.isLessThan((BigInteger)actualFee, (BigInteger)BigInteger.ZERO)) {
            chain.getLogger().error("insufficient fee");
            throw new NulsException(AccountErrorCode.INSUFFICIENT_FEE);
        }
        if (BigIntegerUtils.isLessThan((BigInteger)actualFee, (BigInteger)bigInteger) && BigIntegerUtils.isLessThan((BigInteger)(actualFee = this.getFeeDirect(chain, listFrom, bigInteger, actualFee)), (BigInteger)bigInteger) && !this.getFeeIndirect(chain, listFrom, txSize, bigInteger, actualFee)) {
            chain.getLogger().error("insufficient fee");
            throw new NulsException(AccountErrorCode.INSUFFICIENT_FEE);
        }
        CoinData coinData = new CoinData();
        coinData.setFrom(listFrom);
        coinData.setTo(listTo);
        return coinData;
    }

    private BigInteger getFeeDirect(Chain chain, List<CoinFrom> listFrom, BigInteger targetFee, BigInteger actualFee) throws NulsException {
        for (CoinFrom coinFrom : listFrom) {
            BigInteger current;
            if (!TxUtil.isChainAssetExist(chain, (Coin)coinFrom)) continue;
            NonceBalance nonceBalance = TxUtil.getBalanceNonce(chain, coinFrom.getAssetsChainId(), coinFrom.getAssetsId(), coinFrom.getAddress());
            BigInteger mainAsset = nonceBalance.getAvailable();
            if (BigIntegerUtils.isEqualOrGreaterThan((BigInteger)(mainAsset = mainAsset.subtract(coinFrom.getAmount())), (BigInteger)(current = targetFee.subtract(actualFee)))) {
                coinFrom.setAmount(coinFrom.getAmount().add(current));
                actualFee = actualFee.add(current);
                break;
            }
            if (!BigIntegerUtils.isGreaterThan((BigInteger)mainAsset, (BigInteger)BigInteger.ZERO)) continue;
            coinFrom.setAmount(coinFrom.getAmount().add(mainAsset));
            actualFee = actualFee.add(mainAsset);
        }
        return actualFee;
    }

    private boolean getFeeIndirect(Chain chain, List<CoinFrom> listFrom, int txSize, BigInteger targetFee, BigInteger actualFee) throws NulsException {
        ListIterator<CoinFrom> iterator = listFrom.listIterator();
        block0: while (iterator.hasNext()) {
            int assetsId;
            CoinFrom coinFrom = iterator.next();
            if (TxUtil.isChainAssetExist(chain, (Coin)coinFrom)) continue;
            for (CoinFrom coin : listFrom) {
                if (!Arrays.equals(coin.getAddress(), coinFrom.getAddress()) || !TxUtil.isChainAssetExist(chain, (Coin)coin)) continue;
                continue block0;
            }
            int assetsChainId = chain.getConfig().getChainId();
            NonceBalance nonceBalance = TxUtil.getBalanceNonce(chain, assetsChainId, assetsId = chain.getConfig().getAssetId(), coinFrom.getAddress());
            BigInteger mainAsset = nonceBalance.getAvailable();
            if (BigIntegerUtils.isEqualOrLessThan((BigInteger)mainAsset, (BigInteger)BigInteger.ZERO)) continue;
            CoinFrom feeCoinFrom = new CoinFrom();
            byte[] address = coinFrom.getAddress();
            feeCoinFrom.setAddress(address);
            feeCoinFrom.setNonce(nonceBalance.getNonce());
            targetFee = TransactionFeeCalculator.getNormalTxFee((int)(txSize += feeCoinFrom.size()), (long)100000L);
            BigInteger current = targetFee.subtract(actualFee);
            BigInteger fee = BigIntegerUtils.isEqualOrGreaterThan((BigInteger)mainAsset, (BigInteger)current) ? current : mainAsset;
            feeCoinFrom.setLocked((byte)0);
            feeCoinFrom.setAssetsChainId(assetsChainId);
            feeCoinFrom.setAssetsId(assetsId);
            feeCoinFrom.setAmount(fee);
            iterator.add(feeCoinFrom);
            if (!BigIntegerUtils.isEqualOrGreaterThan((BigInteger)(actualFee = actualFee.add(fee)), (BigInteger)targetFee)) continue;
            break;
        }
        return BigIntegerUtils.isEqualOrGreaterThan((BigInteger)actualFee, (BigInteger)targetFee);
    }

    private int getSignatureSize(List<CoinFrom> coinFroms) {
        int size = 0;
        HashSet<String> commonAddress = new HashSet<String>();
        for (CoinFrom coinFrom : coinFroms) {
            String address = AddressTool.getStringAddressByBytes((byte[])coinFrom.getAddress());
            if (AddressTool.isMultiSignAddress((byte[])coinFrom.getAddress())) {
                MultiSigAccount multiSigAccount = this.multiSignAccountService.getMultiSigAccountByAddress(address);
                return size += multiSigAccount.getPubKeyList().size() * 110;
            }
            commonAddress.add(address);
        }
        return size += commonAddress.size() * 110;
    }

    private int getMultiSignAddressSignatureSize(int signNumber) {
        int size = signNumber * 110;
        return size;
    }

    public boolean txMutilProcessing(Chain chain, byte m, Transaction tx, TransactionSignature txSignature) throws NulsException {
        if (m == txSignature.getP2PHKSignatures().size()) {
            TransactionCall.newTx(chain, tx);
            return true;
        }
        return false;
    }
}

