/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.storage.impl;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.po.MultiSigAccountPO;
import io.nuls.account.storage.MultiSigAccountStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.base.data.Address;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.List;

@Component
public class MultiSigAccountStorageServiceImpl
implements MultiSigAccountStorageService,
InitializingBean {
    public void afterPropertiesSet() {
    }

    @Override
    public boolean saveAccount(MultiSigAccountPO multiSigAccountPo) {
        try {
            return RocksDBService.put((String)"multi_account", (byte[])multiSigAccountPo.getAddress().getAddressBytes(), (byte[])multiSigAccountPo.serialize());
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("", e);
            throw new NulsRuntimeException(AccountErrorCode.DB_SAVE_BATCH_ERROR);
        }
    }

    @Override
    public boolean removeAccount(Address address) {
        if (null == address || address.getAddressBytes() == null || address.getAddressBytes().length <= 0) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
        }
        try {
            return RocksDBService.delete((String)"multi_account", (byte[])address.getAddressBytes());
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_SAVE_ERROR);
        }
    }

    @Override
    public List<MultiSigAccountPO> getAccountList() {
        ArrayList<MultiSigAccountPO> multiSigAccountPOList = new ArrayList<MultiSigAccountPO>();
        try {
            List list = RocksDBService.valueList((String)"multi_account");
            if (list != null) {
                for (byte[] value : list) {
                    MultiSigAccountPO multiSigAccountPo = new MultiSigAccountPO();
                    multiSigAccountPo.parse(value, 0);
                    multiSigAccountPOList.add(multiSigAccountPo);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_QUERY_ERROR);
        }
        return multiSigAccountPOList;
    }

    @Override
    public MultiSigAccountPO getAccount(byte[] address) {
        byte[] multiSigAccountPoBytes = RocksDBService.get((String)"multi_account", (byte[])address);
        if (null == multiSigAccountPoBytes) {
            return null;
        }
        MultiSigAccountPO multiSigAccountPo = new MultiSigAccountPO();
        try {
            multiSigAccountPo.parse(multiSigAccountPoBytes, 0);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_QUERY_ERROR);
        }
        return multiSigAccountPo;
    }
}

