/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.tx.v1;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.service.TransactionService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="TransferProcessorV1")
public class TransferProcessor
implements TransactionProcessor {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private TransactionService transactionService;

    public int getType() {
        return 2;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        HashMap<String, Object> result = null;
        Chain chain = null;
        try {
            chain = this.chainManager.getChain(chainId);
            result = new HashMap<String, Object>(4);
            String errorCode = null;
            if (chain == null) {
                errorCode = AccountErrorCode.CHAIN_NOT_EXIST.getCode();
                chain.getLogger().error("chain is not exist, -chainId:{}", new Object[]{chainId});
                result.put("txList", txs);
                result.put("errorCode", errorCode);
                return result;
            }
            ArrayList<Transaction> txList = new ArrayList<Transaction>();
            for (Transaction tx : txs) {
                try {
                    Result rs = this.transactionService.transferTxValidate(chain, tx);
                    if (!rs.isFailed()) continue;
                    errorCode = rs.getErrorCode().getCode();
                    txList.add(tx);
                }
                catch (NulsException e) {
                    chain.getLogger().error(e);
                    errorCode = e.getErrorCode().getCode();
                    txList.add(tx);
                }
            }
            result.put("txList", txList);
            result.put("errorCode", errorCode);
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            result.put("txList", txs);
            result.put("errorCode", AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        return true;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        return true;
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

