/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.util;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Account;
import io.nuls.base.data.Address;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.crypto.Sha256Hash;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.math.BigInteger;

public class AccountTool {
    public static final int CREATE_MAX_SIZE = 100;
    public static final int CREATE_MULTI_SIGACCOUNT_MIN_SIZE = 1;

    public static Address newAddress(int chainId, String prikey) {
        ECKey key;
        try {
            key = ECKey.fromPrivate((BigInteger)new BigInteger(1, HexUtil.decode((String)prikey)));
        }
        catch (Exception e) {
            throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG);
        }
        return AccountTool.newAddress(chainId, key.getPubKey());
    }

    public static Address newAddress(int chainId, ECKey key) {
        return AccountTool.newAddress(chainId, key.getPubKey());
    }

    public static Address newAddress(int chainId, byte[] publicKey) {
        return new Address(chainId, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])publicKey));
    }

    public static Account createAccount(int chainId, String prikey, String prefix) throws NulsException {
        ECKey key = null;
        if (StringUtils.isBlank((String)prikey)) {
            key = new ECKey();
        } else {
            try {
                key = ECKey.fromPrivate((BigInteger)new BigInteger(1, HexUtil.decode((String)prikey)));
            }
            catch (Exception e) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG, (Throwable)e);
            }
        }
        Address address = new Address(chainId, prefix, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])key.getPubKey()));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(key.getPubKey());
        account.setPriKey(key.getPrivKeyBytes());
        account.setEncryptedPriKey(new byte[0]);
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        account.setEcKey(key);
        return account;
    }

    public static Account createAccount(int chainId, String prikey) throws NulsException {
        ECKey key = null;
        if (StringUtils.isBlank((String)prikey)) {
            key = new ECKey();
        } else {
            try {
                key = ECKey.fromPrivate((BigInteger)new BigInteger(1, HexUtil.decode((String)prikey)));
            }
            catch (Exception e) {
                throw new NulsException(AccountErrorCode.PRIVATE_KEY_WRONG, (Throwable)e);
            }
        }
        Address address = new Address(chainId, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])key.getPubKey()));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(key.getPubKey());
        account.setPriKey(key.getPrivKeyBytes());
        account.setEncryptedPriKey(new byte[0]);
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        account.setEcKey(key);
        return account;
    }

    public static Account createAccountByPubKey(int chainId, String encryptedPriKey, byte[] pubKey) {
        Address address = new Address(chainId, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])pubKey));
        Account account = new Account();
        account.setChainId(chainId);
        account.setAddress(address);
        account.setPubKey(pubKey);
        account.setEncryptedPriKey(HexUtil.decode((String)encryptedPriKey));
        account.setCreateTime(NulsDateUtils.getCurrentTimeMillis());
        return account;
    }

    public static Account createAccount(int chainId) throws NulsException {
        return AccountTool.createAccount(chainId, null);
    }

    public static Address createContractAddress(int chainId) {
        ECKey key = new ECKey();
        return new Address(chainId, BaseConstant.CONTRACT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])key.getPubKey()));
    }

    public static BigInteger genPrivKey(byte[] encryptedPriKey, byte[] pw) {
        byte[] privSeedSha256 = Sha256Hash.hash((byte[])encryptedPriKey);
        byte[] pwSha256 = Sha256Hash.hash((byte[])pw);
        byte[] pwPriBytes = new byte[privSeedSha256.length + pwSha256.length];
        for (int i = 0; i < pwPriBytes.length; i += 2) {
            int index = i / 2;
            pwPriBytes[index] = privSeedSha256[index];
            pwPriBytes[index + 1] = pwSha256[index];
        }
        return new BigInteger(1, Sha256Hash.hash((byte[])pwPriBytes));
    }
}

