/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.util;

import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsRuntimeException;
import javax.annotation.Nullable;

public class Preconditions {
    public static void checkArgument(boolean expression, @Nullable ErrorCode message) {
        if (!expression) {
            throw new NulsRuntimeException(message);
        }
    }

    public static void checkNotNull(Object object, @Nullable ErrorCode message) {
        if (object == null) {
            throw new NulsRuntimeException(message);
        }
    }

    public static void checkNotEmpty(Object object, @Nullable ErrorCode message) {
        if (object == null) {
            throw new NulsRuntimeException(message);
        }
        if (object instanceof String && ((String)object).trim().length() == 0) {
            throw new NulsRuntimeException(message);
        }
    }

    public static void checkNotNull(Object[] objects, @Nullable ErrorCode message) {
        if (objects == null) {
            throw new NulsRuntimeException(message);
        }
        for (Object temp : objects) {
            Preconditions.checkNotNull(temp, message);
        }
    }
}

