/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.util;

import io.nuls.account.config.NulsConfig;
import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.NonceBalance;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.rpc.call.LedgerCall;
import io.nuls.account.util.LoggerUtil;
import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.Coin;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.Transaction;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.BigIntegerUtils;
import io.nuls.core.model.StringUtils;
import java.math.BigInteger;
import java.util.HashMap;

public class TxUtil {
    public static boolean isMainAsset(Chain chain, int assetChainId, int assetId) {
        if (chain == null) {
            throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
        }
        return chain.getConfig().getChainId() == assetChainId && chain.getConfig().getAssetId() == assetId;
    }

    public static boolean isNulsAsset(int chainId, int assetId) {
        return chainId == NulsConfig.MAIN_CHAIN_ID && assetId == NulsConfig.MAIN_ASSETS_ID;
    }

    public static boolean isNulsAsset(Coin coin) {
        return TxUtil.isNulsAsset(coin.getAssetsChainId(), coin.getAssetsId());
    }

    public static boolean isChainAssetExist(Chain chain, Coin coin) {
        return chain.getConfig().getChainId() == coin.getAssetsChainId() && chain.getConfig().getAssetId() == coin.getAssetsId();
    }

    public static BigInteger getBalance(Chain chain, int assetChainId, int assetId, byte[] addressByte) {
        String address = AddressTool.getStringAddressByBytes((byte[])addressByte);
        HashMap balanceNonce = LedgerCall.getBalanceNonce(chain, assetChainId, assetId, address);
        if (balanceNonce != null) {
            Object available = balanceNonce.get("available");
            return BigIntegerUtils.stringToBigInteger((String)String.valueOf(available));
        }
        return new BigInteger("0");
    }

    public static NonceBalance getBalanceNonce(Chain chain, int assetChainId, int assetId, byte[] addressByte) {
        String address = AddressTool.getStringAddressByBytes((byte[])addressByte);
        HashMap balanceNonce = LedgerCall.getBalanceNonce(chain, assetChainId, assetId, address);
        if (balanceNonce != null) {
            Object available = balanceNonce.get("available");
            String strNonce = (String)balanceNonce.get("nonce");
            return new NonceBalance(RPCUtil.decode((String)strNonce), BigIntegerUtils.stringToBigInteger((String)String.valueOf(available)));
        }
        return new NonceBalance(null, new BigInteger("0"));
    }

    public static BigInteger getConfirmedBalance(Chain chain, int assetChainId, int assetId, byte[] addressByte) {
        String address = AddressTool.getStringAddressByBytes((byte[])addressByte);
        return LedgerCall.getBalance(chain, assetChainId, assetId, address);
    }

    public static CoinData getCoinData(Transaction tx) throws NulsException {
        if (null == tx) {
            throw new NulsException(AccountErrorCode.TX_NOT_EXIST);
        }
        try {
            return tx.getCoinDataInstance();
        }
        catch (NulsException e) {
            LoggerUtil.LOG.error(e);
            throw new NulsException(AccountErrorCode.DESERIALIZE_ERROR);
        }
    }

    public static Transaction getTransaction(byte[] txBytes) throws NulsException {
        if (null == txBytes || txBytes.length == 0) {
            throw new NulsException(AccountErrorCode.DATA_NOT_FOUND);
        }
        try {
            return Transaction.getInstance((byte[])txBytes);
        }
        catch (NulsException e) {
            LoggerUtil.LOG.error(e);
            throw new NulsException(AccountErrorCode.DESERIALIZE_ERROR);
        }
    }

    public static Transaction getTransaction(String hex) throws NulsException {
        if (StringUtils.isBlank((String)hex)) {
            throw new NulsException(AccountErrorCode.DATA_NOT_FOUND);
        }
        return TxUtil.getTransaction(RPCUtil.decode((String)hex));
    }

    public static <T> T getInstanceRpcStr(String data, Class<? extends BaseNulsData> clazz) throws NulsException {
        if (StringUtils.isBlank((String)data)) {
            throw new NulsException(AccountErrorCode.DATA_NOT_FOUND);
        }
        return TxUtil.getInstance(RPCUtil.decode((String)data), clazz);
    }

    public static <T> T getInstance(byte[] bytes, Class<? extends BaseNulsData> clazz) throws NulsException {
        if (null == bytes || bytes.length == 0) {
            throw new NulsException(AccountErrorCode.DATA_NOT_FOUND);
        }
        try {
            BaseNulsData baseNulsData = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            baseNulsData.parse(new NulsByteBuffer(bytes));
            return (T)baseNulsData;
        }
        catch (NulsException e) {
            LoggerUtil.LOG.error(e);
            throw new NulsException(AccountErrorCode.DESERIALIZE_ERROR);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
            throw new NulsException(AccountErrorCode.DESERIALIZE_ERROR);
        }
    }

    public static <T> T getInstance(String hex, Class<? extends BaseNulsData> clazz) throws NulsException {
        if (StringUtils.isBlank((String)hex)) {
            throw new NulsException(AccountErrorCode.DATA_NOT_FOUND);
        }
        return TxUtil.getInstance(RPCUtil.decode((String)hex), clazz);
    }

    public static Result getSuccess() {
        return Result.getSuccess((ErrorCode)AccountErrorCode.SUCCESS);
    }

    public static boolean isLegalContractAddress(byte[] addressBytes, Chain chain) {
        if (addressBytes == null) {
            return false;
        }
        return AddressTool.validContractAddress((byte[])addressBytes, (int)chain.getChainId());
    }
}

