/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseBusinessMessage;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.Block;
import io.nuls.base.data.NulsHash;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class BlockMessage
extends BaseBusinessMessage {
    private NulsHash requestHash;
    private Block block;
    private boolean syn;

    public NulsHash getRequestHash() {
        return this.requestHash;
    }

    public void setRequestHash(NulsHash requestHash) {
        this.requestHash = requestHash;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public BlockMessage(NulsHash requestHash, Block block, boolean syn) {
        this.requestHash = requestHash;
        this.block = block;
        this.syn = syn;
    }

    public boolean isSyn() {
        return this.syn;
    }

    public BlockMessage() {
    }

    public void setSyn(boolean syn) {
        this.syn = syn;
    }

    public void serializeToStream(NulsOutputStreamBuffer buffer) throws IOException {
        buffer.write(this.requestHash.getBytes());
        buffer.writeNulsData((BaseNulsData)this.block);
        buffer.writeBoolean(this.syn);
    }

    public void parse(NulsByteBuffer nulsByteBuffer) throws NulsException {
        this.requestHash = nulsByteBuffer.readHash();
        this.block = (Block)nulsByteBuffer.readNulsData((BaseNulsData)new Block());
        this.syn = nulsByteBuffer.readBoolean();
    }

    public int size() {
        return 32 + SerializeUtils.sizeOfNulsData((NulsData)this.block) + SerializeUtils.sizeOfBoolean();
    }
}

