/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.NulsHash;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.block.BlockBootstrap;
import io.nuls.block.constant.BlockForwardEnum;
import io.nuls.block.constant.StatusEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.HashListMessage;
import io.nuls.block.message.HashMessage;
import io.nuls.block.model.CachedSmallBlock;
import io.nuls.block.model.ChainContext;
import io.nuls.block.model.TxGroupTask;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.thread.monitor.TxGroupRequestor;
import io.nuls.block.utils.SmallBlockCacher;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;
import java.util.List;

@Component(value="ForwardSmallBlockHandlerV1")
public class ForwardSmallBlockHandler
implements MessageProcessor {
    public String getCmd() {
        return "forward";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        HashMessage message = (HashMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, HashMessage.class));
        if (message == null) {
            return;
        }
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        NulsHash blockHash = message.getRequestHash();
        Long height = context.getCachedHashHeightMap().get(blockHash);
        if (height != null) {
            NetworkCall.setHashAndHeight(chainId, blockHash, height, nodeId);
        }
        BlockForwardEnum status = SmallBlockCacher.getStatus(chainId, blockHash);
        List<String> nodes = context.getOrphanBlockRelatedNodes().get(blockHash);
        if (nodes != null && !nodes.contains(nodeId)) {
            nodes.add(nodeId);
            logger.debug("add OrphanBlockRelatedNodes, blockHash-{}, nodeId-{}", new Object[]{blockHash, nodeId});
        }
        if (BlockForwardEnum.COMPLETE.equals((Object)status)) {
            return;
        }
        if (BlockForwardEnum.INCOMPLETE.equals((Object)status) && !context.getStatus().equals((Object)StatusEnum.SYNCHRONIZING)) {
            CachedSmallBlock block = SmallBlockCacher.getCachedSmallBlock(chainId, blockHash);
            if (block == null) {
                return;
            }
            HashListMessage request = new HashListMessage();
            request.setBlockHash(blockHash);
            request.setTxHashList(block.getMissingTransactions());
            TxGroupTask task = new TxGroupTask();
            task.setId(System.nanoTime());
            task.setNodeId(nodeId);
            task.setRequest(request);
            task.setExcuteTime(BlockBootstrap.blockConfig.getTxGroupTaskDelay());
            TxGroupRequestor.addTask(chainId, blockHash.toString(), task);
            return;
        }
        if (BlockForwardEnum.EMPTY.equals((Object)status)) {
            HashMessage request = new HashMessage();
            request.setRequestHash(blockHash);
            NetworkCall.sendToNode(chainId, request, nodeId, "getsBlock");
        }
    }
}

