/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Block;
import io.nuls.base.data.NulsHash;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.BlockMessage;
import io.nuls.block.message.HeightRangeMessage;
import io.nuls.block.model.ChainContext;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.service.BlockService;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;

@Component(value="GetBlocksHandlerV1")
public class GetBlocksHandler
implements MessageProcessor {
    @Autowired
    private BlockService service;

    private void sendBlock(int chainId, Block block, String nodeId, NulsHash requestHash) {
        BlockMessage blockMessage = new BlockMessage(requestHash, block, true);
        NetworkCall.sendToNode(chainId, blockMessage, nodeId, "block");
    }

    public String getCmd() {
        return "getBlocks";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        HeightRangeMessage message = (HeightRangeMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, HeightRangeMessage.class));
        if (message == null) {
            return;
        }
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        long startHeight = message.getStartHeight();
        long endHeight = message.getEndHeight();
        if (startHeight < 0L || startHeight > endHeight || endHeight - startHeight > (long)context.getParameters().getDownloadNumber()) {
            logger.error("PARAMETER_ERROR");
            return;
        }
        try {
            NulsHash requestHash = NulsHash.calcHash((byte[])message.serialize());
            do {
                Block block;
                if ((block = this.service.getBlock(chainId, startHeight++)) == null) {
                    NetworkCall.sendFail(chainId, requestHash, nodeId);
                    return;
                }
                this.sendBlock(chainId, block, nodeId, requestHash);
            } while (endHeight >= startHeight);
            NetworkCall.sendSuccess(chainId, requestHash, nodeId);
        }
        catch (Exception e) {
            logger.error("error occur when send block", e);
        }
    }
}

