/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.message.handler;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.SmallBlock;
import io.nuls.base.protocol.MessageProcessor;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.HashMessage;
import io.nuls.block.message.SmallBlockMessage;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.utils.SmallBlockCacher;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;

@Component(value="GetSmallBlockHandlerV1")
public class GetSmallBlockHandler
implements MessageProcessor {
    public String getCmd() {
        return "getsBlock";
    }

    public void process(int chainId, String nodeId, String msgStr) {
        HashMessage message = (HashMessage)((Object)RPCUtil.getInstanceRpcStr((String)msgStr, HashMessage.class));
        if (message == null) {
            return;
        }
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        NulsHash blockHash = message.getRequestHash();
        SmallBlock smallBlock = SmallBlockCacher.getSmallBlock(chainId, blockHash);
        if (smallBlock != null) {
            SmallBlockMessage smallBlockMessage = new SmallBlockMessage();
            smallBlockMessage.setSmallBlock(smallBlock);
            NetworkCall.sendToNode(chainId, smallBlockMessage, nodeId, "sBlock");
        }
    }
}

