/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.model;

import io.nuls.base.data.NulsHash;
import io.nuls.block.constant.NodeEnum;
import io.nuls.block.utils.LoggerUtil;
import java.util.StringJoiner;

public class Node {
    private String id;
    private long height;
    private long startHeight;
    private long endHeight;
    private NulsHash hash;
    private int credit = 50;
    private int failedCount = 0;
    private long startTime = 0L;
    private NodeEnum nodeEnum;

    public long getStartHeight() {
        return this.startHeight;
    }

    public void setStartHeight(long startHeight) {
        this.startHeight = startHeight;
    }

    public long getEndHeight() {
        return this.endHeight;
    }

    public void setEndHeight(long endHeight) {
        this.endHeight = endHeight;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public NodeEnum getNodeEnum() {
        return this.nodeEnum;
    }

    public void setNodeEnum(NodeEnum nodeEnum) {
        this.nodeEnum = nodeEnum;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public NulsHash getHash() {
        return this.hash;
    }

    public void setHash(NulsHash hash) {
        this.hash = hash;
    }

    public int getCredit() {
        return this.credit;
    }

    public void setCredit(int credit) {
        this.credit = Math.max(credit, 10);
    }

    public synchronized void adjustCredit(boolean success) {
        if (this.nodeEnum.equals((Object)NodeEnum.TIMEOUT)) {
            return;
        }
        int oldCredit = this.credit;
        if (success) {
            this.credit = Math.min(100, this.credit + 10);
        } else {
            this.credit >>= 3;
            ++this.failedCount;
            if (this.credit == 0 || this.failedCount > 10) {
                this.setNodeEnum(NodeEnum.TIMEOUT);
                LoggerUtil.COMMON_LOG.warn("node-{}, credit-{}, failedCount-{}, this node was marked unavailable", new Object[]{this.id, this.credit, this.failedCount});
            }
        }
        if (!success) {
            LoggerUtil.COMMON_LOG.warn("download fail! node-" + this.id + ",oldCredit-" + oldCredit + ",newCredit-" + this.credit);
        }
    }

    public String toString() {
        return new StringJoiner(", ", Node.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("height=" + this.height).add("hash=" + this.hash).add("credit=" + this.credit).add("nodeEnum=" + this.nodeEnum).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.id != null ? this.id.equals(node.id) : node.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

