/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.block.constant.BlockErrorCode;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.ChainContext;
import io.nuls.block.service.BlockService;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class ConsensusCall {
    @Autowired
    private static BlockService service;

    public static Result verify(int chainId, Block block, int download) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            Map responseData;
            Map v;
            boolean value;
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            params.put("chainId", chainId);
            params.put("download", download);
            params.put("block", RPCUtil.encode((byte[])block.serialize()));
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_validBlock", params, (long)600000L);
            if (response.isSuccess() && (value = ((Boolean)(v = (Map)(responseData = (Map)response.getResponseData()).get("cs_validBlock")).get("value")).booleanValue())) {
                List contractList = (List)v.get("contractList");
                return Result.getSuccess((ErrorCode)BlockErrorCode.SUCCESS).setData((Object)contractList);
            }
            return Result.getFailed((ErrorCode)ErrorCode.init((String)response.getResponseErrorCode()));
        }
        catch (Exception e) {
            logger.error("", e);
            return Result.getFailed((ErrorCode)BlockErrorCode.BLOCK_VERIFY_ERROR);
        }
    }

    public static boolean notice(int chainId, int status) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>(2);
            params.put("chainId", chainId);
            params.put("status", status);
            return ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_updateAgentStatus", params).isSuccess();
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }

    public static boolean evidence(int chainId, BlockService blockService, BlockHeader forkHeader) {
        String forkHeaderPackingAddress;
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        long forkHeaderHeight = forkHeader.getHeight();
        if (context.getLatestHeight() < forkHeaderHeight) {
            return true;
        }
        BlockHeader masterHeader = blockService.getBlockHeader(chainId, forkHeaderHeight);
        if (masterHeader.getHash().equals((Object)forkHeader.getHash())) {
            return true;
        }
        String masterHeaderPackingAddress = AddressTool.getStringAddressByBytes((byte[])masterHeader.getPackingAddress(chainId)) + masterHeader.getHeight();
        if (!masterHeaderPackingAddress.equals(forkHeaderPackingAddress = AddressTool.getStringAddressByBytes((byte[])forkHeader.getPackingAddress(chainId)) + forkHeader.getHeight())) {
            return true;
        }
        List<String> packingAddressList = context.getPackingAddressList();
        for (String tmp : packingAddressList) {
            if (!masterHeaderPackingAddress.equals(tmp)) continue;
            return true;
        }
        packingAddressList.add(masterHeaderPackingAddress);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            params.put("chainId", chainId);
            params.put("blockHeader", RPCUtil.encode((byte[])masterHeader.serialize()));
            params.put("evidenceHeader", RPCUtil.encode((byte[])forkHeader.serialize()));
            return ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_addEvidenceRecord", params).isSuccess();
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }

    public static boolean rollbackNotice(int chainId, long height) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Number> params = new HashMap<String, Number>(2);
            params.put("chainId", chainId);
            params.put("height", height);
            return ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_chainRollBack", params).isSuccess();
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }

    public static boolean saveNotice(int chainId, BlockHeader blockHeader, boolean localInit) {
        if (localInit) {
            return true;
        }
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("chainId", chainId);
            params.put("blockHeader", RPCUtil.encode((byte[])blockHeader.serialize()));
            return ResponseMessageProcessor.requestAndResponse((String)ModuleE.CS.abbr, (String)"cs_addBlock", params).isSuccess();
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }
}

