/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.BaseBusinessMessage;
import io.nuls.base.data.NulsHash;
import io.nuls.block.constant.NodeEnum;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.CompleteMessage;
import io.nuls.block.model.Node;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkCall {
    public static List<Node> getAvailableNodes(int chainId) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(6);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("state", 1);
            params.put("isCross", false);
            params.put("startPage", 0);
            params.put("pageSize", 0);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_getNodes", params);
            if (!response.isSuccess()) {
                return List.of();
            }
            Map responseData = (Map)response.getResponseData();
            List list = (List)responseData.get("nw_getNodes");
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Object o : list) {
                Map map = (Map)o;
                Node node = new Node();
                node.setId((String)map.get("nodeId"));
                node.setHeight(Long.parseLong(map.get("blockHeight").toString()));
                String blockHash = (String)map.get("blockHash");
                if (StringUtils.isBlank((String)blockHash)) continue;
                node.setHash(NulsHash.fromHex((String)blockHash));
                node.setNodeEnum(NodeEnum.IDLE);
                nodes.add(node);
            }
            return nodes;
        }
        catch (Exception e) {
            logger.error("", e);
            return List.of();
        }
    }

    public static void resetNetwork(int chainId) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_reconnect", params);
            logger.info("resetNetwork......");
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }

    public static boolean broadcast(int chainId, BaseBusinessMessage message, String excludeNodes, String command) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("excludeNodes", excludeNodes);
            params.put("messageBody", RPCUtil.encode((byte[])message.serialize()));
            params.put("command", command);
            boolean success = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_broadcast", params).isSuccess();
            return success;
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }

    public static boolean sendToNode(int chainId, BaseBusinessMessage message, String nodeId, String command) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            params.put("version", "1.0");
            params.put("chainId", chainId);
            params.put("nodes", nodeId);
            params.put("messageBody", RPCUtil.encode((byte[])message.serialize()));
            params.put("command", command);
            boolean success = ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_sendPeersMsg", params).isSuccess();
            return success;
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }

    public static boolean broadcast(int chainId, BaseBusinessMessage message, String command) {
        return NetworkCall.broadcast(chainId, message, null, command);
    }

    public static void sendFail(int chainId, NulsHash hash, String nodeId) {
        CompleteMessage message = new CompleteMessage();
        message.setRequestHash(hash);
        message.setSuccess(false);
        NetworkCall.sendToNode(chainId, message, nodeId, "complete");
    }

    public static void sendSuccess(int chainId, NulsHash hash, String nodeId) {
        CompleteMessage message = new CompleteMessage();
        message.setRequestHash(hash);
        message.setSuccess(true);
        NetworkCall.sendToNode(chainId, message, nodeId, "complete");
    }

    public static void setHashAndHeight(int chainId, NulsHash hash, long height, String nodeId) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            params.put("chainId", chainId);
            params.put("nodeId", nodeId);
            params.put("blockHeight", height);
            params.put("blockHash", hash.toString());
            ResponseMessageProcessor.requestAndResponse((String)ModuleE.NW.abbr, (String)"nw_updateNodeInfo", params);
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }
}

