/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.rpc.call;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.data.po.BlockHeaderPo;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.utils.BlockUtil;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionCall {
    public static boolean notice(int chainId, int status) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>(2);
            params.put("chainId", chainId);
            params.put("status", status);
            return ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_bl_state", params).isSuccess();
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }

    public static List<Integer> getSystemTypes(int chainId) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Integer> params = new HashMap<String, Integer>(2);
            params.put("chainId", chainId);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_getSystemTypes", params);
            if (response.isSuccess()) {
                Map responseData = (Map)response.getResponseData();
                Map types = (Map)responseData.get("tx_getSystemTypes");
                return (List)types.get("list");
            }
            return List.of();
        }
        catch (Exception e) {
            logger.error("", e);
            return List.of();
        }
    }

    public static boolean save(int chainId, BlockHeaderPo blockHeaderPo, List<Transaction> txs, boolean localInit, List contractList) {
        if (localInit) {
            return TransactionCall.saveGengsisTransaction(chainId, blockHeaderPo, txs);
        }
        return TransactionCall.saveNormal(chainId, blockHeaderPo, txs, contractList);
    }

    public static boolean saveNormal(int chainId, BlockHeaderPo blockHeaderPo, List<Transaction> txs, List contractList) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("chainId", chainId);
            ArrayList<String> txList = new ArrayList<String>();
            for (Transaction transaction : txs) {
                txList.add(RPCUtil.encode((byte[])transaction.serialize()));
            }
            params.put("txList", txList);
            params.put("blockHeader", RPCUtil.encode((byte[])BlockUtil.fromBlockHeaderPo(blockHeaderPo).serialize()));
            params.put("contractList", contractList);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_save", params, (long)60000L);
            if (response.isSuccess()) {
                Map responseData = (Map)response.getResponseData();
                Map data = (Map)responseData.get("tx_save");
                return (Boolean)data.get("value");
            }
            logger.error("txsave false-" + response.getResponseErrorCode());
            return false;
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }

    public static boolean rollback(int chainId, BlockHeaderPo blockHeaderPo) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("chainId", chainId);
            List txHashList = blockHeaderPo.getTxHashList();
            ArrayList list = new ArrayList();
            txHashList.forEach(e -> list.add(e.toHex()));
            params.put("txHashList", list);
            params.put("blockHeader", RPCUtil.encode((byte[])BlockUtil.fromBlockHeaderPo(blockHeaderPo).serialize()));
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_rollback", params, (long)60000L);
            if (response.isSuccess()) {
                Map responseData = (Map)response.getResponseData();
                Map data = (Map)responseData.get("tx_rollback");
                return (Boolean)data.get("value");
            }
            return false;
        }
        catch (Exception e2) {
            logger.error("", e2);
            return false;
        }
    }

    public static List<Transaction> getConfirmedTransactions(int chainId, List<NulsHash> hashList, long timeout) {
        ArrayList<Transaction> transactions;
        block5: {
            transactions = new ArrayList<Transaction>();
            NulsLogger logger = ContextManager.getContext(chainId).getLogger();
            try {
                HashMap<String, Serializable> params = new HashMap<String, Serializable>(2);
                params.put("chainId", Integer.valueOf(chainId));
                ArrayList t = new ArrayList();
                hashList.forEach(e -> t.add(e.toHex()));
                params.put("txHashList", t);
                Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_getBlockTxs", params, (long)timeout);
                if (response.isSuccess()) {
                    Map responseData = (Map)response.getResponseData();
                    Map map = (Map)responseData.get("tx_getBlockTxs");
                    List txHexList = (List)map.get("txList");
                    if (txHexList == null || txHexList.isEmpty()) {
                        return Collections.emptyList();
                    }
                    for (String txHex : txHexList) {
                        Transaction transaction = new Transaction();
                        transaction.parse(new NulsByteBuffer(RPCUtil.decode((String)txHex)));
                        transactions.add(transaction);
                    }
                    break block5;
                }
                return Collections.emptyList();
            }
            catch (Exception e2) {
                logger.error("", e2);
                return Collections.emptyList();
            }
        }
        return transactions;
    }

    public static List<Transaction> getTransactions(int chainId, List<NulsHash> hashList, boolean allHits) {
        ArrayList<Transaction> transactions;
        block6: {
            if (hashList == null || hashList.isEmpty()) {
                return Collections.emptyList();
            }
            transactions = new ArrayList<Transaction>();
            NulsLogger logger = ContextManager.getContext(chainId).getLogger();
            try {
                HashMap<String, Serializable> params = new HashMap<String, Serializable>(2);
                params.put("chainId", Integer.valueOf(chainId));
                ArrayList t = new ArrayList();
                hashList.forEach(e -> t.add(e.toHex()));
                params.put("txHashList", t);
                params.put("allHits", Boolean.valueOf(allHits));
                Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_getBlockTxsExtend", params);
                if (response.isSuccess()) {
                    Map responseData = (Map)response.getResponseData();
                    Map map = (Map)responseData.get("tx_getBlockTxsExtend");
                    List txHexList = (List)map.get("txList");
                    if (txHexList == null || txHexList.isEmpty()) {
                        return Collections.emptyList();
                    }
                    for (String txHex : txHexList) {
                        Transaction transaction = new Transaction();
                        transaction.parse(new NulsByteBuffer(RPCUtil.decode((String)txHex)));
                        transactions.add(transaction);
                    }
                    break block6;
                }
                return Collections.emptyList();
            }
            catch (Exception e2) {
                logger.error("", e2);
                return Collections.emptyList();
            }
        }
        return transactions;
    }

    public static Transaction getConfirmedTransaction(int chainId, NulsHash hash) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("chainId", chainId);
            params.put("txHash", hash.toHex());
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_getConfirmedTx", params);
            if (response.isSuccess()) {
                Map responseData = (Map)response.getResponseData();
                Map map = (Map)responseData.get("tx_getConfirmedTx");
                String txHex = (String)map.get("tx");
                if (txHex == null) {
                    return null;
                }
                Transaction transaction = new Transaction();
                transaction.parse(new NulsByteBuffer(RPCUtil.decode((String)txHex)));
                return transaction;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("", e);
            return null;
        }
    }

    public static boolean saveGengsisTransaction(int chainId, BlockHeaderPo blockHeaderPo, List<Transaction> txs) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("chainId", chainId);
            ArrayList list = new ArrayList();
            txs.forEach(e -> {
                try {
                    list.add(RPCUtil.encode((byte[])e.serialize()));
                }
                catch (Exception e1) {
                    logger.error("", e1);
                }
            });
            params.put("txList", list);
            params.put("blockHeader", RPCUtil.encode((byte[])BlockUtil.fromBlockHeaderPo(blockHeaderPo).serialize()));
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_gengsisSave", params);
            if (response.isSuccess()) {
                Map responseData = (Map)response.getResponseData();
                Map data = (Map)responseData.get("tx_gengsisSave");
                return (Boolean)data.get("value");
            }
            return false;
        }
        catch (Exception e2) {
            logger.error("", e2);
            return false;
        }
    }

    public static boolean heightNotice(int chainId, long height) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            HashMap<String, Number> params = new HashMap<String, Number>(2);
            params.put("chainId", chainId);
            params.put("height", height);
            Response response = ResponseMessageProcessor.requestAndResponse((String)ModuleE.TX.abbr, (String)"tx_blockHeight", params);
            if (response.isSuccess()) {
                Map responseData = (Map)response.getResponseData();
                Map data = (Map)responseData.get("tx_blockHeight");
                return (Boolean)data.get("value");
            }
            return false;
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
    }
}

