/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.service.impl;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.Block;
import io.nuls.base.data.BlockExtendsData;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.Transaction;
import io.nuls.base.data.po.BlockHeaderPo;
import io.nuls.block.constant.BlockErrorCode;
import io.nuls.block.constant.BlockForwardEnum;
import io.nuls.block.manager.BlockChainManager;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.HashMessage;
import io.nuls.block.message.SmallBlockMessage;
import io.nuls.block.model.Chain;
import io.nuls.block.model.ChainContext;
import io.nuls.block.model.GenesisBlock;
import io.nuls.block.rpc.call.ConsensusCall;
import io.nuls.block.rpc.call.ContractCall;
import io.nuls.block.rpc.call.CrossChainCall;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.rpc.call.ProtocolCall;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.block.service.BlockService;
import io.nuls.block.storage.BlockStorageService;
import io.nuls.block.storage.ChainStorageService;
import io.nuls.block.utils.BlockUtil;
import io.nuls.block.utils.ChainGenerator;
import io.nuls.block.utils.LoggerUtil;
import io.nuls.block.utils.SmallBlockCacher;
import io.nuls.common.ConfigBean;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.annotation.Value;
import io.nuls.core.core.config.ConfigurationLoader;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.StampedLock;

@Component
public class BlockServiceImpl
implements BlockService {
    @Value(value="snapshotHeight")
    private Long snapshotHeight;
    @Autowired
    private ConfigurationLoader configurationLoader;
    @Autowired
    private BlockStorageService blockStorageService;
    @Autowired
    private ChainStorageService chainStorageService;

    @Override
    public Block getGenesisBlock(int chainId) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            long l = System.nanoTime();
            Block block = new Block();
            BlockHeaderPo blockHeaderPo = this.blockStorageService.query(chainId, 0L);
            if (blockHeaderPo == null) {
                return null;
            }
            block.setHeader(BlockUtil.fromBlockHeaderPo(blockHeaderPo));
            List<Transaction> transactions = TransactionCall.getConfirmedTransactions(chainId, blockHeaderPo.getTxHashList(), 60000L);
            if (transactions.isEmpty()) {
                return null;
            }
            block.setTxs(transactions);
            logger.debug("get block time-" + (System.nanoTime() - l) + ", height-0");
            return block;
        }
        catch (Exception e) {
            logger.error("error when getBlock by height", e);
            return null;
        }
    }

    @Override
    public Block getLatestBlock(int chainId) {
        return ContextManager.getContext(chainId).getLatestBlock();
    }

    @Override
    public BlockHeader getLatestBlockHeader(int chainId) {
        return ContextManager.getContext(chainId).getLatestBlock().getHeader();
    }

    @Override
    public BlockHeaderPo getLatestBlockHeaderPo(int chainId) {
        ChainContext context = ContextManager.getContext(chainId);
        return this.getBlockHeaderPo(chainId, context.getLatestHeight());
    }

    @Override
    public BlockHeader getBlockHeader(int chainId, long height) {
        return BlockUtil.fromBlockHeaderPo(this.getBlockHeaderPo(chainId, height));
    }

    @Override
    public BlockHeaderPo getBlockHeaderPo(int chainId, long height) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            return this.blockStorageService.query(chainId, height);
        }
        catch (Exception e) {
            logger.error("", e);
            return null;
        }
    }

    @Override
    public List<BlockHeader> getBlockHeader(int chainId, long startHeight, long endHeight) {
        if (startHeight < 0L || endHeight < 0L || startHeight > endHeight) {
            return Collections.emptyList();
        }
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            int size = (int)(endHeight - startHeight + 1L);
            ArrayList<BlockHeader> list = new ArrayList<BlockHeader>(size);
            for (long i = startHeight; i <= endHeight; ++i) {
                BlockHeaderPo blockHeaderPo = this.blockStorageService.query(chainId, i);
                if (blockHeaderPo.getHeight() == endHeight && !blockHeaderPo.isComplete()) continue;
                BlockHeader blockHeader = BlockUtil.fromBlockHeaderPo(blockHeaderPo);
                list.add(blockHeader);
            }
            return list;
        }
        catch (Exception e) {
            logger.error("", e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<BlockHeader> getBlockHeaderByRound(int chainId, long height, int round) {
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        try {
            int count = 0;
            BlockHeaderPo startHeaderPo = this.getBlockHeaderPo(chainId, height);
            byte[] extend = startHeaderPo.getExtend();
            BlockExtendsData data = new BlockExtendsData(extend);
            long roundIndex = data.getRoundIndex();
            ArrayList<BlockHeader> blockHeaders = new ArrayList<BlockHeader>();
            if (startHeaderPo.isComplete()) {
                blockHeaders.add(BlockUtil.fromBlockHeaderPo(startHeaderPo));
            }
            while (--height >= 0L) {
                BlockHeader blockHeader = this.getBlockHeader(chainId, height);
                BlockExtendsData newData = blockHeader.getExtendsData();
                long newRoundIndex = newData.getRoundIndex();
                if (newRoundIndex != roundIndex) {
                    ++count;
                    roundIndex = newRoundIndex;
                }
                if (count >= round) break;
                blockHeaders.add(blockHeader);
            }
            blockHeaders.sort(BlockHeader.BLOCK_HEADER_COMPARATOR);
            return blockHeaders;
        }
        catch (Exception e) {
            logger.error("", e);
            return Collections.emptyList();
        }
    }

    @Override
    public BlockHeader getBlockHeader(int chainId, NulsHash hash) {
        return BlockUtil.fromBlockHeaderPo(this.getBlockHeaderPo(chainId, hash));
    }

    @Override
    public BlockHeaderPo getBlockHeaderPo(int chainId, NulsHash hash) {
        return this.blockStorageService.query(chainId, hash);
    }

    @Override
    public Block getBlock(int chainId, NulsHash hash) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            Block block = new Block();
            BlockHeaderPo blockHeaderPo = this.blockStorageService.query(chainId, hash);
            if (blockHeaderPo == null) {
                logger.warn("hash-" + hash + " block not exists");
                return null;
            }
            block.setHeader(BlockUtil.fromBlockHeaderPo(blockHeaderPo));
            List<Transaction> transactions = TransactionCall.getConfirmedTransactions(chainId, blockHeaderPo.getTxHashList(), 10000L);
            block.setTxs(transactions);
            return block;
        }
        catch (Exception e) {
            logger.error("", e);
            return null;
        }
    }

    @Override
    public Block getBlock(int chainId, long height) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            long l = System.nanoTime();
            Block block = new Block();
            BlockHeaderPo blockHeaderPo = this.blockStorageService.query(chainId, height);
            if (blockHeaderPo == null) {
                return null;
            }
            block.setHeader(BlockUtil.fromBlockHeaderPo(blockHeaderPo));
            List<Transaction> transactions = TransactionCall.getConfirmedTransactions(chainId, blockHeaderPo.getTxHashList(), 10000L);
            if (transactions.isEmpty()) {
                return null;
            }
            block.setTxs(transactions);
            return block;
        }
        catch (Exception e) {
            logger.error("error when getBlock by height", e);
            return null;
        }
    }

    @Override
    public List<Block> getBlock(int chainId, long startHeight, long endHeight) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            ArrayList<Block> list = new ArrayList<Block>();
            for (long i = startHeight; i <= endHeight; ++i) {
                Block block = this.getBlock(chainId, i);
                if (block == null) {
                    return Collections.emptyList();
                }
                list.add(block);
            }
            return list;
        }
        catch (Exception e) {
            logger.error("", e);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean saveBlock(int chainId, Block block, boolean needLock) {
        return this.saveBlock(chainId, block, false, 0, needLock, false, false);
    }

    @Override
    public boolean saveBlock(int chainId, Block block, int download, boolean needLock, boolean broadcast, boolean forward) {
        return this.saveBlock(chainId, block, false, download, needLock, broadcast, forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveBlock(int chainId, Block block, boolean localInit, int download, boolean needLock, boolean broadcast, boolean forward) {
        long startTime = System.nanoTime();
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        BlockHeader header = block.getHeader();
        long height = header.getHeight();
        if (this.snapshotHeight != null && height > this.snapshotHeight) {
            logger.error("Reached snapshot height, abandoned saving block");
            return false;
        }
        NulsHash hash = header.getHash();
        StampedLock lock = context.getLock();
        long l = 0L;
        if (needLock) {
            l = lock.writeLock();
        }
        try {
            boolean setHeight;
            Result result = this.verifyBlock(chainId, block, localInit, download);
            if (result.isFailed()) {
                logger.error("verifyBlock fail! height-" + height);
                boolean bl = false;
                return bl;
            }
            if (download == 1) {
                SmallBlockCacher.setStatus(chainId, hash, BlockForwardEnum.COMPLETE);
                if (broadcast) {
                    this.broadcastBlock(chainId, block);
                }
                if (forward) {
                    this.forwardBlock(chainId, hash, null);
                }
            }
            if (!(setHeight = this.blockStorageService.setLatestHeight(chainId, height))) {
                if (!this.blockStorageService.setLatestHeight(chainId, height - 1L)) {
                    throw new NulsRuntimeException(BlockErrorCode.UPDATE_HEIGHT_ERROR);
                }
                logger.error("setHeight false, height-" + height);
                boolean bl = false;
                return bl;
            }
            BlockHeaderPo blockHeaderPo = BlockUtil.toBlockHeaderPo(block);
            boolean txSave = false;
            boolean headerSave = this.blockStorageService.save(chainId, blockHeaderPo);
            if (!headerSave || !(txSave = TransactionCall.save(chainId, blockHeaderPo, block.getTxs(), localInit, (List)result.getData()))) {
                if (headerSave && !TransactionCall.rollback(chainId, blockHeaderPo)) {
                    throw new NulsRuntimeException(BlockErrorCode.TX_ROLLBACK_ERROR);
                }
                if (!this.blockStorageService.remove(chainId, height)) {
                    throw new NulsRuntimeException(BlockErrorCode.HEADER_REMOVE_ERROR);
                }
                if (!this.blockStorageService.setLatestHeight(chainId, height - 1L)) {
                    throw new NulsRuntimeException(BlockErrorCode.UPDATE_HEIGHT_ERROR);
                }
                logger.error("headerSave-" + headerSave + ", txsSave-" + txSave + ", height-" + height + ", hash-" + hash);
                boolean bl = false;
                return bl;
            }
            boolean csNotice = ConsensusCall.saveNotice(chainId, header, localInit);
            if (!csNotice) {
                if (!TransactionCall.rollback(chainId, blockHeaderPo)) {
                    throw new NulsRuntimeException(BlockErrorCode.TX_ROLLBACK_ERROR);
                }
                if (!this.blockStorageService.remove(chainId, height)) {
                    throw new NulsRuntimeException(BlockErrorCode.HEADER_REMOVE_ERROR);
                }
                if (!this.blockStorageService.setLatestHeight(chainId, height - 1L)) {
                    throw new NulsRuntimeException(BlockErrorCode.UPDATE_HEIGHT_ERROR);
                }
                logger.error("consensus notice fail! height-" + height);
                boolean bl = false;
                return bl;
            }
            blockHeaderPo.setComplete(true);
            if (!ProtocolCall.saveNotice(chainId, header) || !this.blockStorageService.save(chainId, blockHeaderPo)) {
                if (!ConsensusCall.rollbackNotice(chainId, height)) {
                    throw new NulsRuntimeException(BlockErrorCode.CS_ROLLBACK_ERROR);
                }
                if (!TransactionCall.rollback(chainId, blockHeaderPo)) {
                    throw new NulsRuntimeException(BlockErrorCode.TX_ROLLBACK_ERROR);
                }
                if (!this.blockStorageService.remove(chainId, height)) {
                    throw new NulsRuntimeException(BlockErrorCode.HEADER_REMOVE_ERROR);
                }
                if (!this.blockStorageService.setLatestHeight(chainId, height - 1L)) {
                    throw new NulsRuntimeException(BlockErrorCode.UPDATE_HEIGHT_ERROR);
                }
                logger.error("ProtocolCall saveNotice fail! height-" + height);
                boolean bl = false;
                return bl;
            }
            try {
                TransactionCall.heightNotice(chainId, height);
                CrossChainCall.heightNotice(chainId, height, RPCUtil.encode((byte[])block.getHeader().serialize()), download);
            }
            catch (Exception e) {
                LoggerUtil.COMMON_LOG.error(e);
            }
            if (!localInit) {
                context.setLatestBlock(block);
                Chain masterChain = BlockChainManager.getMasterChain(chainId);
                masterChain.setEndHeight(masterChain.getEndHeight() + 1L);
                int heightRange = context.getParameters().getHeightRange();
                Deque<NulsHash> hashList = masterChain.getHashList();
                if (hashList.size() >= heightRange) {
                    hashList.removeFirst();
                }
                hashList.addLast(hash);
            }
            Response response = MessageUtil.newSuccessResponse((String)"");
            HashMap<String, Long> responseData = new HashMap<String, Long>(2);
            responseData.put("value", height);
            HashMap<String, HashMap<String, Long>> sss = new HashMap<String, HashMap<String, Long>>(2);
            sss.put("latestHeight", responseData);
            response.setResponseData(sss);
            ConnectManager.eventTrigger((String)"latestHeight", (Response)response);
            context.setNetworkHeight(height);
            long elapsedNanos = System.nanoTime() - startTime;
            logger.info("save block success, time-" + elapsedNanos / 1000000L + "ms, height-" + height + ", txCount-" + blockHeaderPo.getTxCount() + ", hash-" + hash + ", size-" + block.size());
            boolean bl = true;
            return bl;
        }
        finally {
            if (needLock) {
                lock.unlockWrite(l);
            }
        }
    }

    @Override
    public boolean rollbackBlock(int chainId, long height, boolean needLock) {
        BlockHeaderPo blockHeaderPo = this.getBlockHeaderPo(chainId, height);
        return this.rollbackBlock(chainId, blockHeaderPo, needLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rollbackBlock(int chainId, BlockHeaderPo blockHeaderPo, boolean needLock) {
        long startTime = System.nanoTime();
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        long height = blockHeaderPo.getHeight();
        if (height == 0L) {
            logger.warn("can't rollback GenesisBlock!");
            return true;
        }
        StampedLock lock = context.getLock();
        long l = 0L;
        if (needLock) {
            l = lock.writeLock();
        }
        try {
            BlockHeader blockHeader = BlockUtil.fromBlockHeaderPo(blockHeaderPo);
            blockHeaderPo.setComplete(false);
            if (!this.blockStorageService.save(chainId, blockHeaderPo) || !ProtocolCall.rollbackNotice(chainId, blockHeader)) {
                logger.error("ProtocolCall rollbackNotice fail! height-" + height);
                boolean bl = false;
                return bl;
            }
            if (!ConsensusCall.rollbackNotice(chainId, height)) {
                if (!ProtocolCall.saveNotice(chainId, blockHeader)) {
                    throw new NulsRuntimeException(BlockErrorCode.PU_SAVE_ERROR);
                }
                logger.error("ConsensusCall rollbackNotice fail! height-" + height);
                boolean bl = false;
                return bl;
            }
            List<NulsHash> csTxHashList = ContractCall.contractOfflineTxHashList(chainId, blockHeader.getHash().toHex());
            List txHashList = blockHeaderPo.getTxHashList();
            if (!csTxHashList.isEmpty()) {
                int n = txHashList.size() - 1;
                NulsHash hashLast = (NulsHash)txHashList.get(n);
                Transaction confirmedTransaction = TransactionCall.getConfirmedTransaction(chainId, hashLast);
                if (confirmedTransaction.getType() == 19) {
                    txHashList.remove(n);
                    txHashList.addAll(csTxHashList);
                    txHashList.add(hashLast);
                } else {
                    txHashList.addAll(csTxHashList);
                }
            }
            if (!TransactionCall.rollback(chainId, blockHeaderPo)) {
                if (!ConsensusCall.saveNotice(chainId, blockHeader, false)) {
                    throw new NulsRuntimeException(BlockErrorCode.CS_SAVE_ERROR);
                }
                if (!ProtocolCall.saveNotice(chainId, blockHeader)) {
                    throw new NulsRuntimeException(BlockErrorCode.PU_SAVE_ERROR);
                }
                logger.error("TransactionCall rollback fail! height-" + height);
                boolean bl = false;
                return bl;
            }
            if (!this.blockStorageService.remove(chainId, height)) {
                blockHeaderPo.setComplete(true);
                if (!this.blockStorageService.save(chainId, blockHeaderPo)) {
                    throw new NulsRuntimeException(BlockErrorCode.HEADER_SAVE_ERROR);
                }
                if (!TransactionCall.saveNormal(chainId, blockHeaderPo, TransactionCall.getTransactions(chainId, blockHeaderPo.getTxHashList(), true), null)) {
                    throw new NulsRuntimeException(BlockErrorCode.TX_SAVE_ERROR);
                }
                if (!ConsensusCall.saveNotice(chainId, blockHeader, false)) {
                    throw new NulsRuntimeException(BlockErrorCode.CS_SAVE_ERROR);
                }
                if (!ProtocolCall.saveNotice(chainId, blockHeader)) {
                    throw new NulsRuntimeException(BlockErrorCode.PU_SAVE_ERROR);
                }
                logger.error("blockStorageService remove fail! height-" + height);
                boolean bl = false;
                return bl;
            }
            if (!this.blockStorageService.setLatestHeight(chainId, height - 1L)) {
                if (!this.blockStorageService.setLatestHeight(chainId, height)) {
                    throw new NulsRuntimeException(BlockErrorCode.UPDATE_HEIGHT_ERROR);
                }
                blockHeaderPo.setComplete(true);
                if (!this.blockStorageService.save(chainId, blockHeaderPo)) {
                    throw new NulsRuntimeException(BlockErrorCode.HEADER_SAVE_ERROR);
                }
                if (!TransactionCall.saveNormal(chainId, blockHeaderPo, TransactionCall.getTransactions(chainId, blockHeaderPo.getTxHashList(), true), null)) {
                    throw new NulsRuntimeException(BlockErrorCode.TX_SAVE_ERROR);
                }
                if (!ConsensusCall.saveNotice(chainId, blockHeader, false)) {
                    throw new NulsRuntimeException(BlockErrorCode.CS_SAVE_ERROR);
                }
                if (!ProtocolCall.saveNotice(chainId, blockHeader)) {
                    throw new NulsRuntimeException(BlockErrorCode.PU_SAVE_ERROR);
                }
                logger.error("rollback setLatestHeight fail! height-" + height);
                boolean bl = false;
                return bl;
            }
            try {
                TransactionCall.heightNotice(chainId, height - 1L);
                CrossChainCall.heightNotice(chainId, height - 1L, RPCUtil.encode((byte[])blockHeader.serialize()), 0);
            }
            catch (Exception exception) {
                LoggerUtil.COMMON_LOG.error(exception);
            }
            context.setLatestBlock(this.getBlock(chainId, height - 1L));
            Chain chain = BlockChainManager.getMasterChain(chainId);
            chain.setEndHeight(height - 1L);
            Deque<NulsHash> hashList = chain.getHashList();
            hashList.removeLast();
            int heightRange = context.getParameters().getHeightRange();
            if (height - (long)heightRange >= 0L) {
                hashList.addFirst(this.getBlockHash(chainId, height - (long)heightRange));
            }
            long elapsedNanos = System.nanoTime() - startTime;
            logger.info("rollback block success, time-" + elapsedNanos / 1000000L + "ms, height-" + height + ", txCount-" + blockHeaderPo.getTxCount() + ", hash-" + blockHeaderPo.getHash());
            Response response = MessageUtil.newSuccessResponse((String)"");
            HashMap<String, Long> responseData = new HashMap<String, Long>(2);
            responseData.put("value", height - 1L);
            HashMap<String, HashMap<String, Long>> sss = new HashMap<String, HashMap<String, Long>>(2);
            sss.put("latestHeight", responseData);
            response.setResponseData(sss);
            ConnectManager.eventTrigger((String)"latestHeight", (Response)response);
            boolean bl = true;
            return bl;
        }
        catch (NulsException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (needLock) {
                lock.unlockWrite(l);
            }
        }
    }

    @Override
    public boolean forwardBlock(int chainId, NulsHash hash, String excludeNode) {
        HashMessage message = new HashMessage(hash);
        return NetworkCall.broadcast(chainId, message, excludeNode, "forward");
    }

    @Override
    public boolean broadcastBlock(int chainId, Block block) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        SmallBlockMessage message = new SmallBlockMessage();
        message.setSmallBlock(BlockUtil.getSmallBlock(chainId, block));
        boolean broadcast = NetworkCall.broadcast(chainId, message, "sBlock");
        logger.debug("hash-" + block.getHeader().getHash() + ", broadcast-" + broadcast);
        return broadcast;
    }

    private Result verifyBlock(int chainId, Block block, boolean localInit, int download) {
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        BlockHeader header = block.getHeader();
        if (header.getHeight() > 0L && !ProtocolCall.checkBlockVersion(chainId, header)) {
            logger.error("checkBlockVersion failed! height-" + header.getHeight());
            return Result.getFailed((ErrorCode)BlockErrorCode.BLOCK_VERIFY_ERROR);
        }
        boolean basicVerify = BlockUtil.basicVerify(chainId, block);
        if (localInit) {
            if (basicVerify) {
                return Result.getSuccess((ErrorCode)BlockErrorCode.SUCCESS);
            }
            logger.error("basicVerify-" + basicVerify);
            return Result.getFailed((ErrorCode)BlockErrorCode.BLOCK_VERIFY_ERROR);
        }
        boolean forkVerify = BlockUtil.forkVerify(chainId, block);
        if (!forkVerify) {
            logger.error("forkVerify-" + forkVerify);
            return Result.getFailed((ErrorCode)BlockErrorCode.BLOCK_VERIFY_ERROR);
        }
        Result consensusVerify = ConsensusCall.verify(chainId, block, download);
        if (consensusVerify.isFailed()) {
            logger.error("consensusVerify-" + consensusVerify);
            return Result.getFailed((ErrorCode)BlockErrorCode.BLOCK_VERIFY_ERROR);
        }
        return consensusVerify;
    }

    private boolean initLocalBlocks(int chainId) {
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        try {
            long latestHeight;
            BlockHeaderPo blockHeader;
            Block genesisBlock = this.getGenesisBlock(chainId);
            if (null == genesisBlock) {
                ConfigBean chainParameters = context.getParameters();
                String genesisBlockPath = chainParameters.getGenesisBlockPath();
                if (StringUtils.isBlank((String)genesisBlockPath)) {
                    genesisBlock = GenesisBlock.getInstance(chainId, chainParameters.getAssetId());
                } else {
                    ConfigurationLoader.ConfigItem item = this.configurationLoader.getConfigItem("genesisBlockPath");
                    String configFile = item.getConfigFile();
                    String value = item.getValue();
                    File file = new File(value);
                    if (file.isAbsolute()) {
                        genesisBlock = GenesisBlock.getInstance(chainId, chainParameters.getAssetId(), Files.readString(file.toPath()));
                    } else {
                        configFile = configFile.substring(0, configFile.lastIndexOf(File.separator));
                        genesisBlock = GenesisBlock.getInstance(chainId, chainParameters.getAssetId(), Files.readString(Path.of(configFile, value)));
                    }
                }
                boolean b = this.saveBlock(chainId, genesisBlock, true, 0, false, false, false);
                if (!b) {
                    throw new NulsRuntimeException(BlockErrorCode.SAVE_GENESIS_ERROR);
                }
            }
            if ((blockHeader = this.blockStorageService.query(chainId, latestHeight = this.blockStorageService.queryLatestHeight(chainId))) == null) {
                this.blockStorageService.setLatestHeight(chainId, --latestHeight);
            }
            Block block = this.getBlock(chainId, latestHeight);
            context.setLatestBlock(block);
            context.setGenesisBlock(genesisBlock);
            BlockChainManager.setMasterChain(chainId, ChainGenerator.generateMasterChain(chainId, block, this));
        }
        catch (Exception e) {
            logger.error("", e);
            return false;
        }
        return true;
    }

    @Override
    public void init(int chainId) {
        boolean initLocalBlocks = this.initLocalBlocks(chainId);
        if (!initLocalBlocks) {
            throw new NulsRuntimeException(BlockErrorCode.INIT_ERROR);
        }
    }

    @Override
    public NulsHash getBlockHash(int chainId, long height) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        try {
            byte[] key = SerializeUtils.uint64ToByteArray((long)height);
            byte[] value = RocksDBService.get((String)("block_header_index_" + chainId), (byte[])key);
            if (value == null) {
                return null;
            }
            return new NulsHash(value);
        }
        catch (Exception e) {
            logger.error("", e);
            return null;
        }
    }
}

