/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.storage.impl;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.po.BlockHeaderPo;
import io.nuls.block.storage.BlockStorageService;
import io.nuls.block.utils.LoggerUtil;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Component
public class BlockStorageServiceImpl
implements BlockStorageService {
    @Override
    public boolean save(int chainId, BlockHeaderPo blockHeader) {
        byte[] height = SerializeUtils.uint64ToByteArray((long)blockHeader.getHeight());
        try {
            byte[] hash = blockHeader.getHash().getBytes();
            boolean b1 = RocksDBService.put((String)("block_header_index_" + chainId), (byte[])height, (byte[])hash);
            boolean b2 = RocksDBService.put((String)("block_header_" + chainId), (byte[])hash, (byte[])blockHeader.serialize());
            return b1 && b2;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return false;
        }
    }

    @Override
    public BlockHeaderPo query(int chainId, long height) {
        try {
            byte[] key = SerializeUtils.uint64ToByteArray((long)height);
            byte[] hash = RocksDBService.get((String)("block_header_index_" + chainId), (byte[])key);
            if (hash == null) {
                return null;
            }
            byte[] bytes = RocksDBService.get((String)("block_header_" + chainId), (byte[])hash);
            if (bytes == null) {
                return null;
            }
            BlockHeaderPo blockHeader = new BlockHeaderPo();
            blockHeader.parse(new NulsByteBuffer(bytes));
            return blockHeader;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return null;
        }
    }

    @Override
    public BlockHeaderPo query(int chainId, NulsHash hash) {
        try {
            byte[] bytes = RocksDBService.get((String)("block_header_" + chainId), (byte[])hash.getBytes());
            if (bytes == null) {
                return null;
            }
            BlockHeaderPo blockHeader = new BlockHeaderPo();
            blockHeader.parse(new NulsByteBuffer(bytes));
            return blockHeader;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return null;
        }
    }

    @Override
    public List<BlockHeader> query(int chainId, long startHeight, long endHeight) {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (long i = startHeight; i <= endHeight; ++i) {
            keys.add(SerializeUtils.uint64ToByteArray((long)i));
        }
        List valueList = RocksDBService.multiGetValueList((String)("block_header_" + chainId), keys);
        if (valueList == null) {
            return Collections.emptyList();
        }
        ArrayList<BlockHeader> blockHeaders = new ArrayList<BlockHeader>();
        for (byte[] bytes : valueList) {
            BlockHeader header = new BlockHeader();
            try {
                header.parse(new NulsByteBuffer(bytes));
            }
            catch (NulsException e) {
                LoggerUtil.COMMON_LOG.error("ChainStorageServiceImpl-batch-query-fail", (Exception)((Object)e));
                return Collections.emptyList();
            }
            blockHeaders.add(header);
        }
        blockHeaders.sort(BlockHeader.BLOCK_HEADER_COMPARATOR);
        return blockHeaders;
    }

    @Override
    public boolean remove(int chainId, long height) {
        try {
            byte[] hash = RocksDBService.get((String)("block_header_index_" + chainId), (byte[])SerializeUtils.uint64ToByteArray((long)height));
            boolean b1 = RocksDBService.delete((String)("block_header_index_" + chainId), (byte[])SerializeUtils.uint64ToByteArray((long)height));
            boolean b2 = RocksDBService.delete((String)("block_header_" + chainId), (byte[])hash);
            return b1 && b2;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return false;
        }
    }

    @Override
    public boolean destroy(int chainId) {
        try {
            boolean b1 = RocksDBService.destroyTable((String)("block_header_" + chainId));
            boolean b2 = RocksDBService.destroyTable((String)("block_header_index_" + chainId));
            return b1 && b2;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return false;
        }
    }

    @Override
    public long queryLatestHeight(int chainId) {
        byte[] bytes = RocksDBService.get((String)"chain_latest_height", (byte[])ByteUtils.intToBytes((int)chainId));
        return SerializeUtils.readUint64((byte[])bytes, (int)0);
    }

    @Override
    public boolean setLatestHeight(int chainId, long height) {
        try {
            byte[] bytes = SerializeUtils.uint64ToByteArray((long)height);
            return RocksDBService.put((String)"chain_latest_height", (byte[])ByteUtils.intToBytes((int)chainId), (byte[])bytes);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return false;
        }
    }
}

