/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.storage.impl;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Block;
import io.nuls.base.data.NulsHash;
import io.nuls.block.constant.BlockErrorCode;
import io.nuls.block.constant.Constant;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.storage.ChainStorageService;
import io.nuls.block.utils.LoggerUtil;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Component
public class ChainStorageServiceImpl
implements ChainStorageService {
    @Override
    public boolean save(int chainId, List<Block> blocks) {
        HashMap<byte[], byte[]> map = new HashMap<byte[], byte[]>(blocks.size());
        Map<String, AtomicInteger> duplicateBlockMap = ContextManager.getContext(chainId).getDuplicateBlockMap();
        try {
            for (Block block : blocks) {
                NulsHash hash = block.getHeader().getHash();
                String digestHex = hash.toHex();
                if (duplicateBlockMap.containsKey(digestHex)) {
                    duplicateBlockMap.get(digestHex).incrementAndGet();
                    continue;
                }
                byte[] key = hash.getBytes();
                byte[] bytes = RocksDBService.get((String)("cached_block_" + chainId), (byte[])key);
                if (bytes != null) {
                    duplicateBlockMap.put(digestHex, new AtomicInteger(1));
                    continue;
                }
                map.put(key, block.serialize());
            }
            if (map.size() == 0) {
                return true;
            }
            boolean b = RocksDBService.batchPut((String)("cached_block_" + chainId), map);
            LoggerUtil.COMMON_LOG.debug("ChainStorageServiceImpl-save-blocks-" + blocks.size() + "-" + b);
            return b;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return false;
        }
    }

    @Override
    public boolean save(int chainId, Block block) {
        NulsHash hash = block.getHeader().getHash();
        String digestHex = hash.toHex();
        Map<String, AtomicInteger> duplicateBlockMap = ContextManager.getContext(chainId).getDuplicateBlockMap();
        if (duplicateBlockMap.containsKey(digestHex)) {
            duplicateBlockMap.get(digestHex).incrementAndGet();
            return true;
        }
        try {
            byte[] key = hash.getBytes();
            byte[] bytes = RocksDBService.get((String)("cached_block_" + chainId), (byte[])key);
            if (bytes != null) {
                duplicateBlockMap.put(digestHex, new AtomicInteger(1));
                return true;
            }
            boolean b = RocksDBService.put((String)("cached_block_" + chainId), (byte[])key, (byte[])block.serialize());
            LoggerUtil.COMMON_LOG.debug("ChainStorageServiceImpl-save-block-" + hash + "-" + b);
            return b;
        }
        catch (Exception e) {
            throw new NulsRuntimeException(BlockErrorCode.DB_SAVE_ERROR);
        }
    }

    @Override
    public Block query(int chainId, NulsHash hash) {
        try {
            byte[] bytes = RocksDBService.get((String)("cached_block_" + chainId), (byte[])hash.getBytes());
            if (bytes == null) {
                LoggerUtil.COMMON_LOG.debug("ChainStorageServiceImpl-query-fail-hash-" + hash);
                return null;
            }
            Block block = new Block();
            block.parse(new NulsByteBuffer(bytes));
            LoggerUtil.COMMON_LOG.debug("ChainStorageServiceImpl-query-success-hash-" + hash);
            return block;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return null;
        }
    }

    @Override
    public List<Block> query(int chainId, Deque<NulsHash> hashList) {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (NulsHash hash : hashList) {
            keys.add(hash.getBytes());
        }
        List valueList = RocksDBService.multiGetValueList((String)("cached_block_" + chainId), keys);
        if (valueList == null) {
            return Collections.emptyList();
        }
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (byte[] bytes : valueList) {
            Block block = new Block();
            try {
                block.parse(new NulsByteBuffer(bytes));
            }
            catch (NulsException e) {
                LoggerUtil.COMMON_LOG.error("ChainStorageServiceImpl-batchquery-fail", (Exception)((Object)e));
                return Collections.emptyList();
            }
            blockList.add(block);
        }
        blockList.sort(Constant.BLOCK_COMPARATOR);
        return blockList;
    }

    @Override
    public boolean remove(int chainId, Deque<NulsHash> hashList) {
        Map<String, AtomicInteger> duplicateBlockMap = ContextManager.getContext(chainId).getDuplicateBlockMap();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        try {
            for (NulsHash hash : hashList) {
                String digestHex = hash.toHex();
                if (duplicateBlockMap.containsKey(digestHex)) {
                    int i = duplicateBlockMap.get(digestHex).decrementAndGet();
                    if (i != 0) continue;
                    duplicateBlockMap.remove(digestHex);
                    continue;
                }
                keys.add(hash.getBytes());
            }
            if (keys.isEmpty()) {
                return true;
            }
            boolean b = RocksDBService.deleteKeys((String)("cached_block_" + chainId), keys);
            LoggerUtil.COMMON_LOG.debug("ChainStorageServiceImpl-remove-hashList-" + hashList + "-" + b);
            return b;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            throw new NulsRuntimeException(BlockErrorCode.DB_DELETE_ERROR);
        }
    }

    @Override
    public boolean remove(int chainId, NulsHash hash) {
        String digestHex;
        Map<String, AtomicInteger> duplicateBlockMap = ContextManager.getContext(chainId).getDuplicateBlockMap();
        if (duplicateBlockMap.containsKey(digestHex = hash.toHex())) {
            int i = duplicateBlockMap.get(digestHex).decrementAndGet();
            if (i == 0) {
                duplicateBlockMap.remove(digestHex);
            }
            return true;
        }
        try {
            boolean b = RocksDBService.delete((String)("cached_block_" + chainId), (byte[])hash.getBytes());
            LoggerUtil.COMMON_LOG.debug("ChainStorageServiceImpl-remove-hash-" + hash + "-" + b);
            return b;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            throw new NulsRuntimeException(BlockErrorCode.DB_DELETE_ERROR);
        }
    }

    @Override
    public boolean destroy(int chainId) {
        try {
            return RocksDBService.destroyTable((String)("cached_block_" + chainId));
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            throw new NulsRuntimeException(BlockErrorCode.DB_DELETE_ERROR);
        }
    }
}

