/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.storage.impl;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.block.model.RollbackInfoPo;
import io.nuls.block.storage.RollbackStorageService;
import io.nuls.block.utils.LoggerUtil;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.rockdb.service.RocksDBService;

@Component
public class RollbackServiceImpl
implements RollbackStorageService {
    @Override
    public boolean save(RollbackInfoPo po, int chainId) {
        try {
            byte[] bytes = po.serialize();
            return RocksDBService.put((String)"rollback_height", (byte[])ByteUtils.intToBytes((int)chainId), (byte[])bytes);
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return false;
        }
    }

    @Override
    public RollbackInfoPo get(int chainId) {
        try {
            RollbackInfoPo po = new RollbackInfoPo();
            byte[] bytes = RocksDBService.get((String)"rollback_height", (byte[])ByteUtils.intToBytes((int)chainId));
            if (bytes == null) {
                return null;
            }
            po.parse(new NulsByteBuffer(bytes));
            return po;
        }
        catch (Exception e) {
            LoggerUtil.COMMON_LOG.error("", e);
            return null;
        }
    }
}

