/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread.monitor;

import io.nuls.base.data.Block;
import io.nuls.base.data.NulsHash;
import io.nuls.block.constant.StatusEnum;
import io.nuls.block.manager.BlockChainManager;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.Chain;
import io.nuls.block.model.ChainContext;
import io.nuls.block.model.Node;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.storage.ChainStorageService;
import io.nuls.block.thread.monitor.BaseMonitor;
import io.nuls.block.utils.BlockUtil;
import io.nuls.common.ConfigBean;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.logback.NulsLogger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;

public class OrphanChainsMaintainer
extends BaseMonitor {
    private ChainStorageService chainStorageService = (ChainStorageService)SpringLiteContext.getBean(ChainStorageService.class);
    private static final OrphanChainsMaintainer INSTANCE = new OrphanChainsMaintainer();

    private OrphanChainsMaintainer() {
    }

    public static OrphanChainsMaintainer getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(int chainId, ChainContext context, NulsLogger commonLog) {
        block10: {
            ConfigBean parameters = context.getParameters();
            byte orphanChainMaxAge = parameters.getOrphanChainMaxAge();
            StampedLock lock = context.getLock();
            long stamp = lock.tryOptimisticRead();
            try {
                while (true) {
                    if (stamp != 0L) {
                        SortedSet<Chain> orphanChains = BlockChainManager.getOrphanChains(chainId);
                        if (lock.validate(stamp)) {
                            if (orphanChains.isEmpty()) {
                                break;
                            }
                            if ((stamp = lock.tryConvertToWriteLock(stamp)) != 0L) {
                                List<Node> availableNodes = NetworkCall.getAvailableNodes(chainId);
                                context.setStatus(StatusEnum.UPDATE_ORPHAN_CHAINS);
                                long l = System.nanoTime();
                                for (Chain orphanChain : orphanChains) {
                                    this.maintainOrphanChain(chainId, orphanChain, availableNodes, orphanChainMaxAge);
                                    if (System.nanoTime() - l <= 10000000000L) continue;
                                    break block10;
                                }
                                break;
                            }
                        }
                    }
                    stamp = lock.writeLock();
                }
            }
            finally {
                context.setStatus(StatusEnum.RUNNING);
                if (StampedLock.isWriteLockStamp(stamp)) {
                    lock.unlockWrite(stamp);
                }
            }
        }
    }

    private void maintainOrphanChain(int chainId, Chain orphanChain, List<Node> availableNodes, int orphanChainMaxAge) {
        ChainContext context = ContextManager.getContext(chainId);
        Map<NulsHash, List<String>> orphanBlockRelatedNodes = context.getOrphanBlockRelatedNodes();
        if (orphanChain.getParent() != null || orphanChain.getStartHeight() <= 1L) {
            return;
        }
        AtomicInteger age = orphanChain.getAge();
        if (age.get() > orphanChainMaxAge) {
            return;
        }
        NulsHash previousHash = orphanChain.getPreviousHash();
        Chain masterChain = BlockChainManager.getMasterChain(chainId);
        if (masterChain.getHashList().contains(previousHash)) {
            return;
        }
        HashSet<String> nodes = new HashSet<String>();
        for (NulsHash nulsHash : orphanChain.getHashList()) {
            List<String> list = orphanBlockRelatedNodes.get(nulsHash);
            if (list == null) continue;
            nodes.addAll(list);
        }
        Set set = availableNodes.stream().map(Node::getId).collect(Collectors.toSet());
        nodes.retainAll(set);
        long l = System.nanoTime();
        for (String availableNode : nodes) {
            Block block = BlockUtil.downloadBlockByHash(chainId, previousHash, availableNode, orphanChain.getStartHeight() - 1L);
            if (block != null) {
                orphanChain.addFirst(block);
                this.chainStorageService.save(chainId, block);
                return;
            }
            for (NulsHash nulsHash : orphanChain.getHashList()) {
                List<String> list = orphanBlockRelatedNodes.get(nulsHash);
                list.remove(availableNode);
                context.getLogger().warn("get block timeout, kick out this node-" + availableNode);
            }
            age.incrementAndGet();
            if (age.get() > orphanChainMaxAge) {
                return;
            }
            if (System.nanoTime() - l <= 10000000000L) continue;
            break;
        }
    }
}

