/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.thread.monitor;

import io.nuls.base.data.NulsHash;
import io.nuls.block.constant.ChainTypeEnum;
import io.nuls.block.constant.StatusEnum;
import io.nuls.block.manager.BlockChainManager;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.model.Chain;
import io.nuls.block.model.ChainContext;
import io.nuls.block.rpc.call.ConsensusCall;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.block.thread.monitor.BaseMonitor;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.logback.NulsLogger;
import java.util.Deque;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.StampedLock;

public class OrphanChainsMonitor
extends BaseMonitor {
    private static final OrphanChainsMonitor INSTANCE = new OrphanChainsMonitor();

    public static OrphanChainsMonitor getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(int chainId, ChainContext context, NulsLogger commonLog) {
        StampedLock lock = context.getLock();
        long stamp = lock.tryOptimisticRead();
        try {
            while (true) {
                if (stamp != 0L) {
                    SortedSet<Chain> orphanChains = BlockChainManager.getOrphanChains(chainId);
                    if (lock.validate(stamp)) {
                        if (orphanChains.isEmpty()) {
                            break;
                        }
                        if ((stamp = lock.tryConvertToWriteLock(stamp)) != 0L) {
                            context.printChains();
                            context.setStatus(StatusEnum.MAINTAIN_ORPHAN_CHAINS);
                            Chain masterChain = BlockChainManager.getMasterChain(chainId);
                            SortedSet<Chain> forkChains = BlockChainManager.getForkChains(chainId);
                            for (Chain orphanChain : orphanChains) {
                                commonLog.debug("OrphanChainsMonitor-mark-begin");
                                this.mark(orphanChain, masterChain, forkChains, orphanChains);
                                commonLog.debug("OrphanChainsMonitor-mark-end");
                            }
                            for (Chain orphanChain : orphanChains) {
                                commonLog.debug(orphanChain.toString());
                            }
                            TreeSet<Chain> maintainedOrphanChains = new TreeSet<Chain>(Chain.COMPARATOR);
                            for (Chain orphanChain : orphanChains) {
                                commonLog.debug("OrphanChainsMonitor-copy-begin");
                                this.copy(chainId, maintainedOrphanChains, orphanChain);
                                commonLog.debug("OrphanChainsMonitor-copy-end");
                            }
                            BlockChainManager.setOrphanChains(chainId, maintainedOrphanChains);
                            forkChains.forEach(e -> e.setType(ChainTypeEnum.FORK));
                            maintainedOrphanChains.forEach(e -> e.setType(ChainTypeEnum.ORPHAN));
                            context.printChains();
                            break;
                        }
                    }
                }
                stamp = lock.writeLock();
            }
        }
        finally {
            context.setStatus(StatusEnum.RUNNING);
            if (StampedLock.isWriteLockStamp(stamp)) {
                lock.unlockWrite(stamp);
            }
        }
    }

    private void mark(Chain orphanChain, Chain masterChain, SortedSet<Chain> forkChains, SortedSet<Chain> orphanChains) {
        try {
            if (orphanChain.getParent() == null && this.tryAppend(masterChain, orphanChain)) {
                orphanChain.setType(ChainTypeEnum.MASTER_APPEND);
                return;
            }
            if (orphanChain.getParent() == null && this.tryDuplicate(masterChain, orphanChain)) {
                orphanChain.setType(ChainTypeEnum.MASTER_DUPLICATE);
                return;
            }
            if (orphanChain.getParent() == null && this.tryFork(masterChain, orphanChain)) {
                orphanChain.setType(ChainTypeEnum.MASTER_FORK);
                return;
            }
            for (Chain forkChain : forkChains) {
                if (orphanChain.getParent() == null && this.tryAppend(forkChain, orphanChain)) {
                    orphanChain.setType(ChainTypeEnum.FORK_APPEND);
                    return;
                }
                if (orphanChain.getParent() == null && this.tryDuplicate(forkChain, orphanChain)) {
                    orphanChain.setType(ChainTypeEnum.FORK_DUPLICATE);
                    return;
                }
                if (orphanChain.getParent() != null || !this.tryFork(forkChain, orphanChain)) continue;
                orphanChain.setType(ChainTypeEnum.FORK_FORK);
                return;
            }
            for (Chain anotherOrphanChain : orphanChains) {
                if (anotherOrphanChain.equals(orphanChain)) continue;
                if (anotherOrphanChain.getParent() == null && this.tryAppend(orphanChain, anotherOrphanChain)) {
                    anotherOrphanChain.setType(ChainTypeEnum.ORPHAN_APPEND);
                    return;
                }
                if (orphanChain.getParent() == null && this.tryAppend(anotherOrphanChain, orphanChain)) {
                    orphanChain.setType(ChainTypeEnum.ORPHAN_APPEND);
                    return;
                }
                if (anotherOrphanChain.getParent() == null && this.tryDuplicate(orphanChain, anotherOrphanChain)) {
                    anotherOrphanChain.setType(ChainTypeEnum.ORPHAN_DUPLICATE);
                    return;
                }
                if (orphanChain.getParent() == null && this.tryDuplicate(anotherOrphanChain, orphanChain)) {
                    orphanChain.setType(ChainTypeEnum.ORPHAN_DUPLICATE);
                    return;
                }
                if (anotherOrphanChain.getParent() == null && this.tryFork(orphanChain, anotherOrphanChain)) {
                    anotherOrphanChain.setType(ChainTypeEnum.ORPHAN_FORK);
                    return;
                }
                if (orphanChain.getParent() != null || !this.tryFork(anotherOrphanChain, orphanChain)) continue;
                orphanChain.setType(ChainTypeEnum.ORPHAN_FORK);
                return;
            }
        }
        catch (NulsRuntimeException e) {
            ContextManager.getContext(masterChain.getChainId()).getLogger().error("orphanChain data error-" + orphanChain);
            orphanChain.setType(ChainTypeEnum.DATA_ERROR);
            ConsensusCall.notice(masterChain.getChainId(), 1);
            TransactionCall.notice(masterChain.getChainId(), 1);
        }
    }

    private void copy(Integer chainId, SortedSet<Chain> maintainedOrphanChains, Chain orphanChain) {
        if (orphanChain.getType().equals((Object)ChainTypeEnum.DATA_ERROR)) {
            orphanChain.getSons().forEach(e -> {
                e.setType(ChainTypeEnum.ORPHAN);
                e.setParent(null);
            });
            return;
        }
        if (orphanChain.getType().equals((Object)ChainTypeEnum.MASTER_DUPLICATE)) {
            orphanChain.getSons().forEach(e -> e.setType(ChainTypeEnum.MASTER_FORK));
            return;
        }
        if (orphanChain.getType().equals((Object)ChainTypeEnum.FORK_DUPLICATE)) {
            orphanChain.getSons().forEach(e -> e.setType(ChainTypeEnum.FORK_FORK));
            return;
        }
        if (orphanChain.getType().equals((Object)ChainTypeEnum.ORPHAN_DUPLICATE)) {
            orphanChain.getSons().forEach(e -> e.setType(ChainTypeEnum.ORPHAN_FORK));
            return;
        }
        if (orphanChain.getType().equals((Object)ChainTypeEnum.MASTER_APPEND)) {
            orphanChain.getSons().forEach(e -> e.setType(ChainTypeEnum.MASTER_FORK));
            return;
        }
        if (orphanChain.getType().equals((Object)ChainTypeEnum.MASTER_FORK)) {
            BlockChainManager.addForkChain(chainId, orphanChain);
            orphanChain.getSons().forEach(e -> e.setType(ChainTypeEnum.FORK_FORK));
            return;
        }
        if (orphanChain.getType().equals((Object)ChainTypeEnum.FORK_APPEND)) {
            orphanChain.getSons().forEach(e -> e.setType(ChainTypeEnum.FORK_FORK));
            return;
        }
        if (orphanChain.getType().equals((Object)ChainTypeEnum.FORK_FORK)) {
            BlockChainManager.addForkChain(chainId, orphanChain);
            orphanChain.getSons().forEach(e -> e.setType(ChainTypeEnum.FORK_FORK));
            return;
        }
        if (orphanChain.getType().equals((Object)ChainTypeEnum.ORPHAN_APPEND)) {
            return;
        }
        if (orphanChain.getType().equals((Object)ChainTypeEnum.ORPHAN_FORK)) {
            maintainedOrphanChains.add(orphanChain);
            return;
        }
        if (orphanChain.getType().equals((Object)ChainTypeEnum.ORPHAN)) {
            maintainedOrphanChains.add(orphanChain);
        }
    }

    private boolean tryAppend(Chain mainChain, Chain subChain) {
        if (mainChain.getEndHeight() + 1L == subChain.getStartHeight() && mainChain.getEndHash().equals((Object)subChain.getPreviousHash())) {
            return BlockChainManager.append(mainChain, subChain);
        }
        return false;
    }

    private boolean tryFork(Chain mainChain, Chain subChain) {
        if (mainChain.getHashList().contains(subChain.getPreviousHash())) {
            return BlockChainManager.fork(mainChain, subChain);
        }
        return false;
    }

    private boolean tryDuplicate(Chain mainChain, Chain subChain) {
        Deque<NulsHash> mainChainHashList = mainChain.getHashList();
        return mainChainHashList.contains(subChain.getEndHash()) && mainChainHashList.contains(subChain.getStartHash());
    }
}

