/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.block.utils;

import io.nuls.base.data.Block;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.SmallBlock;
import io.nuls.base.data.Transaction;
import io.nuls.base.data.po.BlockHeaderPo;
import io.nuls.block.constant.BlockErrorCode;
import io.nuls.block.constant.ChainTypeEnum;
import io.nuls.block.manager.BlockChainManager;
import io.nuls.block.manager.ContextManager;
import io.nuls.block.message.HashMessage;
import io.nuls.block.message.HeightMessage;
import io.nuls.block.model.Chain;
import io.nuls.block.model.ChainContext;
import io.nuls.block.rpc.call.ConsensusCall;
import io.nuls.block.rpc.call.NetworkCall;
import io.nuls.block.rpc.call.TransactionCall;
import io.nuls.block.service.BlockService;
import io.nuls.block.storage.ChainStorageService;
import io.nuls.block.utils.ChainGenerator;
import io.nuls.block.utils.SingleBlockCacher;
import io.nuls.common.ConfigBean;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.ByteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@Component
public class BlockUtil {
    @Autowired
    private static BlockService blockService;
    @Autowired
    private static ChainStorageService chainStorageService;

    public static boolean basicVerify(int chainId, Block block) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        if (block == null) {
            logger.error("basicVerify fail, block is null!");
            return false;
        }
        BlockHeader header = block.getHeader();
        if (header == null) {
            logger.error("basicVerify fail, blockHeader is null!");
            return false;
        }
        if (!BlockUtil.headerVerify(chainId, header)) {
            logger.error("basicVerify fail, blockHeader error! height-" + header.getHeight() + ", hash-" + header.getHash());
            return false;
        }
        if (block.getTxs() == null || block.getTxs().isEmpty()) {
            logger.error("basicVerify fail, transaction is null! height-" + header.getHeight() + ", hash-" + header.getHash());
            return false;
        }
        if (block.getTxs().size() != header.getTxCount()) {
            logger.error("basicVerify fail, transaction count not equals! height-" + header.getHeight() + ", hash-" + header.getHash());
            return false;
        }
        ConfigBean parameters = ContextManager.getContext(chainId).getParameters();
        if ((long)block.size() > parameters.getBlockMaxSize()) {
            logger.error("basicVerify fail, beyond blockMaxSize! height-" + header.getHeight() + ", hash-" + header.getHash());
            return false;
        }
        return true;
    }

    public static boolean headerVerify(int chainId, BlockHeader header) {
        NulsLogger logger = ContextManager.getContext(chainId).getLogger();
        if (header.getHash() == null) {
            logger.error("headerVerify fail, block hash can not be null! height-" + header.getHeight() + ", hash-" + header.getHash());
            return false;
        }
        if (header.getHeight() < 0L) {
            logger.error("headerVerify fail, block height can not be less than 0! height-" + header.getHeight() + ", hash-" + header.getHash());
            return false;
        }
        if (null == header.getPackingAddress(chainId)) {
            logger.error("headerVerify fail, block packingAddress can not be null! height-" + header.getHeight() + ", hash-" + header.getHash());
            return false;
        }
        ConfigBean parameters = ContextManager.getContext(chainId).getParameters();
        if (header.getExtend() != null && header.getExtend().length > parameters.getExtendMaxSize()) {
            logger.error("headerVerify fail, block extend too long! height-" + header.getHeight() + ", hash-" + header.getHash());
            return false;
        }
        return true;
    }

    public static boolean forkVerify(int chainId, Block block) {
        ErrorCode forkCode;
        ErrorCode mainCode = BlockUtil.mainChainProcess(chainId, block).getErrorCode();
        if (mainCode.equals((Object)BlockErrorCode.SUCCESS)) {
            return true;
        }
        if (mainCode.equals((Object)BlockErrorCode.IRRELEVANT_BLOCK) && (forkCode = BlockUtil.forkChainProcess(chainId, block).getErrorCode()).equals((Object)BlockErrorCode.IRRELEVANT_BLOCK)) {
            BlockUtil.orphanChainProcess(chainId, block);
        }
        return false;
    }

    private static Result mainChainProcess(int chainId, Block block) {
        BlockHeader header = block.getHeader();
        long blockHeight = header.getHeight();
        NulsHash blockHash = header.getHash();
        NulsHash blockPreviousHash = header.getPreHash();
        Chain masterChain = BlockChainManager.getMasterChain(chainId);
        long masterChainEndHeight = masterChain.getEndHeight();
        NulsHash masterChainEndHash = masterChain.getEndHash();
        ChainContext context = ContextManager.getContext(chainId);
        ConfigBean parameters = context.getParameters();
        NulsLogger logger = context.getLogger();
        if (Math.abs(blockHeight - masterChainEndHeight) > (long)parameters.getHeightRange()) {
            logger.error("received out of range block, height:" + blockHeight + ", hash:" + blockHash);
            return Result.getFailed((ErrorCode)BlockErrorCode.OUT_OF_RANGE);
        }
        if (blockHeight == masterChainEndHeight + 1L && blockPreviousHash.equals((Object)masterChainEndHash)) {
            return Result.getSuccess((ErrorCode)BlockErrorCode.SUCCESS);
        }
        if (blockHeight <= masterChainEndHeight) {
            BlockHeaderPo masterHeader = blockService.getBlockHeaderPo(chainId, blockHeight);
            if (blockHash.equals((Object)masterHeader.getHash())) {
                return Result.getFailed((ErrorCode)BlockErrorCode.DUPLICATE_MAIN_BLOCK);
            }
            if (blockPreviousHash.equals((Object)masterHeader.getPreHash())) {
                if (BlockUtil.handleSpecificForkBlock(chainId, blockService, header, masterChainEndHeight, masterChainEndHash, masterHeader)) {
                    return Result.getSuccess((ErrorCode)BlockErrorCode.SUCCESS);
                }
                chainStorageService.save(chainId, block);
                Chain forkChain = ChainGenerator.generate(chainId, block, masterChain, ChainTypeEnum.FORK);
                BlockChainManager.addForkChain(chainId, forkChain);
                logger.error("received fork block of masterChain, height:" + blockHeight + ", hash:" + blockHash);
                ConsensusCall.evidence(chainId, blockService, header);
                return Result.getFailed((ErrorCode)BlockErrorCode.FORK_BLOCK);
            }
        }
        return Result.getFailed((ErrorCode)BlockErrorCode.IRRELEVANT_BLOCK);
    }

    private static boolean handleSpecificForkBlock(int chainId, BlockService blockService, BlockHeader header, long masterChainEndHeight, NulsHash masterChainEndHash, BlockHeaderPo masterHeader) {
        if (header.getHeight() == masterChainEndHeight && Arrays.equals(masterHeader.getPackingAddress(chainId), header.getPackingAddress(chainId))) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(masterChainEndHash.toHex());
            list.add(header.getHash().toHex());
            list.sort(String.CASE_INSENSITIVE_ORDER);
            if (((String)list.get(0)).equals(header.getHash().toHex())) {
                return blockService.rollbackBlock(chainId, masterHeader, false);
            }
        }
        return false;
    }

    private static Result forkChainProcess(int chainId, Block block) {
        BlockHeader header = block.getHeader();
        long blockHeight = header.getHeight();
        NulsHash blockHash = header.getHash();
        NulsHash blockPreviousHash = header.getPreHash();
        SortedSet<Chain> forkChains = BlockChainManager.getForkChains(chainId);
        ChainContext context = ContextManager.getContext(chainId);
        NulsLogger logger = context.getLogger();
        try {
            for (Chain forkChain : forkChains) {
                long forkChainStartHeight = forkChain.getStartHeight();
                long forkChainEndHeight = forkChain.getEndHeight();
                NulsHash forkChainEndHash = forkChain.getEndHash();
                if (blockHeight == forkChainEndHeight + 1L && blockPreviousHash.equals((Object)forkChainEndHash)) {
                    chainStorageService.save(chainId, block);
                    forkChain.addLast(block);
                    logger.error("received continuous block of forkChain, height:" + blockHeight + ", hash:" + blockHash);
                    ConsensusCall.evidence(chainId, blockService, header);
                    return Result.getFailed((ErrorCode)BlockErrorCode.FORK_BLOCK);
                }
                if (forkChainStartHeight <= blockHeight && blockHeight <= forkChainEndHeight && forkChain.getHashList().contains(blockHash)) {
                    logger.error("received duplicate block of forkChain, height:" + blockHeight + ", hash:" + blockHash);
                    return Result.getFailed((ErrorCode)BlockErrorCode.FORK_BLOCK);
                }
                if (forkChainStartHeight > blockHeight || blockHeight > forkChainEndHeight || !forkChain.getHashList().contains(blockPreviousHash)) continue;
                chainStorageService.save(chainId, block);
                Chain newForkChain = ChainGenerator.generate(chainId, block, forkChain, ChainTypeEnum.FORK);
                BlockChainManager.addForkChain(chainId, newForkChain);
                logger.error("received fork block of forkChain, height:" + blockHeight + ", hash:" + blockHash);
                ConsensusCall.evidence(chainId, blockService, header);
                return Result.getFailed((ErrorCode)BlockErrorCode.FORK_BLOCK);
            }
        }
        catch (Exception e) {
            logger.error("", e);
        }
        return Result.getFailed((ErrorCode)BlockErrorCode.IRRELEVANT_BLOCK);
    }

    private static void orphanChainProcess(int chainId, Block block) {
        ChainContext context = ContextManager.getContext(chainId);
        NulsHash blockHash = block.getHeader().getHash();
        NulsLogger logger = context.getLogger();
        if (block.getNodeId() != null) {
            Map<NulsHash, List<String>> map = context.getOrphanBlockRelatedNodes();
            List list = map.computeIfAbsent(blockHash, k -> new ArrayList());
            list.add(block.getNodeId());
            logger.debug("add OrphanBlockRelatedNodes, blockHash-{}, nodeId-{}", new Object[]{blockHash, block.getNodeId()});
        }
        long blockHeight = block.getHeader().getHeight();
        NulsHash blockPreviousHash = block.getHeader().getPreHash();
        SortedSet<Chain> orphanChains = BlockChainManager.getOrphanChains(chainId);
        try {
            for (Chain orphanChain : orphanChains) {
                long orphanChainStartHeight = orphanChain.getStartHeight();
                long orphanChainEndHeight = orphanChain.getEndHeight();
                NulsHash orphanChainEndHash = orphanChain.getEndHash();
                NulsHash orphanChainPreviousHash = orphanChain.getPreviousHash();
                if (blockHeight == orphanChainEndHeight + 1L && blockPreviousHash.equals((Object)orphanChainEndHash)) {
                    chainStorageService.save(chainId, block);
                    orphanChain.addLast(block);
                    logger.debug("received continuous tail block of orphanChain, height:" + blockHeight + ", hash:" + blockHash);
                    return;
                }
                if (blockHeight == orphanChainStartHeight - 1L && blockHash.equals((Object)orphanChainPreviousHash)) {
                    chainStorageService.save(chainId, block);
                    orphanChain.addFirst(block);
                    logger.info("received continuous head block of orphanChain, height:" + blockHeight + ", hash:" + blockHash);
                    return;
                }
                if (orphanChainStartHeight <= blockHeight && blockHeight <= orphanChainEndHeight && orphanChain.getHashList().contains(blockHash)) {
                    logger.debug("received duplicate block of orphanChain, height:" + blockHeight + ", hash:" + blockHash);
                    return;
                }
                if (orphanChainStartHeight > blockHeight || blockHeight > orphanChainEndHeight || !orphanChain.getHashList().contains(blockPreviousHash)) continue;
                chainStorageService.save(chainId, block);
                Chain forkOrphanChain = ChainGenerator.generate(chainId, block, orphanChain, ChainTypeEnum.ORPHAN);
                BlockChainManager.addOrphanChain(chainId, forkOrphanChain);
                logger.info("received fork block of orphanChain, height:" + blockHeight + ", hash:" + blockHash);
                return;
            }
            chainStorageService.save(chainId, block);
            Chain newOrphanChain = ChainGenerator.generate(chainId, block, null, ChainTypeEnum.ORPHAN);
            BlockChainManager.addOrphanChain(chainId, newOrphanChain);
            logger.info("received orphan block, height:" + blockHeight + ", hash:" + blockHash);
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }

    public static SmallBlock getSmallBlock(int chainId, Block block) {
        ChainContext context = ContextManager.getContext(chainId);
        List<Integer> transactionType = context.getSystemTransactionType();
        if (transactionType.isEmpty()) {
            transactionType.addAll(TransactionCall.getSystemTypes(chainId));
        }
        SmallBlock smallBlock = new SmallBlock();
        smallBlock.setHeader(block.getHeader());
        smallBlock.setTxHashList((ArrayList)block.getTxHashList());
        block.getTxs().stream().filter(e -> transactionType.contains(e.getType())).forEach(arg_0 -> ((SmallBlock)smallBlock).addSystemTx(arg_0));
        return smallBlock;
    }

    public static Block assemblyBlock(BlockHeader header, Map<NulsHash, Transaction> txMap, List<NulsHash> txHashList) {
        Block block = new Block();
        block.setHeader(header);
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        for (NulsHash txHash : txHashList) {
            Transaction tx = txMap.get(txHash);
            if (null == tx) {
                throw new NulsRuntimeException(BlockErrorCode.DATA_ERROR);
            }
            tx.setBlockHeight(header.getHeight());
            txs.add(tx);
        }
        block.setTxs(txs);
        return block;
    }

    public static BlockHeader fromBlockHeaderPo(BlockHeaderPo po) {
        BlockHeader header = new BlockHeader();
        header.setHash(po.getHash());
        header.setHeight(po.getHeight());
        header.setExtend(po.getExtend());
        header.setPreHash(po.getPreHash());
        header.setTime(po.getTime());
        header.setMerkleHash(po.getMerkleHash());
        header.setTxCount(po.getTxCount());
        header.setBlockSignature(po.getBlockSignature());
        return header;
    }

    public static BlockHeaderPo toBlockHeaderPo(Block block) {
        BlockHeaderPo po = new BlockHeaderPo();
        BlockHeader blockHeader = block.getHeader();
        po.setHash(blockHeader.getHash());
        po.setPreHash(blockHeader.getPreHash());
        po.setMerkleHash(blockHeader.getMerkleHash());
        po.setTime(blockHeader.getTime());
        po.setHeight(blockHeader.getHeight());
        po.setTxCount(blockHeader.getTxCount());
        po.setBlockSignature(blockHeader.getBlockSignature());
        po.setExtend(blockHeader.getExtend());
        po.setTxHashList(block.getTxHashList());
        po.setComplete(false);
        po.setBlockSize(block.size());
        return po;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Block downloadBlockByHeight(int chainId, String nodeId, long height) {
        if (height < 0L || nodeId == null) {
            return null;
        }
        HeightMessage message = new HeightMessage(height);
        ChainContext context = ContextManager.getContext(chainId);
        int singleDownloadTimeout = context.getParameters().getSingleDownloadTimeout();
        NulsLogger logger = context.getLogger();
        NulsHash hash = NulsHash.calcHash((byte[])ByteUtils.longToBytes((long)height));
        CompletableFuture<Block> future = SingleBlockCacher.addRequest(chainId, hash);
        logger.debug("get block from " + nodeId + " begin, height-" + height);
        boolean result = NetworkCall.sendToNode(chainId, message, nodeId, "getBlockH");
        if (!result) {
            SingleBlockCacher.removeRequest(chainId, hash);
            return null;
        }
        try {
            Block block = (Block)future.get(singleDownloadTimeout, TimeUnit.MILLISECONDS);
            logger.debug("get block from " + nodeId + " success!, height-" + height);
            Block block2 = block;
            return block2;
        }
        catch (Exception e) {
            logger.error("get block from " + nodeId + " fail!, height-" + height, e);
            Block block = null;
            return block;
        }
        finally {
            SingleBlockCacher.removeRequest(chainId, hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Block downloadBlockByHash(int chainId, NulsHash hash, String nodeId, long height) {
        if (hash == null || nodeId == null) {
            return null;
        }
        HashMessage message = new HashMessage();
        message.setRequestHash(hash);
        ChainContext context = ContextManager.getContext(chainId);
        int singleDownloadTimeout = context.getParameters().getSingleDownloadTimeout();
        NulsLogger logger = context.getLogger();
        CompletableFuture<Block> future = SingleBlockCacher.addRequest(chainId, hash);
        logger.debug("get block-" + hash + " from " + nodeId + " begin, height-" + height);
        boolean result = NetworkCall.sendToNode(chainId, message, nodeId, "getBlock");
        if (!result) {
            SingleBlockCacher.removeRequest(chainId, hash);
            return null;
        }
        try {
            Block block = (Block)future.get(singleDownloadTimeout, TimeUnit.MILLISECONDS);
            logger.debug("get block-" + hash + " from " + nodeId + " success!, height-" + height);
            Block block2 = block;
            return block2;
        }
        catch (Exception e) {
            logger.error("get block-" + hash + " from " + nodeId + " fail!, height-" + height, e);
            Block block = null;
            return block;
        }
        finally {
            SingleBlockCacher.removeRequest(chainId, hash);
        }
    }
}

