/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.model.po;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class BlockChain
extends BaseNulsData {
    private int chainId;
    private String chainName;
    private String addressType;
    private String addressPrefix;
    private long magicNumber;
    private boolean supportInflowAsset;
    private int minAvailableNodeNum;
    private boolean isDelete = false;
    private long createTime;
    private long lastUpdateTime;
    private byte[] regAddress;
    private String regTxHash;
    private int regAssetId;
    private byte[] delAddress;
    private String delTxHash;
    private int delAssetId;
    List<String> selfAssetKeyList = new ArrayList<String>();
    List<String> totalAssetKeyList = new ArrayList<String>();
    List<String> verifierList = new ArrayList<String>();
    int signatureByzantineRatio = 0;
    int maxSignatureCount = 0;

    public void addCreateAssetId(String key) {
        this.selfAssetKeyList.add(key);
    }

    public void addCirculateAssetId(String key) {
        this.totalAssetKeyList.add(key);
    }

    public void removeCirculateAssetId(String key) {
        this.totalAssetKeyList.remove(key);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.chainId);
        stream.writeString(this.chainName);
        stream.writeString(this.addressType);
        stream.writeString(this.addressPrefix);
        stream.writeUint32(this.magicNumber);
        stream.writeBoolean(this.supportInflowAsset);
        stream.writeUint32((long)this.minAvailableNodeNum);
        stream.writeBoolean(this.isDelete);
        stream.writeUint32(this.createTime);
        stream.writeUint32(this.lastUpdateTime);
        stream.writeBytesWithLength(this.regAddress);
        stream.writeString(this.regTxHash);
        stream.writeUint16(this.regAssetId);
        stream.writeBytesWithLength(this.delAddress);
        stream.writeString(this.delTxHash);
        stream.writeUint16(this.delAssetId);
        stream.writeUint16(this.selfAssetKeyList.size());
        for (String key : this.selfAssetKeyList) {
            stream.writeString(key);
        }
        stream.writeUint16(this.totalAssetKeyList.size());
        for (String key : this.totalAssetKeyList) {
            stream.writeString(key);
        }
        stream.writeUint16(this.verifierList.size());
        for (String verifier : this.verifierList) {
            stream.writeString(verifier);
        }
        stream.writeUint16(this.signatureByzantineRatio);
        stream.writeUint16(this.maxSignatureCount);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readUint16();
        this.chainName = byteBuffer.readString();
        this.addressType = byteBuffer.readString();
        this.addressPrefix = byteBuffer.readString();
        this.magicNumber = byteBuffer.readInt32();
        this.supportInflowAsset = byteBuffer.readBoolean();
        this.minAvailableNodeNum = byteBuffer.readInt32();
        this.isDelete = byteBuffer.readBoolean();
        this.createTime = byteBuffer.readUint32();
        this.lastUpdateTime = byteBuffer.readUint32();
        this.regAddress = byteBuffer.readByLengthByte();
        this.regTxHash = byteBuffer.readString();
        this.regAssetId = byteBuffer.readUint16();
        this.delAddress = byteBuffer.readByLengthByte();
        this.delTxHash = byteBuffer.readString();
        this.delAssetId = byteBuffer.readUint16();
        int selfSize = byteBuffer.readUint16();
        for (int i = 0; i < selfSize; ++i) {
            this.selfAssetKeyList.add(byteBuffer.readString());
        }
        int totalSize = byteBuffer.readUint16();
        for (int i = 0; i < totalSize; ++i) {
            this.totalAssetKeyList.add(byteBuffer.readString());
        }
        int verifierCount = byteBuffer.readUint16();
        for (int i = 0; i < verifierCount; ++i) {
            String verifier = byteBuffer.readString();
            this.verifierList.add(verifier);
        }
        this.signatureByzantineRatio = byteBuffer.readUint16();
        this.maxSignatureCount = byteBuffer.readUint16();
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfString((String)this.chainName);
        size += SerializeUtils.sizeOfString((String)this.addressType);
        size += SerializeUtils.sizeOfString((String)this.addressPrefix);
        size += SerializeUtils.sizeOfInt32();
        size += SerializeUtils.sizeOfBoolean();
        size += SerializeUtils.sizeOfInt32();
        size += SerializeUtils.sizeOfBoolean();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfBytes((byte[])this.regAddress);
        size += SerializeUtils.sizeOfString((String)this.regTxHash);
        size += SerializeUtils.sizeOfInt16();
        size += SerializeUtils.sizeOfBytes((byte[])this.delAddress);
        size += SerializeUtils.sizeOfString((String)this.delTxHash);
        size += SerializeUtils.sizeOfInt16();
        size += SerializeUtils.sizeOfUint16();
        for (String key : this.selfAssetKeyList) {
            size += SerializeUtils.sizeOfString((String)key);
        }
        size += SerializeUtils.sizeOfUint16();
        for (String key : this.totalAssetKeyList) {
            size += SerializeUtils.sizeOfString((String)key);
        }
        size += SerializeUtils.sizeOfUint16();
        for (String verifier : this.verifierList) {
            size += SerializeUtils.sizeOfString((String)verifier);
        }
        size += SerializeUtils.sizeOfUint16();
        return size += SerializeUtils.sizeOfUint16();
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public long getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(long magicNumber) {
        this.magicNumber = magicNumber;
    }

    public boolean isSupportInflowAsset() {
        return this.supportInflowAsset;
    }

    public void setSupportInflowAsset(boolean supportInflowAsset) {
        this.supportInflowAsset = supportInflowAsset;
    }

    public int getMinAvailableNodeNum() {
        return this.minAvailableNodeNum;
    }

    public void setMinAvailableNodeNum(int minAvailableNodeNum) {
        this.minAvailableNodeNum = minAvailableNodeNum;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public void setDelete(boolean delete) {
        this.isDelete = delete;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public byte[] getRegAddress() {
        return this.regAddress;
    }

    public void setRegAddress(byte[] regAddress) {
        this.regAddress = regAddress;
    }

    public String getRegTxHash() {
        return this.regTxHash;
    }

    public void setRegTxHash(String regTxHash) {
        this.regTxHash = regTxHash;
    }

    public int getRegAssetId() {
        return this.regAssetId;
    }

    public void setRegAssetId(int regAssetId) {
        this.regAssetId = regAssetId;
    }

    public byte[] getDelAddress() {
        return this.delAddress;
    }

    public void setDelAddress(byte[] delAddress) {
        this.delAddress = delAddress;
    }

    public String getDelTxHash() {
        return this.delTxHash;
    }

    public void setDelTxHash(String delTxHash) {
        this.delTxHash = delTxHash;
    }

    public int getDelAssetId() {
        return this.delAssetId;
    }

    public void setDelAssetId(int delAssetId) {
        this.delAssetId = delAssetId;
    }

    public List<String> getSelfAssetKeyList() {
        return this.selfAssetKeyList;
    }

    public void setSelfAssetKeyList(List<String> selfAssetKeyList) {
        this.selfAssetKeyList = selfAssetKeyList;
    }

    public List<String> getTotalAssetKeyList() {
        return this.totalAssetKeyList;
    }

    public void setTotalAssetKeyList(List<String> totalAssetKeyList) {
        this.totalAssetKeyList = totalAssetKeyList;
    }

    public List<String> getVerifierList() {
        return this.verifierList;
    }

    public void setVerifierList(List<String> verifierList) {
        this.verifierList = verifierList;
    }

    public int getSignatureByzantineRatio() {
        return this.signatureByzantineRatio;
    }

    public void setSignatureByzantineRatio(int signatureByzantineRatio) {
        this.signatureByzantineRatio = signatureByzantineRatio;
    }

    public String getAddressPrefix() {
        return this.addressPrefix;
    }

    public void setAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
    }

    public int getMaxSignatureCount() {
        return this.maxSignatureCount;
    }

    public void setMaxSignatureCount(int maxSignatureCount) {
        this.maxSignatureCount = maxSignatureCount;
    }

    public void map2pojo(Map<String, Object> map) {
        this.setAddressType(String.valueOf(map.get("addressType")));
        this.setChainId(Integer.valueOf(map.get("chainId").toString()));
        if (null == map.get("addressPrefix") || String.valueOf(map.get("addressPrefix")).equals("")) {
            this.setAddressPrefix(AddressTool.getPrefix((int)this.getChainId()));
        } else {
            this.setAddressPrefix(String.valueOf(map.get("addressPrefix")).toUpperCase());
        }
        this.setChainName(String.valueOf(map.get("chainName")));
        this.setMagicNumber(Long.valueOf(map.get("magicNumber").toString()));
        this.setMinAvailableNodeNum(Integer.valueOf(map.get("minAvailableNodeNum").toString()));
        this.setRegAddress(AddressTool.getAddress((String)map.get("address").toString()));
        this.setCreateTime(NulsDateUtils.getCurrentTimeSeconds());
        String[] verifierList = String.valueOf(map.get("verifierList")).split(",");
        this.setVerifierList(Arrays.asList(verifierList));
        this.setSignatureByzantineRatio(Integer.valueOf(map.get("signatureByzantineRatio").toString()));
        this.setMaxSignatureCount(Integer.valueOf(map.get("maxSignatureCount").toString()));
    }
}

