/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.model.po;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.model.po.ChainAsset;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CacheDatas
extends BaseNulsData {
    private List<BlockChain> blockChains = new ArrayList<BlockChain>();
    private List<Asset> assets = new ArrayList<Asset>();
    private List<ChainAsset> chainAssets = new ArrayList<ChainAsset>();

    public void addBlockChain(BlockChain blockChain) {
        if (null != blockChain) {
            this.blockChains.add(blockChain);
        }
    }

    public void addAsset(Asset asset) {
        if (null != asset) {
            this.assets.add(asset);
        }
    }

    public void addChainAsset(ChainAsset chainAsset) {
        if (null != chainAsset) {
            this.chainAssets.add(chainAsset);
        }
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.blockChains.size());
        for (BlockChain blockChain : this.blockChains) {
            stream.writeNulsData((BaseNulsData)blockChain);
        }
        stream.writeUint16(this.assets.size());
        for (Asset asset : this.assets) {
            stream.writeNulsData((BaseNulsData)asset);
        }
        stream.writeUint16(this.chainAssets.size());
        for (ChainAsset chainAsset : this.chainAssets) {
            stream.writeNulsData((BaseNulsData)chainAsset);
        }
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        int blockChainsSize = byteBuffer.readUint16();
        for (int i = 0; i < blockChainsSize; ++i) {
            BlockChain blockChain = new BlockChain();
            blockChain.parse(byteBuffer);
            this.blockChains.add(blockChain);
        }
        int assetsSize = byteBuffer.readUint16();
        for (int i = 0; i < assetsSize; ++i) {
            Asset asset = new Asset();
            asset.parse(byteBuffer);
            this.assets.add(asset);
        }
        int chainAssetsSize = byteBuffer.readUint16();
        for (int i = 0; i < chainAssetsSize; ++i) {
            ChainAsset chainAsset = new ChainAsset();
            chainAsset.parse(byteBuffer);
            this.chainAssets.add(chainAsset);
        }
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        for (BlockChain blockChain : this.blockChains) {
            size += blockChain.size();
        }
        size += SerializeUtils.sizeOfUint16();
        for (Asset asset : this.assets) {
            size += asset.size();
        }
        size += SerializeUtils.sizeOfUint16();
        for (ChainAsset chainAsset : this.chainAssets) {
            size += chainAsset.size();
        }
        return size;
    }

    public List<BlockChain> getBlockChains() {
        return this.blockChains;
    }

    public void setBlockChains(List<BlockChain> blockChains) {
        this.blockChains = blockChains;
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setAssets(List<Asset> assets) {
        this.assets = assets;
    }

    public List<ChainAsset> getChainAssets() {
        return this.chainAssets;
    }

    public void setChainAssets(List<ChainAsset> chainAssets) {
        this.chainAssets = chainAssets;
    }
}

