/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.model.tx.txdatav5;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.chain.model.tx.txdatav5.TxAsset;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TxChain
extends BaseNulsData {
    private String name;
    private short addressType;
    private String addressPrefix;
    private long magicNumber;
    private boolean supportInflowAsset = true;
    private int minAvailableNodeNum = 1;
    List<String> verifierList = new ArrayList<String>();
    int signatureByzantineRatio = 0;
    int maxSignatureCount = 0;
    private TxAsset defaultAsset = new TxAsset();

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeString(this.name);
        stream.writeUint8(this.addressType);
        stream.writeString(this.addressPrefix);
        stream.writeUint32(this.magicNumber);
        stream.writeBoolean(this.supportInflowAsset);
        stream.writeUint32((long)this.minAvailableNodeNum);
        stream.writeUint16(this.verifierList.size());
        for (String verifier : this.verifierList) {
            stream.writeString(verifier);
        }
        stream.writeUint16(this.signatureByzantineRatio);
        stream.writeUint16(this.maxSignatureCount);
        stream.writeNulsData((BaseNulsData)this.defaultAsset);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.name = byteBuffer.readString();
        this.addressType = byteBuffer.readUint8();
        this.addressPrefix = byteBuffer.readString();
        this.magicNumber = byteBuffer.readUint32();
        this.supportInflowAsset = byteBuffer.readBoolean();
        this.minAvailableNodeNum = byteBuffer.readInt32();
        int verifierCount = byteBuffer.readUint16();
        for (int i = 0; i < verifierCount; ++i) {
            String verifier = byteBuffer.readString();
            this.verifierList.add(verifier);
        }
        this.signatureByzantineRatio = byteBuffer.readUint16();
        this.maxSignatureCount = byteBuffer.readUint16();
        this.defaultAsset = (TxAsset)byteBuffer.readNulsData((BaseNulsData)new TxAsset());
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfString((String)this.name);
        size += SerializeUtils.sizeOfUint8();
        size += SerializeUtils.sizeOfString((String)this.addressPrefix);
        size += SerializeUtils.sizeOfUint32();
        size += SerializeUtils.sizeOfBoolean();
        size += SerializeUtils.sizeOfInt32();
        size += SerializeUtils.sizeOfUint16();
        for (String verifier : this.verifierList) {
            size += SerializeUtils.sizeOfString((String)verifier);
        }
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfUint16();
        return size += SerializeUtils.sizeOfNulsData((NulsData)this.defaultAsset);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public short getAddressType() {
        return this.addressType;
    }

    public void setAddressType(short addressType) {
        this.addressType = addressType;
    }

    public long getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(long magicNumber) {
        this.magicNumber = magicNumber;
    }

    public boolean isSupportInflowAsset() {
        return this.supportInflowAsset;
    }

    public void setSupportInflowAsset(boolean supportInflowAsset) {
        this.supportInflowAsset = supportInflowAsset;
    }

    public int getMinAvailableNodeNum() {
        return this.minAvailableNodeNum;
    }

    public void setMinAvailableNodeNum(int minAvailableNodeNum) {
        this.minAvailableNodeNum = minAvailableNodeNum;
    }

    public TxAsset getDefaultAsset() {
        return this.defaultAsset;
    }

    public void setDefaultAsset(TxAsset defaultAsset) {
        this.defaultAsset = defaultAsset;
    }

    public List<String> getVerifierList() {
        return this.verifierList;
    }

    public void setVerifierList(List<String> verifierList) {
        this.verifierList = verifierList;
    }

    public int getSignatureByzantineRatio() {
        return this.signatureByzantineRatio;
    }

    public void setSignatureByzantineRatio(int signatureByzantineRatio) {
        this.signatureByzantineRatio = signatureByzantineRatio;
    }

    public String getAddressPrefix() {
        return this.addressPrefix;
    }

    public void setAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
    }

    public int getMaxSignatureCount() {
        return this.maxSignatureCount;
    }

    public void setMaxSignatureCount(int maxSignatureCount) {
        this.maxSignatureCount = maxSignatureCount;
    }
}

