/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.rpc.cmd;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.nuls.base.data.CoinData;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.chain.info.CmErrorCode;
import io.nuls.chain.info.CmRuntimeInfo;
import io.nuls.chain.model.dto.AccountBalance;
import io.nuls.chain.model.dto.ChainDto;
import io.nuls.chain.model.dto.RegChainDto;
import io.nuls.chain.model.po.Asset;
import io.nuls.chain.model.po.BlockChain;
import io.nuls.chain.model.tx.RegisterChainAndAssetTransaction;
import io.nuls.chain.rpc.call.RpcService;
import io.nuls.chain.rpc.cmd.BaseChainCmd;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.util.ChainManagerUtil;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.chain.util.TxUtil;
import io.nuls.common.NulsCoresConfig;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.CM)
public class CmmChainCmd
extends BaseChainCmd {
    @Autowired
    private ChainService chainService;
    @Autowired
    private AssetService assetService;
    @Autowired
    private RpcService rpcService;
    @Autowired
    NulsCoresConfig nulsChainConfig;

    @CmdAnnotation(cmd="cm_chain", version=1.0, description="View chain information")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]")})
    @ResponseData(description="Return Chain Information", responseType=@TypeDescriptor(value=RegChainDto.class))
    public Response chain(Map params) {
        try {
            int chainId = Integer.parseInt(params.get("chainId").toString());
            BlockChain blockChain = this.chainService.getChain(chainId);
            if (blockChain == null) {
                return this.failed(CmErrorCode.ERROR_CHAIN_NOT_FOUND);
            }
            RegChainDto regChainDto = new RegChainDto();
            regChainDto.buildRegChainDto(blockChain);
            regChainDto.setMainNetCrossConnectSeeds(this.rpcService.getCrossChainSeeds());
            regChainDto.setMainNetVerifierSeeds(this.rpcService.getChainPackerInfo(CmRuntimeInfo.getMainIntChainId()));
            return this.success(regChainDto);
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(CmErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="cm_chainReg", version=1.0, description="Chain registration-Cross chain registration for parallel chains")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[3-65535]", parameterDes="Asset ChainId,Value range[3-65535]"), @Parameter(parameterName="chainName", requestType=@TypeDescriptor(value=String.class), parameterDes="Chain Name"), @Parameter(parameterName="addressType", requestType=@TypeDescriptor(value=int.class), parameterDes="1 applyNULSThe chain of framework construction Within the ecosystem,2Outside the ecosystem"), @Parameter(parameterName="addressPrefix", requestType=@TypeDescriptor(value=String.class), parameterDes="Chain Address Prefix,1-5character"), @Parameter(parameterName="magicNumber", requestType=@TypeDescriptor(value=long.class), parameterDes="Network Magic Parameters"), @Parameter(parameterName="minAvailableNodeNum", requestType=@TypeDescriptor(value=int.class), parameterDes="Minimum number of connections"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]"), @Parameter(parameterName="symbol", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset symbols"), @Parameter(parameterName="assetName", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset Name"), @Parameter(parameterName="initNumber", requestType=@TypeDescriptor(value=String.class), parameterDes="Initial value of assets"), @Parameter(parameterName="decimalPlaces", requestType=@TypeDescriptor(value=short.class), parameterDes="Decimal Places of Assets"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Create an account address for the transaction"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="Account password"), @Parameter(parameterName="verifierList", requestType=@TypeDescriptor(value=String.class), parameterDes="Verifier Address List,Comma division"), @Parameter(parameterName="signatureBFTRatio", requestType=@TypeDescriptor(value=Integer.class), parameterDes="Byzantine proportion,A value greater than or equal to this is a valid confirmation"), @Parameter(parameterName="maxSignatureCount", requestType=@TypeDescriptor(value=Integer.class), parameterDes="Maximum number of signatures,Limit the maximum number of verifier signature lists")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", valueType=String.class, description="transactionhashvalue"), @Key(name="mainNetVerifierList", valueType=String.class, description="List of main network validators,Comma separated"), @Key(name="mainNetCrossSeedList", valueType=String.class, description="Main network verification seed node list,Comma separated")}))
    public Response chainReg(Map params) {
        HashMap<String, String> rtMap = new HashMap<String, String>(1);
        try {
            BlockChain blockChain = new BlockChain();
            blockChain.map2pojo(params);
            String addressPrefix = (String)params.get("addressPrefix");
            if (StringUtils.isBlank((String)addressPrefix)) {
                return this.failed(CmErrorCode.ERROR_CHAIN_ADDRESS_PREFIX);
            }
            char[] arr = addressPrefix.toCharArray();
            if (arr.length > 5) {
                return this.failed(CmErrorCode.ERROR_CHAIN_ADDRESS_PREFIX);
            }
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] < '0' || arr[i] > '9' && arr[i] < 'A' || arr[i] > 'Z' && arr[i] < 'a') && arr[i] <= 'z') continue;
                return this.failed(CmErrorCode.ERROR_CHAIN_ADDRESS_PREFIX);
            }
            Asset asset = new Asset();
            asset.map2pojo(params);
            if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
                return this.failed(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
            }
            if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getSymbol())) {
                return this.failed(CmErrorCode.ERROR_ASSET_SYMBOL);
            }
            if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getAssetName())) {
                return this.failed(CmErrorCode.ERROR_ASSET_NAME);
            }
            short version = ProtocolGroupManager.getCurrentVersion((int)this.nulsChainConfig.getMainChainId());
            asset.setChainId(blockChain.getChainId());
            if (version < 7) {
                asset.setDepositNuls(this.nulsChainConfig.getAssetDepositNuls());
                asset.setDestroyNuls(this.nulsChainConfig.getAssetDestroyNuls());
            } else {
                asset.setDepositNuls(BigInteger.ZERO);
                asset.setDestroyNuls(BigInteger.ZERO);
            }
            asset.setAvailable(true);
            BlockChain dbChain = this.chainService.getChain(blockChain.getChainId());
            if (null != dbChain && dbChain.isDelete()) {
                return this.failed(CmErrorCode.ERROR_CHAIN_REG_CMD);
            }
            if (null != dbChain) {
                return this.failed(CmErrorCode.ERROR_CHAIN_ID_EXIST);
            }
            if (this.chainService.hadExistMagicNumber(blockChain.getMagicNumber())) {
                return this.failed(CmErrorCode.ERROR_MAGIC_NUMBER_EXIST);
            }
            if (this.chainService.hadExistChainName(blockChain.getChainName())) {
                return this.failed(CmErrorCode.ERROR_CHAIN_NAME_EXIST);
            }
            RegisterChainAndAssetTransaction tx = new RegisterChainAndAssetTransaction();
            if (ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId()) >= 5) {
                tx.setTxData(TxUtil.parseChainToTxV5(blockChain, asset).serialize());
            } else {
                tx.setTxData(TxUtil.parseChainToTx(blockChain, asset).serialize());
            }
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            AccountBalance accountBalance = new AccountBalance(null, null);
            ErrorCode ldErrorCode = this.rpcService.getCoinData(String.valueOf(params.get("address")), accountBalance);
            if (null != ldErrorCode) {
                return this.failed(ldErrorCode);
            }
            CoinData coinData = version < 7 ? this.getRegCoinData(asset, CmRuntimeInfo.getMainIntChainId(), CmRuntimeInfo.getMainIntAssetId(), tx.size(), accountBalance) : this.getRegCoinDataV7(asset, CmRuntimeInfo.getMainIntChainId(), CmRuntimeInfo.getMainIntAssetId(), tx.size(), accountBalance);
            tx.setCoinData(coinData.serialize());
            ErrorCode acErrorCode = this.rpcService.transactionSignature(CmRuntimeInfo.getMainIntChainId(), (String)params.get("address"), (String)params.get("password"), tx);
            if (null != acErrorCode) {
                return this.failed(acErrorCode);
            }
            rtMap.put("txHash", tx.getHash().toHex());
            rtMap.put("mainNetCrossConnectSeeds", this.rpcService.getCrossChainSeeds());
            rtMap.put("mainNetVerifierSeeds", this.rpcService.getChainPackerInfo(CmRuntimeInfo.getMainIntChainId()));
            ErrorCode txErrorCode = this.rpcService.newTx(tx);
            if (null != txErrorCode) {
                return this.failed(txErrorCode);
            }
        }
        catch (NulsRuntimeException e) {
            LoggerUtil.logger().error(e);
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(CmErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="cm_chainActive", version=1.0, description="Chain update activation-Cross chain update activation for parallel chains\uff08Activate previously logged out chains\uff09")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]"), @Parameter(parameterName="chainName", requestType=@TypeDescriptor(value=String.class), parameterDes="Chain Name"), @Parameter(parameterName="addressType", requestType=@TypeDescriptor(value=int.class), parameterDes="1 applyNULSThe chain of framework construction Within the ecosystem,2Outside the ecosystem"), @Parameter(parameterName="addressPrefix", requestType=@TypeDescriptor(value=String.class), parameterDes="Chain Address Prefix,1-5character"), @Parameter(parameterName="magicNumber", requestType=@TypeDescriptor(value=long.class), parameterDes="Network Magic Parameters"), @Parameter(parameterName="minAvailableNodeNum", requestType=@TypeDescriptor(value=int.class), parameterDes="Minimum number of connections"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]"), @Parameter(parameterName="symbol", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset symbols"), @Parameter(parameterName="assetName", requestType=@TypeDescriptor(value=String.class), parameterDes="Asset Name"), @Parameter(parameterName="initNumber", requestType=@TypeDescriptor(value=String.class), parameterDes="Initial value of assets"), @Parameter(parameterName="decimalPlaces", requestType=@TypeDescriptor(value=short.class), parameterDes="Decimal Places of Assets"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Create an account address for the transaction"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="Account password"), @Parameter(parameterName="verifierList", requestType=@TypeDescriptor(value=String.class), parameterDes="Verifier Address List,Comma division"), @Parameter(parameterName="signatureBFTRatio", requestType=@TypeDescriptor(value=Integer.class), parameterDes="Byzantine proportion,A value greater than or equal to this is a valid confirmation"), @Parameter(parameterName="maxSignatureCount", requestType=@TypeDescriptor(value=Integer.class), parameterDes="Maximum number of signatures,Limit the maximum number of verifier signature lists")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", valueType=String.class, description="transactionhashvalue"), @Key(name="mainNetVerifierSeeds", valueType=String.class, description="Main network validator seed list,Comma separated"), @Key(name="mainNetCrossConnectSeeds", valueType=String.class, description="Main network verification seed node list,Comma separated")}))
    public Response chainActive(Map params) {
        HashMap<String, String> rtMap = new HashMap<String, String>(1);
        try {
            BlockChain blockChain = new BlockChain();
            blockChain.map2pojo(params);
            String addressPrefix = (String)params.get("addressPrefix");
            if (StringUtils.isBlank((String)addressPrefix)) {
                return this.failed(CmErrorCode.ERROR_CHAIN_ADDRESS_PREFIX);
            }
            char[] arr = addressPrefix.toCharArray();
            if (arr.length > 5) {
                return this.failed(CmErrorCode.ERROR_CHAIN_ADDRESS_PREFIX);
            }
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] < '0' || arr[i] > '9' && arr[i] < 'A' || arr[i] > 'Z' && arr[i] < 'a') && arr[i] <= 'z') continue;
                return this.failed(CmErrorCode.ERROR_CHAIN_ADDRESS_PREFIX);
            }
            Asset asset = new Asset();
            asset.map2pojo(params);
            if (asset.getDecimalPlaces() < Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMin()) || asset.getDecimalPlaces() > Integer.valueOf(this.nulsChainConfig.getAssetDecimalPlacesMax())) {
                return this.failed(CmErrorCode.ERROR_ASSET_DECIMALPLACES);
            }
            if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getSymbol())) {
                return this.failed(CmErrorCode.ERROR_ASSET_SYMBOL);
            }
            if (!FormatValidUtils.validTokenNameOrSymbolV15((String)asset.getAssetName())) {
                return this.failed(CmErrorCode.ERROR_ASSET_NAME);
            }
            short version = ProtocolGroupManager.getCurrentVersion((int)this.nulsChainConfig.getMainChainId());
            asset.setChainId(blockChain.getChainId());
            if (version < 7) {
                asset.setDepositNuls(this.nulsChainConfig.getAssetDepositNuls());
                asset.setDestroyNuls(this.nulsChainConfig.getAssetDestroyNuls());
            } else {
                asset.setDepositNuls(BigInteger.ZERO);
                asset.setDestroyNuls(BigInteger.ZERO);
            }
            asset.setAvailable(true);
            BlockChain dbChain = this.chainService.getChain(blockChain.getChainId());
            if (null == dbChain) {
                return this.failed(CmErrorCode.ERROR_CHAIN_NOT_FOUND);
            }
            if (null != dbChain && !dbChain.isDelete()) {
                return this.failed(CmErrorCode.ERROR_CHAIN_ACTIVE);
            }
            if (this.chainService.hadExistMagicNumber(blockChain.getMagicNumber()) && !dbChain.isDelete()) {
                return this.failed(CmErrorCode.ERROR_MAGIC_NUMBER_EXIST);
            }
            if (this.chainService.hadExistChainName(blockChain.getChainName()) && !dbChain.isDelete()) {
                LoggerUtil.COMMON_LOG.debug("######### delete={}", new Object[]{dbChain.isDelete()});
                return this.failed(CmErrorCode.ERROR_CHAIN_NAME_EXIST);
            }
            RegisterChainAndAssetTransaction tx = new RegisterChainAndAssetTransaction();
            if (ChainManagerUtil.getVersion(CmRuntimeInfo.getMainIntChainId()) >= 5) {
                tx.setTxData(TxUtil.parseChainToTxV5(blockChain, asset).serialize());
            } else {
                tx.setTxData(TxUtil.parseChainToTx(blockChain, asset).serialize());
            }
            tx.setTime(NulsDateUtils.getCurrentTimeSeconds());
            AccountBalance accountBalance = new AccountBalance(null, null);
            ErrorCode ldErrorCode = this.rpcService.getCoinData(String.valueOf(params.get("address")), accountBalance);
            if (null != ldErrorCode) {
                return this.failed(ldErrorCode);
            }
            CoinData coinData = version < 7 ? this.getRegCoinData(asset, CmRuntimeInfo.getMainIntChainId(), CmRuntimeInfo.getMainIntAssetId(), tx.size(), accountBalance) : this.getRegCoinDataV7(asset, CmRuntimeInfo.getMainIntChainId(), CmRuntimeInfo.getMainIntAssetId(), tx.size(), accountBalance);
            tx.setCoinData(coinData.serialize());
            ErrorCode acErrorCode = this.rpcService.transactionSignature(CmRuntimeInfo.getMainIntChainId(), (String)params.get("address"), (String)params.get("password"), tx);
            if (null != acErrorCode) {
                return this.failed(acErrorCode);
            }
            rtMap.put("txHash", tx.getHash().toHex());
            rtMap.put("mainNetCrossConnectSeeds", this.rpcService.getCrossChainSeeds());
            rtMap.put("mainNetVerifierSeeds", this.rpcService.getChainPackerInfo(CmRuntimeInfo.getMainIntChainId()));
            ErrorCode txErrorCode = this.rpcService.newTx(tx);
            if (null != txErrorCode) {
                return this.failed(txErrorCode);
            }
        }
        catch (NulsRuntimeException e) {
            LoggerUtil.logger().error(e);
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(CmErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="getCrossChainInfos", version=1.0, description="Obtain cross chain registration asset information")
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, collectionElement=List.class, mapKeys={@Key(name="chainInfos", valueType=List.class, valueElement=ChainDto.class, description="Registered Chain and Asset Information List")}))
    public Response getCrossChainInfos(Map params) {
        ArrayList<Map<String, Object>> chainInfos = new ArrayList<Map<String, Object>>();
        HashMap<String, ArrayList<Map<String, Object>>> rtMap = new HashMap<String, ArrayList<Map<String, Object>>>();
        try {
            List<BlockChain> blockChains = this.chainService.getBlockList();
            for (BlockChain blockChain : blockChains) {
                chainInfos.add(this.chainService.getBlockAssetsInfo(blockChain));
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
        }
        rtMap.put("chainInfos", chainInfos);
        try {
            LoggerUtil.COMMON_LOG.debug(JSONUtils.obj2json(chainInfos));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return this.success(rtMap);
    }

    @CmdAnnotation(cmd="cm_getChainsSimpleInfo", version=1.0, description="Obtain a list of cross chain registered chains")
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, collectionElement=List.class, mapKeys={@Key(name="chainInfos", valueType=List.class, valueElement=Map.class, description="Return a brief list of chain and asset information")}))
    public Response getChainAssetsSimpleInfo(Map params) {
        ArrayList<Map<String, Object>> chainInfos = new ArrayList<Map<String, Object>>();
        HashMap<String, ArrayList<Map<String, Object>>> rtMap = new HashMap<String, ArrayList<Map<String, Object>>>();
        try {
            List<BlockChain> blockChains = this.chainService.getBlockList();
            for (BlockChain blockChain : blockChains) {
                chainInfos.add(this.chainService.getChainAssetsSimpleInfo(blockChain));
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
        }
        rtMap.put("chainInfos", chainInfos);
        return this.success(rtMap);
    }
}

