/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.chain.rpc.cmd;

import io.nuls.base.RPCUtil;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.chain.info.CmErrorCode;
import io.nuls.chain.model.dto.ChainAssetTotalCirculate;
import io.nuls.chain.model.dto.ChainEventResult;
import io.nuls.chain.model.dto.CoinDataAssets;
import io.nuls.chain.model.po.CacheDatas;
import io.nuls.chain.model.po.ChainAsset;
import io.nuls.chain.rpc.cmd.BaseChainCmd;
import io.nuls.chain.service.AssetService;
import io.nuls.chain.service.CacheDataService;
import io.nuls.chain.service.ChainService;
import io.nuls.chain.service.MessageService;
import io.nuls.chain.service.TxCirculateService;
import io.nuls.chain.service.ValidateService;
import io.nuls.chain.util.LoggerUtil;
import io.nuls.chain.util.TxUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.model.ObjectUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.CM)
public class TxCirculateCmd
extends BaseChainCmd {
    @Autowired
    private AssetService assetService;
    @Autowired
    private ChainService chainService;
    @Autowired
    private ValidateService validateService;
    @Autowired
    private CacheDataService cacheDataService;
    @Autowired
    private TxCirculateService txCirculateService;
    @Autowired
    private MessageService messageService;

    @CmdAnnotation(cmd="cm_getCirculateChainAsset", version=1.0, description="Query asset information")
    @Parameters(value={@Parameter(parameterName="circulateChainId", parameterType="int", parameterValidRange="[1-65535]", parameterDes="Running ChainID,Value range[1-65535]"), @Parameter(parameterName="assetChainId", parameterType="int", parameterValidRange="[1-65535]", parameterDes="Asset ChainId,Value range[1-65535]"), @Parameter(parameterName="assetId", parameterType="int", parameterValidRange="[1-65535]", parameterDes="assetId,Value range[1-65535]")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="circulateChainId", valueType=Integer.class, description="Running ChainID"), @Key(name="assetChainId", valueType=Integer.class, description="Asset ChainID"), @Key(name="assetId", valueType=Integer.class, description="assetID"), @Key(name="initNumber", valueType=BigInteger.class, description="Initial asset quantity"), @Key(name="chainAssetAmount", valueType=BigInteger.class, description="Number of existing assets")}))
    public Response getCirculateChainAsset(Map params) {
        try {
            int circulateChainId = Integer.valueOf(params.get("circulateChainId").toString());
            int assetChainId = Integer.valueOf(params.get("assetChainId").toString());
            int assetId = Integer.valueOf(params.get("assetId").toString());
            ChainAsset chainAsset = this.txCirculateService.getCirculateChainAsset(circulateChainId, assetChainId, assetId);
            HashMap<String, Number> resultMap = new HashMap<String, Number>();
            resultMap.put("circulateChainId", circulateChainId);
            resultMap.put("assetChainId", assetChainId);
            resultMap.put("assetId", assetId);
            if (null != chainAsset) {
                resultMap.put("initNumber", chainAsset.getInitNumber());
                resultMap.put("chainAssetAmount", chainAsset.getInNumber().subtract(chainAsset.getOutNumber()));
                return this.success(resultMap);
            }
            return this.failed(CmErrorCode.ERROR_ASSET_NOT_EXIST);
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(CmErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="cm_assetCirculateValidator", version=1.0, description="Query asset information")
    @Parameters(value={@Parameter(parameterName="chainId", parameterType="int", parameterValidRange="[1-65535]", parameterDes="Running ChainID,Value range[1-65535]"), @Parameter(parameterName="tx", parameterType="String", parameterDes="transactionHexvalue")})
    @ResponseData(description="No specific return value, validation successful without errors")
    public Response assetCirculateValidator(Map params) {
        try {
            Map<String, BigInteger> toAssetMap;
            Map<String, BigInteger> fromAssetMap;
            int toChainId;
            String txHex = String.valueOf(params.get("tx"));
            Transaction tx = TxUtil.buildTxData(txHex);
            if (null == tx) {
                return this.failed(CmErrorCode.ERROR_TX_HEX);
            }
            List<CoinDataAssets> list = this.txCirculateService.getChainAssetList(tx.getCoinData());
            CoinDataAssets fromCoinDataAssets = list.get(0);
            CoinDataAssets toCoinDataAssets = list.get(1);
            int fromChainId = fromCoinDataAssets.getChainId();
            ChainEventResult chainEventResult = this.validateService.assetCirculateValidator(fromChainId, toChainId = toCoinDataAssets.getChainId(), fromAssetMap = fromCoinDataAssets.getAssetsMap(), toAssetMap = toCoinDataAssets.getAssetsMap());
            if (chainEventResult.isSuccess()) {
                HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
                resultMap.put("value", true);
                return this.success(resultMap);
            }
            LoggerUtil.COMMON_LOG.error("--------assetCirculateValidator error:" + chainEventResult.getErrorCode().getCode());
            return this.failed(chainEventResult.getErrorCode());
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(CmErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="cm_assetCirculateCommit", version=1.0, description="Query asset information")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainID,Value range[1-65535]"), @Parameter(parameterName="txList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="transactionHexValue List"), @Parameter(parameterName="blockHeader", requestType=@TypeDescriptor(value=String.class), parameterDes="Block headHexvalue")})
    @ResponseData(description="No specific return value, submit successfully without errors")
    public Response assetCirculateCommit(Map params) {
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"));
            ObjectUtils.canNotEmpty(params.get("blockHeader"));
            Integer chainId = (Integer)params.get("chainId");
            List txHexList = (List)params.get("txList");
            String blockHeaderStr = (String)params.get("blockHeader");
            BlockHeader blockHeader = new BlockHeader();
            blockHeader.parse(RPCUtil.decode((String)blockHeaderStr), 0);
            long commitHeight = blockHeader.getHeight();
            ArrayList<Transaction> txList = new ArrayList<Transaction>();
            Response parseResponse = this.parseTxs(txHexList, txList);
            if (!parseResponse.isSuccess()) {
                return parseResponse;
            }
            this.cacheDataService.bakBlockTxs(chainId, commitHeight, txList, true);
            this.cacheDataService.beginBakBlockHeight(chainId, commitHeight);
            try {
                this.txCirculateService.circulateCommit(txList);
                this.cacheDataService.endBakBlockHeight(chainId, commitHeight);
            }
            catch (Exception e) {
                LoggerUtil.logger().error(e);
                this.cacheDataService.rollBlockTxs(chainId, commitHeight);
                return this.failed(e.getMessage());
            }
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(e.getMessage());
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("value", true);
        return this.success(resultMap);
    }

    @CmdAnnotation(cmd="cm_assetCirculateRollBack", version=1.0, description="Query asset information")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Running ChainID,Value range[1-65535]"), @Parameter(parameterName="txList", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="transactionHexValue List"), @Parameter(parameterName="blockHeader", requestType=@TypeDescriptor(value=String.class), parameterDes="Block headHexvalue")})
    @ResponseData(description="No specific return value, validation successful without errors")
    public Response assetCirculateRollBack(Map params) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("value", true);
        try {
            ObjectUtils.canNotEmpty(params.get("chainId"));
            ObjectUtils.canNotEmpty(params.get("blockHeader"));
            Integer chainId = (Integer)params.get("chainId");
            List txHexList = (List)params.get("txList");
            String blockHeaderStr = (String)params.get("blockHeader");
            BlockHeader blockHeader = new BlockHeader();
            blockHeader.parse(RPCUtil.decode((String)blockHeaderStr), 0);
            long commitHeight = blockHeader.getHeight();
            ArrayList<Transaction> txList = new ArrayList<Transaction>();
            Response parseResponse = this.parseTxs(txHexList, txList);
            if (!parseResponse.isSuccess()) {
                return parseResponse;
            }
            CacheDatas circulateTxDatas = this.cacheDataService.getCacheDatas(commitHeight - 1L);
            if (null == circulateTxDatas) {
                LoggerUtil.logger().info("chain module height ={} bak datas is null,maybe had rolled", new Object[]{commitHeight});
                return this.success(resultMap);
            }
            this.cacheDataService.rollBlockTxs(chainId, commitHeight);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return this.failed(e.getMessage());
        }
        return this.success(resultMap);
    }

    @CmdAnnotation(cmd="updateChainAsset", version=1.0, description="Query and update circulating asset information")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterValidRange="[1-65535]", parameterDes="Asset ChainID,Value range[1-65535]"), @Parameter(parameterName="assets", requestType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="assetId", valueType=Integer.class, description="assetid"), @Key(name="availableAmount", valueType=BigInteger.class, description="Available amount"), @Key(name="freeze", valueType=BigInteger.class, description="Freeze amount")}), parameterDes="assetidlist")})
    @ResponseData(description="No specific return value, validation successful without errors")
    public Response updateChainAsset(Map params) {
        List assets = new ArrayList();
        int chainId = 0;
        try {
            LoggerUtil.logger().debug("updateChainAsset json={}", new Object[]{JSONUtils.obj2json((Object)params)});
            chainId = Integer.valueOf(params.get("chainId").toString());
            assets = (List)params.get("assets");
        }
        catch (Exception e) {
            LoggerUtil.logger().error(e);
            return this.failed(CmErrorCode.ERROR_PARAMETER);
        }
        ArrayList<ChainAssetTotalCirculate> chainAssetTotalCirculates = new ArrayList<ChainAssetTotalCirculate>();
        for (Map asset : assets) {
            ChainAssetTotalCirculate chainAssetTotalCirculate = new ChainAssetTotalCirculate();
            chainAssetTotalCirculate.setAssetId(Integer.valueOf(asset.get("assetId").toString()));
            chainAssetTotalCirculate.setChainId(chainId);
            chainAssetTotalCirculate.setAvailableAmount(new BigInteger(asset.get("availableAmount").toString()));
            chainAssetTotalCirculate.setFreeze(new BigInteger(asset.get("freeze").toString()));
            chainAssetTotalCirculates.add(chainAssetTotalCirculate);
        }
        this.messageService.recChainIssuingAssets(chainId, chainAssetTotalCirculates);
        return this.success();
    }
}

